/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.Freezer;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWEntity;
import com.unlikepaladin.pfm.blocks.KitchenDrawer;
import com.unlikepaladin.pfm.blocks.blockentities.FridgeBlockEntity;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Fridge
extends HorizontalFacingBlockWEntity {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private final Block baseBlock;
    private final BlockState baseBlockState;
    private Supplier<Block> freezer;
    private static final List<FurnitureBlock> FRIDGES = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape FRIDGE = Shapes.m_83124_((VoxelShape)Fridge.m_49796_((double)0.5, (double)0.0, (double)3.0, (double)15.5, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Fridge.m_49796_((double)12.98, (double)4.0, (double)0.03, (double)13.98, (double)20.0, (double)1.03), Fridge.m_49796_((double)12.98, (double)4.0, (double)0.92, (double)13.98, (double)5.0, (double)2.92), Fridge.m_49796_((double)12.98, (double)18.98, (double)1.0, (double)13.98, (double)19.98, (double)2.9), Fridge.m_49796_((double)0.5, (double)1.0, (double)1.93, (double)14.78, (double)19.98, (double)3.03)});
    protected static final VoxelShape FRIDGE_OPEN = Shapes.m_83124_((VoxelShape)Fridge.m_49796_((double)0.5, (double)0.0, (double)3.0, (double)15.5, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Fridge.m_49796_((double)-1.41, (double)4.0, (double)-10.39, (double)-0.41, (double)19.98, (double)-9.39), Fridge.m_49796_((double)-0.52, (double)4.0, (double)-10.39, (double)1.48, (double)5.0, (double)-9.39), Fridge.m_49796_((double)-0.45, (double)18.98, (double)-10.39, (double)1.45, (double)19.98, (double)-9.39), Fridge.m_49796_((double)0.5, (double)1.0, (double)-11.59, (double)1.48, (double)20.0, (double)3.11), Fridge.m_49796_((double)0.75, (double)7.7, (double)-10.42, (double)3.75, (double)10.8, (double)2.98), Fridge.m_49796_((double)0.75, (double)12.2, (double)-10.42, (double)3.75, (double)15.3, (double)2.98)});
    protected static final VoxelShape FRIDGE_SOUTH = KitchenDrawer.rotateShape(Direction.NORTH, Direction.SOUTH, FRIDGE);
    protected static final VoxelShape FRIDGE_SOUTH_OPEN = KitchenDrawer.rotateShape(Direction.NORTH, Direction.SOUTH, FRIDGE_OPEN);
    protected static final VoxelShape FRIDGE_EAST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.EAST, FRIDGE);
    protected static final VoxelShape FRIDGE_EAST_OPEN = KitchenDrawer.rotateShape(Direction.NORTH, Direction.EAST, FRIDGE_OPEN);
    protected static final VoxelShape FRIDGE_WEST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.WEST, FRIDGE);
    protected static final VoxelShape FRIDGE_WEST_OPEN = KitchenDrawer.rotateShape(Direction.NORTH, Direction.WEST, FRIDGE_OPEN);

    public Fridge(BlockBehaviour.Properties settings, Supplier<Block> freezer) {
        super(settings);
        this.freezer = freezer;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        FRIDGES.add(new FurnitureBlock((Block)this, "fridge"));
    }

    public static Stream<FurnitureBlock> streamFridges() {
        return FRIDGES.stream();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        stateManager.m_61104_(new Property[]{OPEN});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7494_()).m_60795_() || world.m_8055_(pos.m_7494_()).m_60734_() == this.freezer;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        world.m_7731_(pos.m_7494_(), (BlockState)this.freezer.get().m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_()), 3);
        if (itemStack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof FridgeBlockEntity) {
            ((FridgeBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
        }
        super.m_6402_(world, pos, state, placer, itemStack);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122434_() != Direction.Axis.Y == (direction == Direction.UP) && neighborState.m_60734_() != this.freezer.get()) {
            return Blocks.f_50016_.m_49966_();
        }
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            player.m_5893_((MenuProvider)((FridgeBlockEntity)blockEntity));
            player.m_36220_(Statistics.FRIDGE_OPENED);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
        BlockState blockState2;
        BlockPos blockPos = pos.m_7494_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60713_(state.m_60734_()) || blockState.m_60734_() instanceof Freezer) {
            blockState2 = blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            world.m_7731_(blockPos, blockState2, 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        if ((blockState = world.m_8055_(blockPos = pos.m_7495_())).m_60713_(state.m_60734_()) || blockState.m_60734_() instanceof Freezer) {
            blockState2 = blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            world.m_7731_(blockPos, blockState2, 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        if (blockPos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(blockPos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
        }
        return null;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && player.m_7500_()) {
            this.onBreakInCreative(world, pos, state, player);
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.m_60713_((Block)this)) {
            return true;
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        Boolean open = (Boolean)state.m_61143_((Property)OPEN);
        switch (dir) {
            case NORTH: {
                if (open.booleanValue()) {
                    return FRIDGE_SOUTH_OPEN;
                }
                return FRIDGE_SOUTH;
            }
            case SOUTH: {
                if (open.booleanValue()) {
                    return FRIDGE_OPEN;
                }
                return FRIDGE;
            }
            case EAST: {
                if (open.booleanValue()) {
                    return FRIDGE_WEST_OPEN;
                }
                return FRIDGE_WEST;
            }
        }
        if (open.booleanValue()) {
            return FRIDGE_EAST_OPEN;
        }
        return FRIDGE_EAST;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FridgeBlockEntity(pos, state);
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }
}

