/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.BasicTable;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWEntity;
import com.unlikepaladin.pfm.blocks.blockentities.LightSwitchBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LightSwitch
extends HorizontalFacingBlockWEntity {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public LightSwitchBlockEntity lightSwitchBlockEntity;
    private static final List<LightSwitch> LIGHT_SWITCHES = new ArrayList<LightSwitch>();
    private static final VoxelShape lightSwitch = Shapes.m_83124_((VoxelShape)LightSwitch.m_49796_((double)5.0, (double)3.0, (double)15.0, (double)11.0, (double)11.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape lightSwitchSouth = BasicTable.rotateShape(Direction.NORTH, Direction.SOUTH, lightSwitch);
    private static final VoxelShape lightSwitchEast = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, lightSwitch);
    private static final VoxelShape lightSwitchWest = BasicTable.rotateShape(Direction.NORTH, Direction.WEST, lightSwitch);

    public LightSwitch(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        LIGHT_SWITCHES.add(this);
    }

    public static Stream<LightSwitch> streamlightSwitches() {
        return LIGHT_SWITCHES.stream();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            BlockState blockState = (BlockState)state.m_61122_((Property)POWERED);
            if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
                // empty if block
            }
            return InteractionResult.SUCCESS;
        }
        this.lightSwitchBlockEntity = (LightSwitchBlockEntity)world.m_7702_(pos);
        BlockState blockState = this.togglePower(state, world, pos, false, false);
        float f = (Boolean)blockState.m_61143_((Property)POWERED) != false ? 0.9f : 0.8f;
        world.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, f);
        world.m_142346_((Entity)player, (Boolean)blockState.m_61143_((Property)POWERED) != false ? GameEvent.f_223702_ : GameEvent.f_223703_, pos);
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        CompoundTag nbtCompound;
        if (itemStack.m_41782_() && (nbtCompound = itemStack.m_41737_("BlockEntityTag")).m_128441_("lights")) {
            this.lightSwitchBlockEntity.m_183515_(nbtCompound);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWERED});
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public BlockState togglePower(BlockState state, Level world, BlockPos pos, boolean listenTo, boolean toggleTo) {
        state = listenTo ? (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(toggleTo)) : (BlockState)state.m_61122_((Property)POWERED);
        world.m_7731_(pos, state, 3);
        this.updateNeighbors(state, world, pos);
        this.lightSwitchBlockEntity = (LightSwitchBlockEntity)world.m_7702_(pos);
        this.lightSwitchBlockEntity.setState((Boolean)state.m_61143_((Property)POWERED));
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = LightSwitch.getDirection(state);
        switch (facing) {
            case SOUTH: {
                return lightSwitchSouth;
            }
            case EAST: {
                return lightSwitchEast;
            }
            case WEST: {
                return lightSwitchWest;
            }
        }
        return lightSwitch;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && LightSwitch.getDirection(state) == direction) {
            return 15;
        }
        return 0;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.updateNeighbors(state, world, pos);
        }
    }

    private void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_121945_(LightSwitch.getDirection(state).m_122424_()), (Block)this);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (this.lightSwitchBlockEntity != null) {
            this.togglePower(state, world, pos, true, false);
        }
        this.m_142387_(world, player, pos, state);
        if (state.m_204336_(BlockTags.f_13088_)) {
            PiglinAi.m_34873_((Player)player, (boolean)false);
        }
        world.m_142346_((Entity)player, GameEvent.f_157794_, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        this.lightSwitchBlockEntity = new LightSwitchBlockEntity(pos, state);
        return this.lightSwitchBlockEntity;
    }

    protected static Direction getDirection(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }
}

