/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.ClassicTable;
import com.unlikepaladin.pfm.blocks.MiddleShape;
import com.unlikepaladin.pfm.compat.PaladinFurnitureModConfig;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LogTable
extends HorizontalDirectionalBlock {
    private final Block baseBlock;
    public static final EnumProperty<MiddleShape> SHAPE = EnumProperty.m_61587_((String)"table_type", MiddleShape.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> WOOD_LOG_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_NATURAL_TABLES = new ArrayList<FurnitureBlock>();
    static final VoxelShape LOG_TABLE = Shapes.m_83124_((VoxelShape)LogTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{LogTable.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)4.5, (double)14.0, (double)11.0), LogTable.m_49796_((double)11.5, (double)0.0, (double)5.0, (double)14.0, (double)14.0, (double)11.0)});
    static final VoxelShape LOG_TABLE_MIDDLE = Shapes.m_83124_((VoxelShape)LogTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    static final VoxelShape LOG_TABLE_ONE = Shapes.m_83110_((VoxelShape)LogTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)LogTable.m_49796_((double)6.0, (double)0.0, (double)5.0, (double)8.5, (double)14.0, (double)11.0));
    static final VoxelShape LOG_TABLE_ONE_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, LOG_TABLE_ONE);
    static final VoxelShape LOG_TABLE_ONE_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, LOG_TABLE_ONE);
    static final VoxelShape LOG_TABLE_ONE_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, LOG_TABLE_ONE);
    static final VoxelShape LOG_TABLE_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, LOG_TABLE);

    public LogTable(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(SHAPE, (Comparable)((Object)MiddleShape.SINGLE))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        if ((this.f_60442_.equals(Material.f_76320_) || this.f_60442_.equals(Material.f_76321_)) && ((Object)((Object)this)).getClass().isAssignableFrom(LogTable.class)) {
            WOOD_LOG_TABLES.add(new FurnitureBlock((Block)this, "table_"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ClassicTable.class)) {
            STONE_NATURAL_TABLES.add(new FurnitureBlock((Block)this, "natural_table"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodLogTables() {
        return WOOD_LOG_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneNaturalTables() {
        return STONE_NATURAL_TABLES.stream();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
        stateManager.m_61104_(new Property[]{FACING});
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
        return this.getShape(blockState, (LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), (Direction)blockState.m_61143_((Property)FACING));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.m_122434_().m_122479_() ? this.getShape(state, world, pos, (Direction)state.m_61143_((Property)FACING)) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private boolean isTable(LevelAccessor world, BlockPos pos, Direction direction, Direction tableDirection) {
        BlockState state = world.m_8055_(pos.m_121945_(direction));
        if (this.canConnect(state)) {
            Direction sourceDirection = (Direction)state.m_61143_((Property)FACING);
            return sourceDirection.equals((Object)tableDirection);
        }
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }

    boolean canConnect(BlockState blockState) {
        PaladinFurnitureMod.getPFMConfig();
        return PaladinFurnitureModConfig.doTablesOfDifferentMaterialsConnect() ? blockState.m_60734_() instanceof LogTable : blockState.m_60734_() == this;
    }

    public BlockState getShape(BlockState state, LevelAccessor world, BlockPos pos, Direction dir) {
        boolean left = this.isTable(world, pos, dir.m_122428_(), dir);
        boolean right = this.isTable(world, pos, dir.m_122427_(), dir);
        if (left && right) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)MiddleShape.MIDDLE));
        }
        if (left) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)MiddleShape.RIGHT));
        }
        if (right) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)MiddleShape.LEFT));
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)MiddleShape.SINGLE));
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    protected MiddleShape getShape(BlockState state) {
        return (MiddleShape)((Object)state.m_61143_(SHAPE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        MiddleShape tableShape = this.getShape(state);
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        boolean dirNorthOrSouth = dir.equals((Object)Direction.NORTH) || dir.equals((Object)Direction.SOUTH);
        boolean dirWestOrEast = dir.equals((Object)Direction.WEST) || dir.equals((Object)Direction.EAST);
        switch (tableShape) {
            case LEFT: {
                if (dirNorthOrSouth) {
                    return LOG_TABLE_ONE;
                }
                if (dirWestOrEast) {
                    return LOG_TABLE_ONE_WEST;
                }
                return LOG_TABLE;
            }
            case RIGHT: {
                if (dirNorthOrSouth) {
                    return LOG_TABLE_ONE_SOUTH;
                }
                if (dirWestOrEast) {
                    return LOG_TABLE_ONE_EAST;
                }
                return LOG_TABLE;
            }
            case MIDDLE: {
                return LOG_TABLE_MIDDLE;
            }
        }
        if (dirWestOrEast) {
            return LOG_TABLE_EAST;
        }
        return LOG_TABLE;
    }
}

