/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.DyeableFurniture;
import com.unlikepaladin.pfm.blocks.LogTable;
import com.unlikepaladin.pfm.blocks.MiddleShape;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleBed
extends BedBlock
implements DyeableFurniture {
    public static EnumProperty<MiddleShape> SHAPE = EnumProperty.m_61587_((String)"shape", MiddleShape.class);
    private static final List<FurnitureBlock> SIMPLE_BEDS = new ArrayList<FurnitureBlock>();
    public static final BooleanProperty BUNK = BooleanProperty.m_61465_((String)"bunk");
    static final VoxelShape HEAD = Shapes.m_83124_((VoxelShape)SimpleBed.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), (VoxelShape[])new VoxelShape[]{SimpleBed.m_49796_((double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)9.0, (double)16.0), SimpleBed.m_49796_((double)1.0, (double)9.0, (double)3.0, (double)15.0, (double)10.0, (double)11.0)});
    static final VoxelShape HEAD_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD);
    static final VoxelShape HEAD_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, HEAD);
    static final VoxelShape HEAD_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, HEAD);
    static final VoxelShape FOOT = Shapes.m_83110_((VoxelShape)SimpleBed.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.0, (double)13.0), (VoxelShape)SimpleBed.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)10.0, (double)16.0));
    static final VoxelShape FOOT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT);
    static final VoxelShape FOOT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT);
    static final VoxelShape FOOT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT);
    static final VoxelShape FOOT_FOOT_R = SimpleBed.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)2.0, (double)16.0);
    static final VoxelShape FOOT_FOOT_L = SimpleBed.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)2.0, (double)16.0);
    static final VoxelShape FOOT_HEAD_R = SimpleBed.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)3.0);
    static final VoxelShape FOOT_HEAD_L = SimpleBed.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)3.0);
    static final VoxelShape HEAD_SINGLE = Shapes.m_83124_((VoxelShape)HEAD, (VoxelShape[])new VoxelShape[]{FOOT_HEAD_L, FOOT_HEAD_R});
    static final VoxelShape HEAD_SINGLE_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD_SINGLE);
    static final VoxelShape HEAD_SINGLE_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, HEAD_SINGLE);
    static final VoxelShape HEAD_SINGLE_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, HEAD_SINGLE);
    static final VoxelShape FOOT_SINGLE = Shapes.m_83124_((VoxelShape)FOOT, (VoxelShape[])new VoxelShape[]{FOOT_FOOT_L, FOOT_FOOT_R});
    static final VoxelShape FOOT_SINGLE_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_SINGLE);
    static final VoxelShape FOOT_SINGLE_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_SINGLE);
    static final VoxelShape FOOT_SINGLE_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_SINGLE);
    static final VoxelShape HEAD_LEFT = Shapes.m_83110_((VoxelShape)HEAD, (VoxelShape)FOOT_HEAD_L);
    static final VoxelShape HEAD_LEFT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD_LEFT);
    static final VoxelShape HEAD_LEFT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, HEAD_LEFT);
    static final VoxelShape HEAD_LEFT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, HEAD_LEFT);
    static final VoxelShape FOOT_LEFT = Shapes.m_83110_((VoxelShape)FOOT, (VoxelShape)FOOT_FOOT_L);
    static final VoxelShape FOOT_LEFT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_LEFT);
    static final VoxelShape FOOT_LEFT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_LEFT);
    static final VoxelShape FOOT_LEFT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_LEFT);
    static final VoxelShape HEAD_RIGHT = Shapes.m_83110_((VoxelShape)HEAD, (VoxelShape)FOOT_HEAD_R);
    static final VoxelShape HEAD_RIGHT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD_RIGHT);
    static final VoxelShape HEAD_RIGHT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, HEAD_RIGHT);
    static final VoxelShape HEAD_RIGHT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, HEAD_RIGHT);
    static final VoxelShape FOOT_RIGHT = Shapes.m_83110_((VoxelShape)FOOT, (VoxelShape)FOOT_FOOT_R);
    static final VoxelShape FOOT_RIGHT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_RIGHT);
    static final VoxelShape FOOT_RIGHT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_RIGHT);
    static final VoxelShape FOOT_RIGHT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_RIGHT);
    static final VoxelShape HEAD_BUNK = SimpleBed.m_49796_((double)0.0, (double)-2.0, (double)0.0, (double)16.0, (double)2.0, (double)3.0);
    static final VoxelShape HEAD_BUNK_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD_BUNK);
    static final VoxelShape HEAD_BUNK_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, HEAD_BUNK);
    static final VoxelShape HEAD_BUNK_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, HEAD_BUNK);
    static final VoxelShape HEAD_SINGLE_BUNK = Shapes.m_83110_((VoxelShape)HEAD_SINGLE, (VoxelShape)HEAD_BUNK);
    static final VoxelShape HEAD_SINGLE_SOUTH_BUNK = Shapes.m_83110_((VoxelShape)HEAD_SINGLE_SOUTH, (VoxelShape)HEAD_BUNK_SOUTH);
    static final VoxelShape HEAD_SINGLE_EAST_BUNK = Shapes.m_83110_((VoxelShape)HEAD_SINGLE_EAST, (VoxelShape)HEAD_BUNK_EAST);
    static final VoxelShape HEAD_SINGLE_WEST_BUNK = Shapes.m_83110_((VoxelShape)HEAD_SINGLE_WEST, (VoxelShape)HEAD_BUNK_WEST);
    static final VoxelShape FOOT_BUNK_LEFT = SimpleBed.m_49796_((double)0.0, (double)-6.0, (double)13.0, (double)3.0, (double)0.0, (double)16.0);
    static final VoxelShape FOOT_BUNK_LEFT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_BUNK_LEFT);
    static final VoxelShape FOOT_BUNK_LEFT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_BUNK_LEFT);
    static final VoxelShape FOOT_BUNK_LEFT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_BUNK_LEFT);
    static final VoxelShape FOOT_BUNK_RIGHT = SimpleBed.m_49796_((double)13.0, (double)-6.0, (double)13.0, (double)16.0, (double)0.0, (double)16.0);
    static final VoxelShape FOOT_BUNK_RIGHT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_BUNK_RIGHT);
    static final VoxelShape FOOT_BUNK_RIGHT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_BUNK_RIGHT);
    static final VoxelShape FOOT_BUNK_RIGHT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_BUNK_RIGHT);
    static final VoxelShape FOOT_SINGLE_BUNK = Shapes.m_83124_((VoxelShape)FOOT_SINGLE, (VoxelShape[])new VoxelShape[]{FOOT_BUNK_LEFT, FOOT_BUNK_RIGHT});
    static final VoxelShape FOOT_SINGLE_SOUTH_BUNK = Shapes.m_83124_((VoxelShape)FOOT_SINGLE_SOUTH, (VoxelShape[])new VoxelShape[]{FOOT_BUNK_LEFT_SOUTH, FOOT_BUNK_RIGHT_SOUTH});
    static final VoxelShape FOOT_SINGLE_EAST_BUNK = Shapes.m_83124_((VoxelShape)FOOT_SINGLE_EAST, (VoxelShape[])new VoxelShape[]{FOOT_BUNK_LEFT_EAST, FOOT_BUNK_RIGHT_EAST});
    static final VoxelShape FOOT_SINGLE_WEST_BUNK = Shapes.m_83124_((VoxelShape)FOOT_SINGLE_WEST, (VoxelShape[])new VoxelShape[]{FOOT_BUNK_LEFT_WEST, FOOT_BUNK_RIGHT_WEST});
    static final VoxelShape FOOT_LEFT_BUNK = Shapes.m_83110_((VoxelShape)FOOT_LEFT, (VoxelShape)FOOT_BUNK_LEFT);
    static final VoxelShape FOOT_LEFT_SOUTH_BUNK = Shapes.m_83110_((VoxelShape)FOOT_LEFT_SOUTH, (VoxelShape)FOOT_BUNK_LEFT_SOUTH);
    static final VoxelShape FOOT_LEFT_EAST_BUNK = Shapes.m_83110_((VoxelShape)FOOT_LEFT_EAST, (VoxelShape)FOOT_BUNK_LEFT_EAST);
    static final VoxelShape FOOT_LEFT_WEST_BUNK = Shapes.m_83110_((VoxelShape)FOOT_LEFT_WEST, (VoxelShape)FOOT_BUNK_LEFT_WEST);
    static final VoxelShape FOOT_RIGHT_BUNK = Shapes.m_83110_((VoxelShape)FOOT_RIGHT, (VoxelShape)FOOT_BUNK_RIGHT);
    static final VoxelShape FOOT_RIGHT_SOUTH_BUNK = Shapes.m_83110_((VoxelShape)FOOT_RIGHT_SOUTH, (VoxelShape)FOOT_BUNK_RIGHT_SOUTH);
    static final VoxelShape FOOT_RIGHT_EAST_BUNK = Shapes.m_83110_((VoxelShape)FOOT_RIGHT_EAST, (VoxelShape)FOOT_BUNK_RIGHT_EAST);
    static final VoxelShape FOOT_RIGHT_WEST_BUNK = Shapes.m_83110_((VoxelShape)FOOT_RIGHT_WEST, (VoxelShape)FOOT_BUNK_RIGHT_WEST);

    public SimpleBed(DyeColor color, BlockBehaviour.Properties settings) {
        super(color, settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_49440_, (Comparable)BedPart.FOOT)).m_61124_((Property)f_49441_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BUNK, (Comparable)Boolean.valueOf(false))).m_61124_(SHAPE, (Comparable)((Object)MiddleShape.SINGLE)));
        if (this.getClass().isAssignableFrom(SimpleBed.class)) {
            String bedColor = color.m_41065_();
            SIMPLE_BEDS.add(new FurnitureBlock((Block)this, bedColor + "_simple_bed"));
        }
    }

    public static Stream<FurnitureBlock> streamSimpleBeds() {
        return SIMPLE_BEDS.stream();
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
        Direction direction = ctx.m_8125_();
        BlockPos blockPos = ctx.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        if (ctx.m_43725_().m_8055_(blockPos2).m_60629_(ctx)) {
            return this.getShape(blockState, (LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), (Direction)blockState.m_61143_((Property)f_54117_));
        }
        return null;
    }

    private static Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_((Property)f_49440_) != BedPart.HEAD && !((state = world.m_8055_(pos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)))).m_60734_() instanceof SimpleBed)) {
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.m_49488_((Level)world)) {
            world.m_7471_(pos, false);
            BlockPos blockPos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
            if (world.m_8055_(blockPos).m_60713_((Block)this)) {
                world.m_7471_(blockPos, false);
            }
            Vec3 centerPos = pos.m_252807_();
            world.m_254951_(null, world.m_269111_().m_269488_(centerPos), null, centerPos, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)f_49441_)).booleanValue()) {
            if (!this.isFree(world, pos)) {
                player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.m_7720_(pos).ifLeft(reason -> {
            if (reason != null) {
                player.m_5661_(reason.m_36423_(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    private boolean isFree(Level world, BlockPos pos) {
        List list = world.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == SimpleBed.getDirectionTowardsOtherPart((BedPart)state.m_61143_((Property)f_49440_), (Direction)state.m_61143_((Property)f_54117_))) {
            if (neighborState.m_60734_() instanceof SimpleBed && neighborState.m_61143_((Property)f_49440_) != state.m_61143_((Property)f_49440_)) {
                return (BlockState)state.m_61124_((Property)f_49441_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_49441_)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        return this.getShape(state, world, pos, (Direction)state.m_61143_((Property)f_54117_));
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart;
        if (!world.f_46443_ && player.m_7500_() && (bedPart = (BedPart)state.m_61143_((Property)f_49440_)) == BedPart.FOOT && (blockState = world.m_8055_(blockPos = pos.m_121945_(SimpleBed.getDirectionTowardsOtherPart(bedPart, (Direction)state.m_61143_((Property)f_54117_))))).m_60713_((Block)this) && blockState.m_61143_((Property)f_49440_) == BedPart.HEAD) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        this.m_142387_(world, player, pos, state);
        if (state.m_204336_(BlockTags.f_13088_)) {
            PiglinAi.m_34873_((Player)player, (boolean)false);
        }
        world.m_142346_((Entity)player, GameEvent.f_157794_, pos);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
        stateManager.m_61104_(new Property[]{BUNK});
        super.m_7926_(stateManager);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public boolean isBed(LevelAccessor world, BlockPos pos, Direction direction, Direction bedDirection, BlockState originalState) {
        BlockState state = world.m_8055_(pos.m_121945_(direction));
        if (state.m_60734_().getClass().isAssignableFrom(SimpleBed.class) && state.m_60734_() instanceof SimpleBed && state.m_61143_((Property)f_49440_) == originalState.m_61143_((Property)f_49440_)) {
            Direction sourceDirection = (Direction)state.m_61143_((Property)f_54117_);
            return sourceDirection.equals((Object)bedDirection);
        }
        return false;
    }

    public BlockState getShape(BlockState state, LevelAccessor world, BlockPos pos, Direction dir) {
        boolean left = this.isBed(world, pos, dir.m_122428_(), dir, state);
        boolean right = this.isBed(world, pos, dir.m_122427_(), dir, state);
        state = left && right ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)MiddleShape.MIDDLE)) : (left ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)MiddleShape.RIGHT)) : (right ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)MiddleShape.LEFT)) : (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)MiddleShape.SINGLE))));
        boolean down = this.isBed(world, pos, Direction.DOWN, dir, state);
        state = down ? (BlockState)state.m_61124_((Property)BUNK, (Comparable)Boolean.valueOf(true)) : (BlockState)state.m_61124_((Property)BUNK, (Comparable)Boolean.valueOf(false));
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        BedPart bedPart = (BedPart)state.m_61143_((Property)f_49440_);
        MiddleShape middleShape = (MiddleShape)((Object)state.m_61143_(SHAPE));
        boolean bunk = (Boolean)state.m_61143_((Property)BUNK);
        if (!bunk) {
            switch (middleShape) {
                case MIDDLE: {
                    switch (dir) {
                        case NORTH: {
                            if (bedPart == BedPart.HEAD) {
                                return HEAD;
                            }
                            return FOOT;
                        }
                        case EAST: {
                            if (bedPart == BedPart.HEAD) {
                                return HEAD_EAST;
                            }
                            return FOOT_EAST;
                        }
                        case WEST: {
                            if (bedPart == BedPart.HEAD) {
                                return HEAD_WEST;
                            }
                            return FOOT_WEST;
                        }
                    }
                    if (bedPart == BedPart.HEAD) {
                        return HEAD_SOUTH;
                    }
                    return FOOT_SOUTH;
                }
                case SINGLE: {
                    switch (dir) {
                        case NORTH: {
                            if (bedPart == BedPart.HEAD) {
                                return HEAD_SINGLE;
                            }
                            return FOOT_SINGLE;
                        }
                        case EAST: {
                            if (bedPart == BedPart.HEAD) {
                                return HEAD_SINGLE_EAST;
                            }
                            return FOOT_SINGLE_EAST;
                        }
                        case WEST: {
                            if (bedPart == BedPart.HEAD) {
                                return HEAD_SINGLE_WEST;
                            }
                            return FOOT_SINGLE_WEST;
                        }
                    }
                    if (bedPart == BedPart.HEAD) {
                        return HEAD_SINGLE_SOUTH;
                    }
                    return FOOT_SINGLE_SOUTH;
                }
                case RIGHT: {
                    switch (dir) {
                        case NORTH: {
                            if (bedPart == BedPart.HEAD) {
                                return HEAD_RIGHT;
                            }
                            return FOOT_RIGHT;
                        }
                        case EAST: {
                            if (bedPart == BedPart.HEAD) {
                                return HEAD_RIGHT_EAST;
                            }
                            return FOOT_RIGHT_EAST;
                        }
                        case WEST: {
                            if (bedPart == BedPart.HEAD) {
                                return HEAD_RIGHT_WEST;
                            }
                            return FOOT_RIGHT_WEST;
                        }
                    }
                    if (bedPart == BedPart.HEAD) {
                        return HEAD_RIGHT_SOUTH;
                    }
                    return FOOT_RIGHT_SOUTH;
                }
            }
            switch (dir) {
                case NORTH: {
                    if (bedPart == BedPart.HEAD) {
                        return HEAD_LEFT;
                    }
                    return FOOT_LEFT;
                }
                case EAST: {
                    if (bedPart == BedPart.HEAD) {
                        return HEAD_LEFT_EAST;
                    }
                    return FOOT_LEFT_EAST;
                }
                case WEST: {
                    if (bedPart == BedPart.HEAD) {
                        return HEAD_LEFT_WEST;
                    }
                    return FOOT_LEFT_WEST;
                }
            }
            if (bedPart == BedPart.HEAD) {
                return HEAD_LEFT_SOUTH;
            }
            return FOOT_LEFT_SOUTH;
        }
        if (bedPart == BedPart.HEAD) {
            switch (dir) {
                case NORTH: {
                    return HEAD_SINGLE_BUNK;
                }
                case EAST: {
                    return HEAD_SINGLE_EAST_BUNK;
                }
                case WEST: {
                    return HEAD_SINGLE_WEST_BUNK;
                }
            }
            return HEAD_SINGLE_SOUTH_BUNK;
        }
        switch (middleShape) {
            case SINGLE: {
                switch (dir) {
                    case NORTH: {
                        return FOOT_SINGLE_BUNK;
                    }
                    case EAST: {
                        return FOOT_SINGLE_EAST_BUNK;
                    }
                    case WEST: {
                        return FOOT_SINGLE_WEST_BUNK;
                    }
                }
                return FOOT_SINGLE_SOUTH_BUNK;
            }
            case MIDDLE: {
                switch (dir) {
                    case NORTH: {
                        return FOOT;
                    }
                    case EAST: {
                        return FOOT_EAST;
                    }
                    case WEST: {
                        return FOOT_WEST;
                    }
                }
                return FOOT_SOUTH;
            }
            case RIGHT: {
                switch (dir) {
                    case NORTH: {
                        return FOOT_RIGHT_BUNK;
                    }
                    case EAST: {
                        return FOOT_RIGHT_EAST_BUNK;
                    }
                    case WEST: {
                        return FOOT_RIGHT_WEST_BUNK;
                    }
                }
                return FOOT_RIGHT_SOUTH_BUNK;
            }
        }
        switch (dir) {
            case NORTH: {
                return FOOT_LEFT_BUNK;
            }
            case EAST: {
                return FOOT_LEFT_EAST_BUNK;
            }
            case WEST: {
                return FOOT_LEFT_WEST_BUNK;
            }
        }
        return FOOT_LEFT_SOUTH_BUNK;
    }
}

