/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.Fridge;
import com.unlikepaladin.pfm.blocks.KitchenDrawer;
import com.unlikepaladin.pfm.blocks.blockentities.FridgeBlockEntity;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class XboxFridge
extends Fridge {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final VoxelShape XBOX_FRIDGE = Shapes.m_83124_((VoxelShape)XboxFridge.m_49796_((double)0.5, (double)1.0, (double)3.0, (double)15.5, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{XboxFridge.m_49796_((double)1.0, (double)0.0, (double)2.84, (double)15.0, (double)1.0, (double)15.84), XboxFridge.m_49796_((double)0.51, (double)1.0, (double)1.91, (double)15.31, (double)16.0, (double)2.91)});
    protected static final VoxelShape XBOX_FRIDGE_UPPER = Shapes.m_83124_((VoxelShape)XboxFridge.m_49796_((double)0.5, (double)-15.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{XboxFridge.m_49796_((double)1.0, (double)-16.0, (double)2.84, (double)15.0, (double)-15.0, (double)15.84), XboxFridge.m_49796_((double)0.51, (double)0.0, (double)1.91, (double)15.31, (double)16.0, (double)2.91)});
    protected static final VoxelShape XBOX_FRIDGE_OPEN = Shapes.m_83124_((VoxelShape)XboxFridge.m_49796_((double)0.5, (double)1.0, (double)3.0, (double)15.5, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{XboxFridge.m_49796_((double)1.0, (double)0.0, (double)2.84, (double)15.0, (double)1.0, (double)15.84), XboxFridge.m_49796_((double)0.5, (double)16.0, (double)-11.69, (double)1.5, (double)32.0, (double)3.11)});
    protected static final VoxelShape XBOX_FRIDGE_UPPER_OPEN = Shapes.m_83124_((VoxelShape)XboxFridge.m_49796_((double)0.5, (double)-15.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{XboxFridge.m_49796_((double)1.0, (double)-16.0, (double)2.84, (double)15.0, (double)-15.0, (double)15.84), XboxFridge.m_49796_((double)0.5, (double)0.0, (double)-11.69, (double)1.5, (double)16.0, (double)3.11)});
    protected static final VoxelShape XBOX_FRIDGE_SOUTH = KitchenDrawer.rotateShape(Direction.NORTH, Direction.SOUTH, XBOX_FRIDGE);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_SOUTH = KitchenDrawer.rotateShape(Direction.NORTH, Direction.SOUTH, XBOX_FRIDGE_UPPER);
    protected static final VoxelShape XBOX_FRIDGE_OPEN_SOUTH = KitchenDrawer.rotateShape(Direction.NORTH, Direction.SOUTH, XBOX_FRIDGE_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_OPEN_SOUTH = KitchenDrawer.rotateShape(Direction.NORTH, Direction.SOUTH, XBOX_FRIDGE_UPPER_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_EAST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.EAST, XBOX_FRIDGE);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_EAST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.EAST, XBOX_FRIDGE_UPPER);
    protected static final VoxelShape XBOX_FRIDGE_OPEN_EAST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.EAST, XBOX_FRIDGE_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_OPEN_EAST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.EAST, XBOX_FRIDGE_UPPER_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_WEST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.WEST, XBOX_FRIDGE);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_WEST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.WEST, XBOX_FRIDGE_UPPER);
    protected static final VoxelShape XBOX_FRIDGE_OPEN_WEST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.WEST, XBOX_FRIDGE_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_OPEN_WEST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.WEST, XBOX_FRIDGE_UPPER_OPEN);

    public XboxFridge(BlockBehaviour.Properties settings, Supplier<Block> freezer) {
        super(settings, freezer);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        stateManager.m_61104_(new Property[]{OPEN});
        stateManager.m_61104_(new Property[]{HALF});
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            player.m_5893_((MenuProvider)((FridgeBlockEntity)blockEntity));
            player.m_36220_(Statistics.FRIDGE_OPENED);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
        if (itemStack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof FridgeBlockEntity) {
            ((FridgeBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
        }
    }

    @Override
    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && player.m_7500_()) {
            this.onBreakInCreative(world, pos, state, player);
        }
        super.m_5707_(world, pos, state, player);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP) && neighborState.m_60713_((Block)this) && neighborState.m_61143_(HALF) != doubleBlockHalf) {
            return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)neighborState.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)neighborState.m_61143_((Property)OPEN)));
        }
        return state;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return blockState.m_60783_((BlockGetter)world, blockPos, Direction.UP);
        }
        return blockState.m_60713_((Block)this);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        if (blockPos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(blockPos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockState blockState2;
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60713_(state.m_60734_())) {
            blockState2 = blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            world.m_7731_(blockPos, blockState2, 35);
        }
        if ((blockState = world.m_8055_(blockPos = pos.m_7494_())).m_60713_(state.m_60734_())) {
            blockState2 = blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            world.m_7731_(blockPos, blockState2, 35);
        }
        super.m_6786_(world, pos, state);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        Boolean open = (Boolean)state.m_61143_((Property)OPEN);
        Enum half = (Enum)((Object)state.m_61143_(HALF));
        switch (dir) {
            case NORTH: {
                if (half == DoubleBlockHalf.UPPER) {
                    if (open.booleanValue()) {
                        return XBOX_FRIDGE_UPPER_OPEN_SOUTH;
                    }
                    return XBOX_FRIDGE_UPPER_SOUTH;
                }
                if (open.booleanValue()) {
                    return XBOX_FRIDGE_OPEN_SOUTH;
                }
                return XBOX_FRIDGE_SOUTH;
            }
            case SOUTH: {
                if (half == DoubleBlockHalf.UPPER) {
                    if (open.booleanValue()) {
                        return XBOX_FRIDGE_UPPER_OPEN;
                    }
                    return XBOX_FRIDGE_UPPER;
                }
                if (open.booleanValue()) {
                    return XBOX_FRIDGE_OPEN;
                }
                return XBOX_FRIDGE;
            }
            case EAST: {
                if (half == DoubleBlockHalf.UPPER) {
                    if (open.booleanValue()) {
                        return XBOX_FRIDGE_UPPER_OPEN_WEST;
                    }
                    return XBOX_FRIDGE_UPPER_WEST;
                }
                if (open.booleanValue()) {
                    return XBOX_FRIDGE_OPEN_WEST;
                }
                return XBOX_FRIDGE_WEST;
            }
        }
        if (half == DoubleBlockHalf.UPPER) {
            if (open.booleanValue()) {
                return XBOX_FRIDGE_UPPER_OPEN_EAST;
            }
            return XBOX_FRIDGE_UPPER_EAST;
        }
        if (open.booleanValue()) {
            return XBOX_FRIDGE_OPEN_EAST;
        }
        return XBOX_FRIDGE_EAST;
    }
}

