/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.behavior;

import com.unlikepaladin.pfm.blocks.BasicBathtub;
import com.unlikepaladin.pfm.registry.Statistics;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface BathtubBehavior {
    public static final BathtubBehavior FILL_TUB_WITH_WATER = (state, world, pos, player, hand, stack) -> BathtubBehavior.fillTub(world, pos, player, hand, stack, state, SoundEvents.f_11778_, true);
    public static final Map<Item, BathtubBehavior> TUB_BEHAVIOR = BathtubBehavior.createMap();
    public static final BathtubBehavior CLEAN_SHULKER_BOX = (state, world, pos, player, hand, stack) -> {
        if ((Integer)state.m_61143_((Property)BasicBathtub.LEVEL_8) == 0) {
            return InteractionResult.PASS;
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (!(block instanceof ShulkerBoxBlock)) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            ItemStack itemStack = new ItemStack((ItemLike)Blocks.f_50456_);
            if (stack.m_41782_()) {
                itemStack.m_41751_(stack.m_41783_().m_6426_());
            }
            player.m_21008_(hand, itemStack);
            player.m_36220_(Stats.f_12947_);
            BasicBathtub.decrementFluidLevel(state, world, pos);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    };
    public static final BathtubBehavior CLEAN_DYEABLE_ITEM = (state, world, pos, player, hand, stack) -> {
        if ((Integer)state.m_61143_((Property)BasicBathtub.LEVEL_8) == 0) {
            return InteractionResult.PASS;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof DyeableLeatherItem)) {
            return InteractionResult.PASS;
        }
        DyeableLeatherItem dyeableItem = (DyeableLeatherItem)item;
        if (!dyeableItem.m_41113_(stack)) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            dyeableItem.m_41123_(stack);
            player.m_36220_(Stats.f_12945_);
            BasicBathtub.decrementFluidLevel(state, world, pos);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    };
    public static final BathtubBehavior CLEAN_BANNER = (state, world, pos, player, hand, stack) -> {
        if (BannerBlockEntity.m_58504_((ItemStack)stack) <= 0 || (Integer)state.m_61143_((Property)BasicBathtub.LEVEL_8) == 0) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            ItemStack itemStack = stack.m_41777_();
            itemStack.m_41764_(1);
            BannerBlockEntity.m_58509_((ItemStack)itemStack);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, itemStack);
            } else if (player.m_150109_().m_36054_(itemStack)) {
                player.f_36095_.m_150429_();
            } else {
                player.m_36176_(itemStack, false);
            }
            player.m_36220_(Stats.f_12946_);
            BasicBathtub.decrementFluidLevel(state, world, pos);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    };

    public static Object2ObjectOpenHashMap<Item, BathtubBehavior> createMap() {
        return (Object2ObjectOpenHashMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), map -> map.defaultReturnValue(null));
    }

    public InteractionResult interact(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, ItemStack var6);

    public static InteractionResult fillTub(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state, SoundEvent soundEvent, boolean usedBucket) {
        if (!world.f_46443_) {
            int newLevel;
            player.m_36220_(Statistics.BATHTUB_FILLED);
            if (usedBucket) {
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            }
            if ((newLevel = (Integer)world.m_8055_(pos).m_61143_((Property)BasicBathtub.LEVEL_8) + 4) >= 0 && newLevel <= 8) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BasicBathtub.LEVEL_8, (Comparable)Integer.valueOf(newLevel)));
            } else {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BasicBathtub.LEVEL_8, (Comparable)Integer.valueOf(8)));
            }
            world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public static InteractionResult emptyTub(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, ItemStack output, Predicate<BlockState> predicate, SoundEvent soundEvent) {
        if (!predicate.test(state)) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            Item item = stack.m_41720_();
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)output));
            player.m_36220_(Statistics.USE_BATHTUB);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            int newLevel = (Integer)world.m_8055_(pos).m_61143_((Property)BasicBathtub.LEVEL_8) - 4;
            if (newLevel >= 0) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BasicBathtub.LEVEL_8, (Comparable)Integer.valueOf(newLevel)));
            } else {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BasicBathtub.LEVEL_8, (Comparable)Integer.valueOf(0)));
            }
            world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public static void registerBucketBehavior(Map<Item, BathtubBehavior> behavior) {
        behavior.put(Items.f_42447_, FILL_TUB_WITH_WATER);
    }

    public static void registerBehavior() {
        BathtubBehavior.registerBucketBehavior(TUB_BEHAVIOR);
        TUB_BEHAVIOR.put(Items.f_42446_, (state2, world, pos, player, hand, stack) -> BathtubBehavior.emptyTub(state2, world, pos, player, hand, stack, new ItemStack((ItemLike)Items.f_42447_), state -> (Integer)state.m_61143_((Property)BasicBathtub.LEVEL_8) >= 4, SoundEvents.f_11781_));
        TUB_BEHAVIOR.put(Items.f_42590_, (state, world, pos, player, hand, stack) -> {
            if (!world.f_46443_) {
                if ((Integer)state.m_61143_((Property)BasicBathtub.LEVEL_8) == 0) {
                    return InteractionResult.PASS;
                }
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
                player.m_36220_(Statistics.USE_BATHTUB);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                BasicBathtub.decrementFluidLevel(state, world, pos);
                world.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        });
        TUB_BEHAVIOR.put(Items.f_42589_, (state, world, pos, player, hand, stack) -> {
            if ((Integer)state.m_61143_((Property)BasicBathtub.LEVEL_8) == 8 || PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43599_) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36220_(Statistics.USE_BATHTUB);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                world.m_46597_(pos, (BlockState)state.m_61122_((Property)BasicBathtub.LEVEL_8));
                world.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        });
        TUB_BEHAVIOR.put(Items.f_42463_, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(Items.f_42462_, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(Items.f_42408_, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(Items.f_42407_, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(Items.f_42654_, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(Items.f_42660_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42667_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42728_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42671_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42672_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42669_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42673_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42663_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42668_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42665_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42662_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42661_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42666_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42670_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42727_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42664_, CLEAN_BANNER);
        TUB_BEHAVIOR.put(Items.f_42266_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42273_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42229_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42225_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42226_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42275_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42227_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42269_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42274_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42271_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42268_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42267_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42272_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42224_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42228_, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(Items.f_42270_, CLEAN_SHULKER_BOX);
    }
}

