/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.forge.rei;

import com.google.common.collect.Lists;
import com.unlikepaladin.pfm.compat.forge.rei.FreezingDisplay;
import com.unlikepaladin.pfm.compat.forge.rei.FreezingWidget;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FreezingCategory
implements DisplayCategory<FreezingDisplay> {
    public static final EntryStack<ItemStack> ICON = EntryStacks.of((ItemLike)PaladinFurnitureModBlocksItems.WHITE_FRIDGE);
    public static final Component TITLE = Component.m_237115_((String)"rei.pfm.freezer");

    public Renderer getIcon() {
        return ICON;
    }

    public Component getTitle() {
        return TITLE;
    }

    public CategoryIdentifier<? extends FreezingDisplay> getCategoryIdentifier() {
        return FreezingDisplay.IDENTIFIER;
    }

    public static FreezingWidget createFreezing(Point point) {
        return FreezingCategory.createFreezing(new Rectangle(point, new Dimension(14, 14)));
    }

    public static FreezingWidget createFreezing(Rectangle rectangle) {
        return new FreezingWidget(rectangle);
    }

    public List<Widget> setupDisplay(FreezingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        double cookingTime = display.cookTime;
        DecimalFormat df = new DecimalFormat("###.##");
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
        widgets.add(FreezingCategory.createFreezing(new Point(startPoint.x + 1, startPoint.y + 20)).animationDurationMS(10000.0));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 5, bounds.y + 5), (Component)Component.m_237110_((String)"category.rei.cooking.time&xp", (Object[])new Object[]{df.format(display.getXp()), df.format(cookingTime / 20.0)})).noShadow().rightAligned().color(-12566464, -4473925));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 24, startPoint.y + 8)).animationDurationTicks(cookingTime));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).markInput());
        return widgets;
    }
}

