/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.forge.rei;

import com.unlikepaladin.pfm.compat.forge.rei.CraftingRecipeSizeProvider;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleGridMenuInfo;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public abstract class FurnitureDisplay<C extends FurnitureRecipe>
extends BasicDisplay
implements SimpleGridMenuDisplay {
    protected Optional<C> recipe;
    public static final CategoryIdentifier<FurnitureDisplay> IDENTIFIER = CategoryIdentifier.of((ResourceLocation)new ResourceLocation("pfm", "crafting"));
    private static final List<CraftingRecipeSizeProvider<?>> SIZE_PROVIDER = new ArrayList();

    public FurnitureDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<C> recipe) {
        this(inputs, outputs, recipe.map(FurnitureRecipe::m_6423_), recipe);
    }

    public FurnitureDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location, Optional<C> recipe) {
        super(inputs, outputs, location);
        this.recipe = recipe;
    }

    public static <R extends FurnitureRecipe> void registerSizeProvider(CraftingRecipeSizeProvider<R> sizeProvider) {
        SIZE_PROVIDER.add(0, sizeProvider);
    }

    public static void registerPlatformSizeProvider() {
        FurnitureDisplay.registerSizeProvider(recipe -> {
            if (recipe instanceof FurnitureRecipe) {
                return new CraftingRecipeSizeProvider.Size(recipe.getWidth(), recipe.getHeight());
            }
            System.out.println("Registering as null");
            return null;
        });
    }

    @Nullable
    public static FurnitureDisplay<?> of(FurnitureRecipe recipe) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        for (CraftingRecipeSizeProvider<?> pair : SIZE_PROVIDER) {
            CraftingRecipeSizeProvider.Size size = pair.getSize(recipe);
            if (size == null) continue;
            return new DefaultCustomShapedDisplay(recipe, EntryIngredients.ofIngredients(recipe.m_7527_()), Collections.singletonList(EntryIngredients.of((ItemStack)recipe.m_8043_(BasicDisplay.registryAccess()))), size.getWidth(), size.getHeight());
        }
        return null;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return IDENTIFIER;
    }

    public Optional<C> getOptionalRecipe() {
        return this.recipe;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return this.getOptionalRecipe().map(FurnitureRecipe::m_6423_);
    }

    public <T extends AbstractContainerMenu> List<List<ItemStack>> getOrganisedInputEntries(SimpleGridMenuInfo<T, FurnitureDisplay<?>> menuInfo, T container) {
        return CollectionUtils.map(this.getOrganisedInputEntries(menuInfo.getCraftingWidth(container), menuInfo.getCraftingHeight(container)), ingredient -> CollectionUtils.filterAndMap((Iterable)ingredient, stack -> stack.getType() == VanillaEntryTypes.ITEM, EntryStack::castValue));
    }

    public <T extends AbstractContainerMenu> List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(menuWidth * menuHeight);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            list.set(FurnitureDisplay.getSlotWithSize(this, i, menuWidth), (EntryIngredient)this.getInputEntries().get(i));
        }
        return list;
    }

    public static int getSlotWithSize(FurnitureDisplay<?> display, int index, int craftingGridWidth) {
        return FurnitureDisplay.getSlotWithSize(display.getInputWidth(), index, craftingGridWidth);
    }

    public static int getSlotWithSize(int recipeWidth, int index, int craftingGridWidth) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return craftingGridWidth * y + x;
    }

    public static BasicDisplay.Serializer<FurnitureDisplay<?>> serializer() {
        return BasicDisplay.Serializer.ofSimple(DefaultCustomDisplay::simple).inputProvider(display -> display.getOrganisedInputEntries(3, 3));
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(MenuSerializationContext<?, ?, ?> context, MenuInfo<?, ?> info, boolean fill) {
        int craftingWidth = 3;
        int craftingHeight = 3;
        if (info instanceof SimpleGridMenuInfo && fill) {
            craftingWidth = ((SimpleGridMenuInfo)info).getCraftingWidth(context.getMenu());
            craftingHeight = ((SimpleGridMenuInfo)info).getCraftingHeight(context.getMenu());
        }
        return this.getInputIngredients(craftingWidth, craftingHeight);
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(int craftingWidth, int craftingHeight) {
        int inputWidth = Math.max(3, this.getInputWidth());
        int inputHeight = Math.max(3, this.getInputHeight());
        InputIngredient[][] grid = new InputIngredient[Math.max(inputWidth, craftingWidth)][Math.max(inputHeight, craftingHeight)];
        List inputEntries = this.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            grid[i % this.getInputWidth((int)3, (int)3)][i / this.getInputWidth((int)3, (int)3)] = InputIngredient.of((int)FurnitureDisplay.getSlotWithSize(this.getInputWidth(3, 3), i, craftingWidth), (List)((List)inputEntries.get(i)));
        }
        ArrayList list = new ArrayList(craftingWidth * craftingHeight);
        int n = craftingWidth * craftingHeight;
        for (int i = 0; i < n; ++i) {
            list.add(InputIngredient.empty((int)i));
        }
        for (int x = 0; x < craftingWidth; ++x) {
            for (int y = 0; y < craftingHeight; ++y) {
                if (grid[x][y] == null) continue;
                int index = craftingWidth * y + x;
                list.set(index, grid[x][y]);
            }
        }
        return list;
    }

    static {
        FurnitureDisplay.registerPlatformSizeProvider();
    }

    private static class DefaultCustomShapedDisplay
    extends FurnitureDisplay<FurnitureRecipe> {
        private int width;
        private int height;

        public DefaultCustomShapedDisplay(@Nullable FurnitureRecipe possibleRecipe, List<EntryIngredient> input, List<EntryIngredient> output, int width, int height) {
            this(null, possibleRecipe, input, output, width, height);
        }

        public DefaultCustomShapedDisplay(@Nullable ResourceLocation location, @Nullable FurnitureRecipe possibleRecipe, List<EntryIngredient> input, List<EntryIngredient> output, int width, int height) {
            super(input, output, Optional.ofNullable(location == null && possibleRecipe != null ? possibleRecipe.m_6423_() : location), Optional.ofNullable(possibleRecipe));
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    private static class DefaultCustomDisplay
    extends FurnitureDisplay<FurnitureRecipe> {
        private int width;
        private int height;

        public DefaultCustomDisplay(@Nullable FurnitureRecipe possibleRecipe, List<EntryIngredient> input, List<EntryIngredient> output) {
            this(null, possibleRecipe, input, output);
        }

        public DefaultCustomDisplay(@Nullable ResourceLocation location, @Nullable FurnitureRecipe possibleRecipe, List<EntryIngredient> input, List<EntryIngredient> output) {
            super(input, output, Optional.ofNullable(location == null && possibleRecipe != null ? possibleRecipe.m_6423_() : location), Optional.ofNullable(possibleRecipe));
            BitSet row = new BitSet(3);
            BitSet column = new BitSet(3);
            for (int i = 0; i < 9; ++i) {
                EntryIngredient stacks;
                if (i >= input.size() || !(stacks = input.get(i)).stream().anyMatch(stack -> !stack.isEmpty())) continue;
                row.set((i - i % 3) / 3);
                column.set(i % 3);
            }
            this.width = column.cardinality();
            this.height = row.cardinality();
        }

        public static DefaultCustomDisplay simple(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> location) {
            FurnitureRecipe optionalRecipe = location.flatMap(resourceLocation -> RecipeManagerContext.getInstance().getRecipeManager().m_44043_(resourceLocation)).orElse(null);
            return new DefaultCustomDisplay(location.orElse(null), optionalRecipe, input, output);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getInputWidth() {
            return 3;
        }

        public int getInputHeight() {
            return 3;
        }
    }
}

