/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FurnitureRecipeJsonBuilder
implements RecipeBuilder {
    private final Item output;
    private final int outputCount;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> inputs = Maps.newLinkedHashMap();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    public static final Logger PFM_RECIPE_LOGGER = LogManager.getLogger();
    @Nullable
    private String group;
    private final RecipeCategory category;

    public FurnitureRecipeJsonBuilder(ItemLike output, int outputCount) {
        this.output = output.m_5456_();
        this.outputCount = outputCount;
        this.category = RecipeCategory.DECORATIONS;
    }

    public static FurnitureRecipeJsonBuilder create(ItemLike output) {
        return FurnitureRecipeJsonBuilder.create(output, 1);
    }

    public static FurnitureRecipeJsonBuilder create(ItemLike output, int outputCount) {
        return new FurnitureRecipeJsonBuilder(output, outputCount);
    }

    public FurnitureRecipeJsonBuilder input(Character c, TagKey<Item> tag) {
        return this.input(c, Ingredient.m_204132_(tag));
    }

    public FurnitureRecipeJsonBuilder input(Character c, ItemLike itemProvider) {
        return this.input(c, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemProvider}));
    }

    public FurnitureRecipeJsonBuilder input(Character c, Ingredient ingredient) {
        if (this.inputs.containsKey(c)) {
            throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
        }
        if (c.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.inputs.put(c, ingredient);
        return this;
    }

    public FurnitureRecipeJsonBuilder pattern(String patternStr) {
        if (!this.pattern.isEmpty() && patternStr.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternStr);
        return this;
    }

    public FurnitureRecipeJsonBuilder criterion(String string, CriterionTriggerInstance criterionConditions) {
        this.advancementBuilder.m_138386_(string, criterionConditions);
        return this;
    }

    public FurnitureRecipeJsonBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public Item m_142372_() {
        return this.output;
    }

    public void m_126140_(Consumer<FinishedRecipe> exporter, ResourceLocation recipeId) {
        this.validate(recipeId);
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        Item output = this.output;
        int outputCount = this.outputCount;
        String group = this.group == null ? "" : this.group;
        List<String> pattern = this.pattern;
        Map<Character, Ingredient> inputs = this.inputs;
        Advancement.Builder advancementBuilder = this.advancementBuilder;
        String recipeIdNamespace = recipeId.m_135827_();
        String name = this.category.m_247710_();
        exporter.accept(new FurnitureRecipeJsonProvider(recipeId, output, outputCount, group, pattern, inputs, advancementBuilder, new ResourceLocation(recipeIdNamespace, "recipes/" + name + "/" + recipeId.m_135815_())));
    }

    private void validate(ResourceLocation recipeId) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for furniture recipe " + recipeId + "!");
        }
        HashSet set = Sets.newHashSet(this.inputs.keySet());
        set.remove(Character.valueOf(' '));
        for (String string : this.pattern) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!this.inputs.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + recipeId + " uses undefined symbol '" + c + "'");
                }
                set.remove(Character.valueOf(c));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + recipeId);
        }
        if (this.inputs.containsValue(Ingredient.f_43901_) || this.inputs.containsValue(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41852_}))) {
            PFM_RECIPE_LOGGER.warn("Recipe contains empty ingredient: " + recipeId);
        }
    }

    static class FurnitureRecipeJsonProvider
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final Item output;
        private final int resultCount;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> inputs;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public FurnitureRecipeJsonProvider(ResourceLocation recipeId, Item output, int resultCount, String group, List<String> pattern, Map<Character, Ingredient> inputs, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.recipeId = recipeId;
            this.output = output;
            this.resultCount = resultCount;
            this.group = group;
            this.pattern = pattern;
            this.inputs = inputs;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            for (String string : this.pattern) {
                jsonArray.add(string);
            }
            json.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.inputs.entrySet()) {
                jsonObject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)jsonObject);
            JsonObject string = new JsonObject();
            string.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.output).toString());
            if (this.resultCount > 1) {
                string.addProperty("count", (Number)this.resultCount);
            }
            json.add("result", (JsonElement)string);
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeTypes.FURNITURE_SERIALIZER;
        }

        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

