/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.items;

import com.unlikepaladin.pfm.blocks.PendantBlock;
import com.unlikepaladin.pfm.blocks.PowerableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LightSwitchItem
extends BlockItem {
    private Block block;

    public LightSwitchItem(Block block, Item.Properties settings) {
        super(block, settings);
        this.block = block;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (player.m_6144_()) {
            stack.m_41751_(null);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        super.m_6225_(context);
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        Block block = state.m_60734_();
        if (block instanceof PowerableBlock) {
            if (block instanceof PendantBlock) {
                boolean isRoot;
                boolean isSingle = (Boolean)state.m_61143_((Property)PendantBlock.DOWN) == false && (Boolean)state.m_61143_((Property)PendantBlock.UP) == false;
                boolean bl = isRoot = (Boolean)state.m_61143_((Property)PendantBlock.DOWN) != false && (Boolean)state.m_61143_((Property)PendantBlock.UP) == false;
                if (isSingle || isRoot) {
                    this.addLight(context.m_43722_(), pos);
                } else if (context.m_43725_().f_46443_) {
                    context.m_43723_().m_5661_((Component)Component.m_237115_((String)"message.pfm.light_switch_not_canopy"), false);
                }
            } else {
                this.addLight(context.m_43722_(), pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState state) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        if (LightSwitchItem.getLights(context.m_43722_()) != null) {
            ListTag lights = LightSwitchItem.getLights(context.m_43722_());
            Direction facing = context.m_8125_();
            int i = 0;
            if (i < lights.size()) {
                BlockPos placedPos;
                Tag nbtElement = lights.get(i);
                BlockPos lightPos = BlockPos.m_122022_((long)((LongTag)nbtElement).m_7046_());
                double distance = Math.sqrt(lightPos.m_203202_((double)(placedPos = pos.m_121945_(facing)).m_123341_() + 0.5, (double)placedPos.m_123342_() + 0.5, (double)placedPos.m_123343_() + 0.5));
                return !(distance > 16.0) && state.m_60734_().m_7898_(state, (LevelReader)world, pos);
            }
        }
        return state.m_60734_().m_7898_(state, (LevelReader)world, pos);
    }

    private void addLight(ItemStack stack, BlockPos pos) {
        ListTag tagList;
        CompoundTag entityTagCompound;
        CompoundTag tagCompound = LightSwitchItem.createTag(stack);
        if (!tagCompound.m_128425_("BlockEntityTag", 10)) {
            tagCompound.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        }
        if (!(entityTagCompound = tagCompound.m_128469_("BlockEntityTag")).m_128425_("lights", 9)) {
            entityTagCompound.m_128365_("lights", (Tag)new ListTag());
        }
        if (!this.containsLight(tagList = (ListTag)entityTagCompound.m_128423_("lights"), pos)) {
            tagList.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
        }
    }

    private boolean containsLight(ListTag tagList, BlockPos pos) {
        for (int i = 0; i < tagList.size(); ++i) {
            LongTag tagLong = (LongTag)tagList.get(i);
            if (tagLong.m_7046_() != pos.m_121878_()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ListTag getLights(ItemStack stack) {
        CompoundTag entityTagCompound;
        CompoundTag tagCompound = LightSwitchItem.createTag(stack);
        if (tagCompound.m_128425_("BlockEntityTag", 10) && (entityTagCompound = tagCompound.m_128469_("BlockEntityTag")).m_128425_("lights", 9)) {
            return (ListTag)entityTagCompound.m_128423_("lights");
        }
        return null;
    }

    private static CompoundTag createTag(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }
}

