/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.unlikepaladin.pfm.recipes.IFurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FurnitureRecipe
implements IFurnitureRecipe {
    final int width;
    final int height;
    final NonNullList<Ingredient> input;
    final ItemStack output;
    private final ResourceLocation id;
    final String group;

    public FurnitureRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> input, ItemStack output) {
        this.id = id;
        this.group = group;
        this.width = width;
        this.height = height;
        this.input = input;
        this.output = output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack m_8042_() {
        return PaladinFurnitureModBlocksItems.WORKING_TABLE.m_5456_().m_7968_();
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeTypes.FURNITURE_SERIALIZER;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.input;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean matches(CraftingContainer craftingInventory, Level world) {
        for (int i = 0; i <= craftingInventory.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= craftingInventory.m_39346_() - this.height; ++j) {
                if (this.matchesPattern(craftingInventory, i, j, true)) {
                    return true;
                }
                if (!this.matchesPattern(craftingInventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesPattern(CraftingContainer inv, int offsetX, int offsetY, boolean flipped) {
        for (int i = 0; i < inv.m_39347_(); ++i) {
            for (int j = 0; j < inv.m_39346_(); ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    Ingredient ingredient2 = ingredient = flipped ? (Ingredient)this.input.get(this.width - k - 1 + l * this.width) : (Ingredient)this.input.get(k + l * this.width);
                }
                if (ingredient.test(inv.m_8020_(i + j * inv.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack craft(CraftingContainer craftingInventory, RegistryAccess registryManager) {
        return this.m_8043_(registryManager).m_41777_();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static NonNullList<Ingredient> createPatternMatrix(String[] pattern, Map<String, Ingredient> symbols, int width, int height) {
        NonNullList defaultedList = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                Ingredient ingredient = symbols.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return defaultedList;
    }

    @VisibleForTesting
    public static String[] removePadding(String ... pattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < pattern.length; ++m) {
            String string = pattern[m];
            i = Math.min(i, FurnitureRecipe.findFirstSymbol(string));
            int n = FurnitureRecipe.findLastSymbol(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pattern.length == l) {
            return new String[0];
        }
        String[] m = new String[pattern.length - l - k];
        for (int string = 0; string < m.length; ++string) {
            m[string] = pattern[string + k].substring(i, j + 1);
        }
        return m;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> defaultedList = this.m_7527_();
        return defaultedList.isEmpty() || defaultedList.stream().filter(ingredient -> !ingredient.m_43947_()).anyMatch(ingredient -> ingredient.m_43908_().length == 0);
    }

    private static int findFirstSymbol(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int findLastSymbol(String pattern) {
        int i;
        for (i = pattern.length() - 1; i >= 0 && pattern.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public static String[] getPattern(JsonArray json) {
        String[] strings = new String[json.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = GsonHelper.m_13805_((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    public static Map<String, Ingredient> readSymbols(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack outputFromJson(JsonObject json) {
        Item item = FurnitureRecipe.getItem(json);
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
        if (i < 1) {
            throw new JsonSyntaxException("Invalid output count: " + i);
        }
        return new ItemStack((ItemLike)item, i);
    }

    public static Item getItem(JsonObject json) {
        String string = GsonHelper.m_13906_((JsonObject)json, (String)"item");
        Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(string)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + string + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + string);
        }
        return item;
    }

    public boolean m_5598_() {
        return true;
    }
}

