/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import com.natamus.collective_common_forge.config.CollectiveConfigHandler;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.fakeplayer.FakePlayer;
import com.natamus.collective_common_forge.fakeplayer.FakePlayerFactory;
import com.natamus.collective_common_forge.functions.BlockFunctions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class ItemFunctions {
    public static void generateEntityDropsFromLootTable(Level level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        GlobalVariables.entitydrops = new HashMap();
        FakePlayer fakeplayer = FakePlayerFactory.getMinecraft((ServerLevel)level);
        Vec3 vec = new Vec3(0.0, 0.0, 0.0);
        ItemStack lootingsword = new ItemStack((ItemLike)Items.f_42388_, 1);
        lootingsword.m_41663_(Enchantments.f_44982_, 10);
        fakeplayer.m_8061_(EquipmentSlot.MAINHAND, lootingsword);
        Set entitytypes = level.m_9598_().m_175515_(Registries.f_256939_).m_6579_();
        for (Map.Entry entry : entitytypes) {
            Entity entity;
            EntityType type = (EntityType)entry.getValue();
            if (type == null || !((entity = type.m_20615_(level)) instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entity;
            ResourceLocation lootlocation = le.m_6095_().m_20677_();
            LootTable loottable = server.m_129898_().m_79217_(lootlocation);
            LootContext context = new LootContext.Builder((ServerLevel)level).m_230911_(level.m_213780_()).m_78963_(1000000.0f).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)vec).m_78972_(LootContextParams.f_81458_, (Object)fakeplayer).m_78972_(LootContextParams.f_81457_, (Object)level.m_269111_().m_269075_((Player)fakeplayer)).m_78975_(LootContextParamSets.f_81415_);
            ArrayList<Item> alldrops = new ArrayList<Item>();
            for (int n = 0; n < CollectiveConfigHandler.loopsAmountUsedToGetAllEntityDrops; ++n) {
                ObjectArrayList newdrops = loottable.m_230922_(context);
                for (ItemStack newdrop : newdrops) {
                    Item newitem = newdrop.m_41720_();
                    if (alldrops.contains(newitem) || newitem.equals(Items.f_41852_)) continue;
                    alldrops.add(newitem);
                }
            }
            GlobalVariables.entitydrops.put(type, alldrops);
        }
    }

    public static void shrinkGiveOrDropItemStack(Player player, InteractionHand hand, ItemStack used, ItemStack give) {
        used.m_41774_(1);
        if (used.m_41619_()) {
            Item giveitem = give.m_41720_();
            int maxstacksize = give.m_41741_();
            NonNullList inventory = player.m_150109_().f_35974_;
            boolean increased = false;
            for (ItemStack slot : inventory) {
                int slotcount;
                if (!slot.m_41720_().equals(giveitem) || (slotcount = slot.m_41613_()) >= maxstacksize) continue;
                slot.m_41764_(slotcount + 1);
                increased = true;
                break;
            }
            if (!increased) {
                player.m_21008_(hand, give);
            }
        } else if (!player.m_150109_().m_36054_(give)) {
            player.m_36176_(give, false);
        }
    }

    public static void giveOrDropItemStack(Player player, ItemStack give) {
        if (!player.m_150109_().m_36054_(give)) {
            player.m_36176_(give, false);
        }
    }

    public static void itemHurtBreakAndEvent(ItemStack itemStack, ServerPlayer player, InteractionHand hand, int damage) {
        if (!player.m_150110_().f_35937_ && itemStack.m_41763_() && itemStack.m_220157_(damage, player.m_217043_(), player)) {
            Item item = itemStack.m_41720_();
            itemStack.m_41774_(1);
            itemStack.m_41721_(0);
            player.m_36246_(Stats.f_12983_.m_12902_((Object)item));
        }
    }

    public static boolean isStoneTypeItem(Item item) {
        return GlobalVariables.stoneblockitems.contains(item);
    }

    public static String itemToReadableString(Item item, int amount) {
        String translationkey = item.m_5524_();
        if (translationkey.contains("block.")) {
            return BlockFunctions.blockToReadableString(Block.m_49814_((Item)item), amount);
        }
        String[] itemspl = translationkey.replace("item.", "").split("\\.");
        Object itemstring = itemspl.length > 1 ? itemspl[1] : itemspl[0];
        itemstring = ((String)itemstring).replace("_", " ");
        if (amount > 1) {
            itemstring = (String)itemstring + "s";
        }
        return itemstring;
    }

    public static String itemToReadableString(Item item) {
        return ItemFunctions.itemToReadableString(item, 1);
    }

    public static String getNBTStringFromItemStack(ItemStack itemStack) {
        return ItemFunctions.getNBTStringFromItemStack(itemStack, true);
    }

    public static String getNBTStringFromItemStack(ItemStack itemStack, boolean shouldSanitize) {
        CompoundTag nbt = new CompoundTag();
        nbt = itemStack.m_41739_(nbt);
        String nbtstring = nbt.toString();
        if (shouldSanitize) {
            nbtstring = nbtstring.replace(" : ", ": ");
        }
        return nbtstring;
    }

    public static void setItemCategory(Item item, CreativeModeTab category) {
    }
}

