/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.util.IFluidLoggable;
import com.legacy.blue_skies.data.objects.tags.SkiesBiomeTags;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkyDripstoneBlock
extends Block
implements IFluidLoggable,
Fallable {
    private static final VoxelShape[] STALAGMITE_SHAPES = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5)};
    private static final VoxelShape[] STALACTITE_SHAPES = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5)};
    public static final EnumProperty<Section> SECTION = EnumProperty.m_61587_((String)"section", Section.class);
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    private static final float GROW_CHANCE = 0.011377778f;
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public SkyDripstoneBlock(BlockBehaviour.Properties properties) {
        super(properties.m_222979_(BlockBehaviour.OffsetType.XZ).m_60977_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SECTION, (Comparable)((Object)Section.TIP))).m_61124_(TYPE, (Comparable)((Object)Type.STALAGMITE))).m_61124_((Property)FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.EMPTY)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(level, pos);
        return (state.m_61143_(TYPE) == Type.STALAGMITE ? STALAGMITE_SHAPES : STALACTITE_SHAPES)[((Section)((Object)state.m_61143_(SECTION))).ordinal()].m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Type type = (Type)((Object)state.m_61143_(TYPE));
        if (state.m_61143_(SECTION) == Section.TIP && !level.m_8055_(pos.m_121945_(type.growthDir.m_122424_())).m_60713_((Block)this)) {
            return Shapes.m_83040_();
        }
        Vec3 offset = state.m_60824_(level, pos);
        return (type == Type.STALAGMITE ? STALAGMITE_SHAPES : STALACTITE_SHAPES)[((Section)((Object)state.m_61143_(SECTION))).ordinal()].m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        int fluidLight = ((IFluidLoggable.FluidLogging)((Object)state.m_61143_((Property)SkyDripstoneBlock.FLUIDLOGGED))).fluidState.m_76188_().getLightEmission(level, pos);
        int blockLight = super.getLightEmission(state, level, pos);
        return Math.max(fluidLight, blockLight);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForPlacement(context.m_43725_(), context.m_8083_(), context.m_6232_());
    }

    @Nullable
    public BlockState getStateForPlacement(Level level, BlockPos pos, Direction ... directions) {
        for (Direction dir : directions) {
            BlockState state;
            if (dir.m_122434_() != Direction.Axis.Y || !(state = (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)(dir == Type.STALAGMITE.growthDir ? Type.STALACTITE : Type.STALAGMITE)))).m_60710_((LevelReader)level, pos)) continue;
            return (BlockState)state.m_61124_((Property)FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.from(level, pos)));
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction growthDir = ((Type)((Object)state.m_61143_(SkyDripstoneBlock.TYPE))).growthDir;
        BlockState attachedTo = level.m_8055_(pos.m_121945_(growthDir.m_122424_()));
        return attachedTo.m_60713_((Block)this) || attachedTo.m_60783_((BlockGetter)level, pos.m_121945_(growthDir.m_122424_()), growthDir);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, state.m_60734_(), 0);
            return state;
        }
        IFluidLoggable.FluidLogging fluid = (IFluidLoggable.FluidLogging)((Object)state.m_61143_((Property)FLUIDLOGGED));
        if (fluid != IFluidLoggable.FluidLogging.EMPTY) {
            level.m_186469_(currentPos, fluid.fluid, fluid.fluid.m_6718_((LevelReader)level));
        }
        Type type = (Type)((Object)state.m_61143_(TYPE));
        Direction growthDir = type.growthDir;
        BlockState attached = level.m_8055_(currentPos.m_121945_(growthDir));
        Section section = attached.m_60713_((Block)this) ? (attached.m_61143_(TYPE) == type ? (level.m_8055_(currentPos.m_121945_(growthDir.m_122424_())).m_60713_((Block)this) ? Section.MIDDLE : Section.getWider((Section)((Object)attached.m_61143_(SECTION)))) : Section.TIP_MERGE) : Section.TIP;
        return (BlockState)state.m_61124_(SECTION, (Comparable)((Object)section));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (state.m_61143_(TYPE) == Type.STALAGMITE) {
            if (!this.m_7898_(state, (LevelReader)level, pos)) {
                level.m_46961_(pos, true);
            }
        } else {
            BlockPos.MutableBlockPos checkPos = pos.m_122032_();
            BlockState checkBlock = state;
            while (checkBlock.m_60713_((Block)this) && checkBlock.m_61143_(TYPE) == Type.STALACTITE) {
                FallingBlockEntity fallingBlock = FallingBlockEntity.m_201971_((Level)level, (BlockPos)checkPos, (BlockState)checkBlock);
                if (((Section)((Object)checkBlock.m_61143_(SkyDripstoneBlock.SECTION))).damaging) {
                    float damagePerDist = Math.max(1 + pos.m_123342_() - checkPos.m_123342_(), 6);
                    fallingBlock.m_149656_(damagePerDist, 40);
                    break;
                }
                checkPos.m_122173_(Direction.DOWN);
                checkBlock = level.m_8055_((BlockPos)checkPos);
            }
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        float chance;
        if (this.shouldDrip(state) && this.getFluidAbove(state, (Level)level, pos) != Fluids.f_76191_ && (chance = rand.m_188501_()) < 0.011377778f) {
            if (rand.m_188499_()) {
                BlockPos placePos = pos.m_7495_();
                if (level.m_8055_(placePos).m_60767_().m_76336_()) {
                    level.m_7731_(placePos, (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)Type.STALACTITE))).m_61124_((Property)FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.from((Level)level, placePos))), 3);
                }
            } else {
                BlockState placeState;
                BlockPos.MutableBlockPos checkPos = pos.m_7495_().m_122032_();
                BlockState checkState = level.m_8055_((BlockPos)checkPos);
                for (int i = 0; i < 16 && SkyDripstoneBlock.canDripThrough((BlockGetter)level, (BlockPos)checkPos, checkState); ++i) {
                    checkPos.m_122173_(Direction.DOWN);
                    checkState = level.m_8055_((BlockPos)checkPos);
                }
                BlockPos placePos = checkPos.m_7949_().m_7494_();
                if (level.m_8055_(placePos).m_60767_().m_76336_() && (placeState = this.m_49966_()).m_60710_((LevelReader)level, placePos)) {
                    level.m_7731_(placePos, (BlockState)placeState.m_61124_((Property)FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.from((Level)level, placePos))), 3);
                }
            }
        }
    }

    private Fluid getFluidAbove(BlockState state, Level level, BlockPos pos) {
        BlockState checkState = state;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int i = 0; i < 10 && checkState.m_60713_((Block)this); ++i) {
            checkPos.m_122173_(Direction.UP);
            checkState = level.m_8055_((BlockPos)checkPos);
        }
        return level.m_6425_(checkPos.m_7494_()).m_76152_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (this.shouldDrip(state) && rand.m_188501_() < 0.12f) {
            Vec3 offset = state.m_60824_((BlockGetter)level, pos);
            double x = (double)pos.m_123341_() + 0.5 + offset.f_82479_;
            double y = (double)pos.m_123342_() + 0.0625;
            double z = (double)pos.m_123343_() + 0.5 + offset.f_82481_;
            Fluid fluid = this.getDripFluid(state, level, pos);
            SimpleParticleType particleOps = fluid.m_205067_(FluidTags.f_13132_) ? ParticleTypes.f_175822_ : ParticleTypes.f_175824_;
            level.m_7106_((ParticleOptions)particleOps, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private Fluid getDripFluid(BlockState state, Level level, BlockPos pos) {
        Fluid fluidAbove = this.getFluidAbove(state, level, pos);
        if (fluidAbove == Fluids.f_76191_ && (level.m_6042_().f_63857_() || level.m_204166_(pos).m_203656_(SkiesBiomeTags.DRIPSTONES_DRIP_LAVA))) {
            return Fluids.f_76195_;
        }
        return fluidAbove;
    }

    private boolean shouldDrip(BlockState state) {
        return state.m_61143_(SECTION) == Section.TIP && state.m_61143_(TYPE) == Type.STALACTITE && state.m_61143_((Property)FLUIDLOGGED) == IFluidLoggable.FluidLogging.EMPTY;
    }

    public FluidState m_5888_(BlockState state) {
        return ((IFluidLoggable.FluidLogging)((Object)state.m_61143_((Property)SkyDripstoneBlock.FLUIDLOGGED))).fluidState;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return state.m_61143_(SECTION) == Section.TIP && level.m_8055_(pos.m_121945_(((Type)((Object)state.m_61143_(SkyDripstoneBlock.TYPE))).growthDir.m_122424_())).m_60734_() != this;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        BlockPos blockpos = hitResult.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockpos) && (projectile instanceof ThrownTrident || projectile instanceof SpearEntity) && projectile.m_20184_().m_82553_() > 0.6) {
            level.m_46961_(blockpos, true);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDist) {
        if (state.m_61143_(TYPE) == Type.STALAGMITE && ((Section)((Object)state.m_61143_(SkyDripstoneBlock.SECTION))).damaging) {
            entity.m_142535_(fallDist + 2.0f, 2.0f, level.m_269111_().m_269571_());
        } else {
            super.m_142072_(level, state, pos, entity, fallDist);
        }
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.m_20067_()) {
            level.m_46796_(1045, pos, 0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SECTION, TYPE, FLUIDLOGGED});
    }

    private static boolean canDripThrough(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60804_(level, pos) || !state.m_60819_().m_76178_()) {
            return false;
        }
        return !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)state.m_60812_(level, pos), (BooleanOp)BooleanOp.f_82689_);
    }

    public static enum Section implements StringRepresentable
    {
        TIP_MERGE("tip_merge", true),
        TIP("tip", true),
        MIDDLE("middle", false),
        BASE("base", false);

        final String name;
        final boolean damaging;

        private Section(String name, boolean damaging) {
            this.name = name;
            this.damaging = damaging;
        }

        public static Section getWider(Section section) {
            return switch (section) {
                case TIP -> MIDDLE;
                case MIDDLE -> BASE;
                default -> BASE;
            };
        }

        public static Section getNarrower(Section section) {
            return switch (section) {
                case BASE -> MIDDLE;
                case MIDDLE -> TIP;
                default -> TIP;
            };
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum Type implements StringRepresentable
    {
        STALAGMITE("stalagmite", Direction.UP),
        STALACTITE("stalactite", Direction.DOWN);

        final String name;
        public final Direction growthDir;

        private Type(String name, Direction growthDir) {
            this.name = name;
            this.growthDir = growthDir;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

