/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.world;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class StarrySkyRenderer {
    private static final ResourceLocation SUN_TEXTURE = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation MOON_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation HALLOWEEN_MOON_TEXTURE = BlueSkies.locate("textures/environment/halloween_moon.png");
    private VertexBuffer starBuffer;
    private VertexBuffer skyBuffer;
    private VertexBuffer darkBuffer;
    public static final StarrySkyRenderer BRIGHT_INSTANCE = new StarrySkyRenderer(false);
    public static final StarrySkyRenderer DAWN_INSTANCE = new StarrySkyRenderer(true);
    private boolean pinkSunrise = false;
    private float rotation = 0.0f;
    private long startTime = Util.m_137550_();
    private final float[] colorsSunriseSunset = new float[4];

    public StarrySkyRenderer(boolean pinkSunriseIn) {
        this.pinkSunrise = pinkSunriseIn;
        this.generateStars();
        this.generateSky();
        this.generateDarkSky();
        this.startTime = Util.m_137550_();
    }

    public void render(int ticks, float partialTicks, PoseStack pose, ClientLevel level, Camera camera, Matrix4f matrix, Runnable fog) {
        float[] afloat;
        fog.run();
        if (this.rotation >= 360.0f) {
            this.startTime = Util.m_137550_();
            this.rotation = 0.0f;
        } else {
            this.rotation = (float)(Util.m_137550_() - this.startTime) * 3.0E-4f;
        }
        Vec3 vec3d = level.m_171660_(camera.m_90583_(), partialTicks);
        float f = (float)vec3d.f_82479_;
        float f1 = (float)vec3d.f_82480_;
        float f2 = (float)vec3d.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.m_157196_();
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_253207_(pose.m_85850_().m_252922_(), matrix, shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        float[] fArray = afloat = this.pinkSunrise ? this.calcDawnSunriseSunsetColors(level.m_46942_(partialTicks), partialTicks) : level.m_104583_().m_7518_(level.m_46942_(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            pose.m_85836_();
            pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float f3 = Mth.m_14031_((float)level.m_46490_(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            pose.m_252781_(Axis.f_252403_.m_252977_(f3));
            pose.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = pose.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = Mth.m_14031_((float)f7);
                float f9 = Mth.m_14089_((float)f7);
                bufferbuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            pose.m_85849_();
        }
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        pose.m_85836_();
        float f11 = 1.0f - level.m_46722_(partialTicks);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        pose.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        pose.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTicks) * 360.0f));
        Matrix4f matrix4f1 = pose.m_85850_().m_252922_();
        float f12 = 30.0f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_TEXTURE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        if (this.pinkSunrise) {
            f12 = 20.0f;
            if (BlueSkiesConfig.COMMON.isHalloween()) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)HALLOWEEN_MOON_TEXTURE);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, f12).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, f12).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, -f12).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, -f12).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            } else {
                RenderSystem.m_157456_((int)0, (ResourceLocation)MOON_TEXTURES);
                int k = 8;
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)(l + 0) / 4.0f;
                float f14 = (float)(i1 + 0) / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, f12).m_7421_(f15, f16).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, f12).m_7421_(f13, f16).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, -f12).m_7421_(f13, f14).m_5752_();
                bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, -f12).m_7421_(f15, f14).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            }
        }
        pose.m_252781_(Axis.f_252436_.m_252977_(-this.rotation));
        pose.m_252781_(Axis.f_252529_.m_252977_(this.rotation));
        float f10 = 1.0f * f11;
        if (f10 > 0.0f) {
            RenderSystem.m_157429_((float)f10, (float)f10, (float)f10, (float)f10);
            FogRenderer.m_109017_();
            this.starBuffer.m_85921_();
            this.starBuffer.m_253207_(pose.m_85850_().m_252922_(), matrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            fog.run();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        pose.m_85849_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d0 = camera.m_90592_().m_20299_((float)partialTicks).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
        if (d0 < 0.0) {
            pose.m_85836_();
            pose.m_85837_(0.0, 12.0, 0.0);
            this.darkBuffer.m_85921_();
            this.darkBuffer.m_253207_(pose.m_85850_().m_252922_(), matrix, shaderinstance);
            VertexBuffer.m_85931_();
            pose.m_85849_();
        }
        if (level.m_104583_().m_108882_()) {
            RenderSystem.m_157429_((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69458_((boolean)true);
    }

    private void generateStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer();
        BufferBuilder.RenderedBuffer box = this.renderStars(bufferbuilder);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(box);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer renderStars(BufferBuilder bufferBuilderIn) {
        Random random = new Random(1337L);
        bufferBuilderIn.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return bufferBuilderIn.m_231175_();
    }

    private void generateDarkSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        this.darkBuffer = new VertexBuffer();
        BufferBuilder.RenderedBuffer box = this.buildSkybox(bufferbuilder, -16.0f);
        this.darkBuffer.m_85921_();
        this.darkBuffer.m_231221_(box);
        VertexBuffer.m_85931_();
    }

    private void generateSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer();
        BufferBuilder.RenderedBuffer box = this.buildSkybox(bufferbuilder, 16.0f);
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_231221_(box);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer buildSkybox(BufferBuilder bufferBuilderIn, float posY) {
        float f = Math.signum(posY) * 512.0f;
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        bufferBuilderIn.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        bufferBuilderIn.m_5483_(0.0, (double)posY, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilderIn.m_5483_((double)(f * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)posY, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        return bufferBuilderIn.m_231175_();
    }

    public float[] calcDawnSunriseSunsetColors(float celestialAngle, float partialTicks) {
        float f1 = Mth.m_14089_((float)(celestialAngle * ((float)Math.PI * 2))) - 0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - Mth.m_14031_((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.5f + 0.7f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    public static StarrySkyRenderer getSkyForDim(ResourceKey<Level> dim) {
        if (dim.equals(SkiesDimensions.everbrightKey())) {
            return BRIGHT_INSTANCE;
        }
        if (dim.equals(SkiesDimensions.everdawnKey())) {
            return DAWN_INSTANCE;
        }
        return null;
    }
}

