/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.blocks.dungeon.SpiderNestBlock;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.data.objects.tags.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.boss.summons.NestedSpiderEntity;
import com.legacy.blue_skies.entities.projectile.VenomBombEntity;
import com.legacy.blue_skies.entities.projectile.VenomSpitEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.StunnableLookController;
import com.legacy.blue_skies.entities.util.StunnedEntitySound;
import com.legacy.blue_skies.entities.util.base.SkiesBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.entities.util.interfaces.IStunnableMob;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.structure_gel.api.util.Positions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;

public class ArachnarchEntity
extends SkiesBossEntity
implements RangedAttackMob,
IStunnableMob {
    protected static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(ArachnarchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> CEILING_LOCKED = SynchedEntityData.m_135353_(ArachnarchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(ArachnarchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> STUNNED = SynchedEntityData.m_135353_(ArachnarchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> TIME_ON_CEILING = SynchedEntityData.m_135353_(ArachnarchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> TIME_SINCE_LOCKED = SynchedEntityData.m_135353_(ArachnarchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> TIME_STUNNED = SynchedEntityData.m_135353_(ArachnarchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> TICKS_UNTIL_NEXT_SCREECH = SynchedEntityData.m_135353_(ArachnarchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Set<MobEffect> IMMUNE_EFFECTS = ImmutableSet.of((Object)MobEffects.f_19597_, (Object)MobEffects.f_19614_, (Object)SkiesEffects.DEADLY_VENOM, (Object)MobEffects.f_19591_, (Object)MobEffects.f_19620_);
    public static Set<Item> SHIELDS = ImmutableSet.of((Object)SkiesItems.moonstone_shield, (Object)SkiesItems.spike_shield);
    private Map<UUID, Vec3> oldPosRef = new HashMap<UUID, Vec3>();
    public int deathTicks;
    public int holdingTime = 1;
    public int clientScreechTime = 0;
    public float damageSinceGrabbed = 0.0f;
    @OnlyIn(value=Dist.CLIENT)
    private SoundInstance stunSound;

    public ArachnarchEntity(EntityType<? extends ArachnarchEntity> type, Level worldIn) {
        super((EntityType<? extends SkiesBossEntity>)type, worldIn);
        this.f_21364_ = 40;
        this.f_21365_ = new StunnableLookController((Mob)this);
        this.f_19793_ = 2.0f;
    }

    @Override
    public void m_6478_(MoverType type, Vec3 vec) {
        if (this.getInvulTime() <= 0 && !this.isStunned()) {
            super.m_6478_(type, vec);
        } else {
            super.m_6478_(type, new Vec3(0.0, vec.f_82480_, 0.0));
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8045_() {
                if (((ArachnarchEntity)this.f_25725_).isCeilingLocked() || this.f_25725_.m_5448_() != null) {
                    return false;
                }
                return !((ArachnarchEntity)this.f_25725_).isDungeonSpawned() && super.m_8045_();
            }

            public boolean m_8036_() {
                if (((ArachnarchEntity)this.f_25725_).isCeilingLocked() || this.f_25725_.m_5448_() != null) {
                    return false;
                }
                return !((ArachnarchEntity)this.f_25725_).isDungeonSpawned() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(3, (Goal)new VenomAttackGoal(this, 1.25, 20, 40.0f));
        this.f_21345_.m_25352_(3, (Goal)new VenomWalkingAttackGoal(this, 1.25, 60, 40.0f));
        this.f_21345_.m_25352_(3, (Goal)new LungeAtTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new WalkAndDropGoal());
        this.f_21345_.m_25352_(3, (Goal)new ScreechAttackGoal());
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData flag = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (!this.f_19853_.f_46443_) {
            if (this.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId()) {
                if (this.getDifficultyID() >= ISkyBoss.BossLevel.PLATINUM.getId()) {
                    this.m_21051_(Attributes.f_22284_).m_22100_(7.5);
                }
                this.m_21051_(Attributes.f_22285_).m_22100_(this.getDifficultyID() >= ISkyBoss.BossLevel.PLATINUM.getId() ? 6.0 : 4.0);
            }
            this.m_21051_(Attributes.f_22281_).m_22100_(14.0 + Math.min(8.0, (double)this.getExtraPlayers() * 1.5));
        }
        return flag;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, (double)0.36f).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22278_, 100.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22282_, 4.0);
    }

    @Override
    public double getBossHealth() {
        return 500.0 + (double)this.getExtraPlayers() * 200.0;
    }

    @Override
    public float getHealAmount() {
        return 50.0f;
    }

    @Override
    public LootBagItem getLootBag() {
        return SkiesItems.loot_bag_arachnarch;
    }

    @Override
    public TrophyBlock getTrophy() {
        return SkiesBlocks.arachnarch_trophy;
    }

    @Override
    public float getMaxReach() {
        return 5.08f;
    }

    @Override
    public int getDamageCap() {
        return 15;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(CEILING_LOCKED, (Object)false);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(STUNNED, (Object)false);
        this.f_19804_.m_135372_(TIME_ON_CEILING, (Object)0);
        this.f_19804_.m_135372_(TIME_SINCE_LOCKED, (Object)0);
        this.f_19804_.m_135372_(TIME_STUNNED, (Object)0);
        this.f_19804_.m_135372_(TICKS_UNTIL_NEXT_SCREECH, (Object)0);
    }

    @Override
    public void m_8119_() {
        block41: {
            int t;
            block40: {
                super.m_8119_();
                if (this.deathTicks > 0 || this.m_21525_()) {
                    return;
                }
                if (this.clientScreechTime > 0) {
                    --this.clientScreechTime;
                }
                if (this.f_19853_.f_46443_) break block40;
                if (this.getPlayersInDungeonArea().isEmpty() && !this.getSpidersInDungeonArea(20.0).isEmpty()) {
                    this.getSpidersInDungeonArea(20.0).forEach(spider -> {
                        spider.m_146870_();
                        spider.m_21373_();
                    });
                }
                this.setBesideClimbableBlock(this.f_19862_);
                if (!this.isStunned()) {
                    if (this.getSpidersInDungeonArea(15.0).isEmpty() && this.getTicksUntilNextScreech() > 0) {
                        this.setTicksUntilNextScreech(this.getTicksUntilNextScreech() - 1);
                    }
                    if (!this.m_20197_().isEmpty() && this.m_20197_().get(0) instanceof LivingEntity) {
                        double yLook;
                        if (this.holdingTime > 0) {
                            --this.holdingTime;
                        }
                        if (this.holdingTime <= 70 && !this.isCeilingLocked() && this.getDifficultyID() >= ISkyBoss.BossLevel.PLATINUM.getId()) {
                            if (this.m_20275_(this.getHome().m_123341_(), this.getHome().m_123342_(), this.getHome().m_123343_()) > 60.0) {
                                this.m_21566_().m_6849_((double)this.getHome().m_123341_(), (double)this.getHome().m_123342_(), (double)this.getHome().m_123343_(), 1.0);
                            } else {
                                this.slingToCeiling();
                            }
                        }
                        if (this.isCharging()) {
                            this.setCharging(false);
                        }
                        LivingEntity rider = (LivingEntity)this.m_20197_().get(0);
                        rider.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 1));
                        this.m_146922_(this.f_20885_);
                        double d = yLook = this.isCeilingLocked() ? this.m_20186_() + (double)this.m_20192_() : (double)this.getHome().m_123342_();
                        if (this.m_20275_(this.getHome().m_123341_(), this.getHome().m_123342_(), this.getHome().m_123343_()) > 20.0) {
                            this.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.getHome().m_123341_(), yLook, (double)this.getHome().m_123343_()));
                        }
                    }
                    if (!this.isCeilingLocked()) {
                        BlockPos pos = this.m_20183_();
                        if (!this.f_19853_.m_46859_(pos.m_6630_(2)) && this.isBesideClimbableBlock() && this.m_5448_() == null) {
                            this.setCeilingLocked(true);
                        }
                        if (this.m_5448_() != null) {
                            boolean canSling;
                            boolean bl = canSling = !this.f_19853_.m_45527_(this.m_20183_()) && this.f_19853_.m_45517_(LightLayer.SKY, this.m_20183_()) < 5 && this.getInvulTime() <= 0;
                            if (this.getTimeSinceLocked() < 260 && canSling && this.m_20197_().isEmpty()) {
                                this.setTimeSinceLocked(this.getTimeSinceLocked() + 1);
                            }
                            if (this.getTimeSinceLocked() >= 240 && canSling) {
                                if (this.m_20275_(this.getHome().m_123341_(), this.getHome().m_123342_(), this.getHome().m_123343_()) > 60.0) {
                                    this.m_21566_().m_6849_((double)this.getHome().m_123341_(), (double)this.getHome().m_123342_(), (double)this.getHome().m_123343_(), 1.0);
                                } else {
                                    this.slingToCeiling();
                                }
                            }
                        }
                        if (this.isCharging() && this.m_20275_(this.getHome().m_123341_(), this.getHome().m_123342_(), this.getHome().m_123343_()) > 60.0) {
                            this.m_21566_().m_6849_((double)this.getHome().m_123341_(), (double)this.getHome().m_123342_(), (double)this.getHome().m_123343_(), 1.0);
                        }
                    } else if (this.getTimeOnCeiling() > 0) {
                        boolean canScreech;
                        boolean bl = canScreech = this.getTicksUntilNextScreech() <= 0 && this.getTimeOnCeiling() > 600;
                        if (!this.isSecondPhase() || this.isSecondPhase() && this.getSpidersInDungeonArea(15.0).isEmpty() && !canScreech && this.m_20197_().isEmpty()) {
                            this.setTimeOnCeiling(this.getTimeOnCeiling() - 1);
                        }
                        Player closestPlayer = this.f_19853_.m_45930_((Entity)this, 30.0);
                        if (!this.getSpidersInDungeonArea(15.0).isEmpty() && closestPlayer != null) {
                            this.m_21563_().m_24960_((Entity)closestPlayer, 30.0f, 30.0f);
                        }
                        if (this.f_19797_ % 8 == 0 && this.f_20902_ != 0.0f) {
                            this.m_7355_(this.m_20183_(), SkiesBlocks.poison_stonebrick.m_49966_());
                        }
                        if (!this.m_20068_()) {
                            this.m_20242_(true);
                        }
                        if (this.m_20275_(this.getHome().m_123341_(), this.m_20186_(), this.getHome().m_123343_()) >= 2.0 && this.m_20197_().isEmpty()) {
                            this.m_21566_().m_6849_((double)this.getHome().m_123341_(), this.m_20186_(), (double)this.getHome().m_123343_(), 2.0);
                        }
                    } else {
                        this.setCeilingLocked(false);
                    }
                } else {
                    if (!this.m_20197_().isEmpty()) {
                        ((Entity)this.m_20197_().get(0)).m_8127_();
                    }
                    if (this.getStunTime() > 0) {
                        this.setStunTime(this.getStunTime() - 1);
                    } else {
                        this.setStunned(false);
                    }
                }
                if ((this.m_5448_() == null || this.isCeilingLocked()) && this.isCharging()) {
                    this.setCharging(false);
                }
                if (this.getTimeOnCeiling() == 320 && this.f_19796_.m_188499_()) {
                    this.setTimeOnCeiling(0);
                }
                if (this.isCeilingLocked()) {
                    this.oldPosRef = new HashMap<UUID, Vec3>();
                    for (Player players : this.getPlayersInDungeonArea(25.0, false)) {
                        this.oldPosRef.put(players.m_20148_(), players.m_20182_());
                    }
                } else {
                    this.oldPosRef = null;
                }
                break block41;
            }
            if (this.isCharging()) {
                for (t = 0; t < 4; ++t) {
                    this.spawnParticles((ParticleOptions)ParticleTypes.f_123755_);
                    int i = Mth.m_14107_((double)this.m_20185_());
                    int j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
                    int k = Mth.m_14107_((double)this.m_20189_());
                    BlockPos blockPos = Positions.blockPos((long)i, (long)j, (long)k);
                    BlockState blockstate = this.f_19853_.m_8055_(blockPos);
                    if (this.f_19853_.m_46859_(blockPos)) continue;
                    this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(Positions.blockPos((long)i, (long)j, (long)k)), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20191_().f_82289_ + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
                }
            }
            if (!this.isStunned()) break block41;
            for (t = 0; t < 4; ++t) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + (double)(this.f_19853_.f_46441_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19853_.f_46441_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19853_.f_46441_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), 0.1921568661928177, 0.5411764979362488, 0.01568627543747425);
            }
        }
    }

    @Override
    public void invulnerableTick() {
        super.invulnerableTick();
        if (this.f_19853_.f_46443_) {
            for (int t = 0; t < 4; ++t) {
                this.spawnParticles(new PoisonData(false));
                this.spawnParticles((ParticleOptions)ParticleTypes.f_123770_);
            }
        }
    }

    @Override
    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setCeilingLocked(compound.m_128471_("CelingLocked"));
        this.setCharging(compound.m_128471_("Charging"));
        this.setStunned(compound.m_128471_("Stunned"));
        this.setTimeOnCeiling(compound.m_128451_("TimeOnCeiling"));
        this.setTimeSinceLocked(compound.m_128451_("TimeSinceCeilingLocked"));
        this.setStunTime(compound.m_128451_("TimeStunned"));
        this.setTicksUntilNextScreech(compound.m_128451_("TicksUntilNextScreech"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("CelingLocked", this.isCeilingLocked());
        compound.m_128379_("Charging", this.isCharging());
        compound.m_128379_("Stunned", this.isStunned());
        compound.m_128405_("TimeOnCeiling", this.getTimeOnCeiling());
        compound.m_128405_("TimeSinceCeilingLocked", this.getTimeSinceLocked());
        compound.m_128405_("TimeStunned", this.getStunTime());
        compound.m_128405_("TicksUntilNextScreech", this.getTicksUntilNextScreech());
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.m_7307_(entityIn)) {
            return false;
        }
        if (entityIn instanceof Player) {
            ItemStack playerItem;
            Player player = (Player)entityIn;
            ItemStack itemStack = playerItem = player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_;
            if (!playerItem.m_41619_() && !this.f_19853_.f_46443_) {
                if (SHIELDS.contains(playerItem.m_41720_())) {
                    this.f_19853_.m_7605_((Entity)this, (byte)4);
                    this.setStunned(true);
                    this.f_19853_.m_7605_((Entity)player, (byte)29);
                    this.f_19853_.m_7605_((Entity)player, (byte)30);
                    player.m_36384_(true);
                    SHIELDS.forEach(item -> player.m_36335_().m_41524_(item, 300));
                    if (player.m_7655_() != null) {
                        playerItem.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
                    }
                    return false;
                }
                if (playerItem.canPerformAction(ToolActions.SHIELD_BLOCK)) {
                    player.m_5661_((Component)Component.m_237115_((String)"gui.blue_skies.tooltip.arachnarch_incorrect_shield"), true);
                    player.m_36384_(true);
                    this.f_19853_.m_7605_((Entity)player, (byte)30);
                    player.m_36335_().m_41524_(playerItem.m_41720_(), 800);
                    return super.m_7327_(entityIn);
                }
            }
        }
        return super.m_7327_(entityIn);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_20197_().isEmpty()) {
            this.damageSinceGrabbed += amount;
        }
        if (source.m_19390_()) {
            return super.m_6469_(source, amount);
        }
        if (this.isCeilingLocked() && this.m_20197_().isEmpty()) {
            return super.m_6469_(source, Math.min(1.0f, amount));
        }
        if (!this.isStunned()) {
            return super.m_6469_(source, amount * 0.8f);
        }
        return super.m_6469_(source, amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                this.setStunned(true);
                break;
            }
            case 5: {
                this.spawnParticles((ParticleOptions)ParticleTypes.f_123759_);
                break;
            }
            case 6: {
                this.clientScreechTime = 50;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            Vec3 vec3d = this.m_20252_(1.0f);
            passenger.m_6034_(this.m_20185_() + vec3d.f_82479_ * 3.0, this.m_20186_() + passenger.m_6049_() + (double)(this.isCeilingLocked() ? -Mth.m_14089_((float)((float)this.f_19797_ * 0.1f)) : Mth.m_14089_((float)((float)this.f_19797_ * 0.1f))) * 0.05 + (this.isCeilingLocked() ? (double)-1.2f : 1.4), this.m_20189_() + vec3d.f_82481_ * 3.0);
            if (this.isStunned() || this.holdingTime <= 0 || !this.f_19853_.f_46443_ && this.damageSinceGrabbed > 15.0f || !this.m_6084_()) {
                this.damageSinceGrabbed = 0.0f;
                passenger.m_8127_();
                this.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_THROW, this.m_6121_(), 2.0f);
                passenger.f_19864_ = true;
                passenger.m_20334_(vec3d.m_7096_() * 1.0, 0.5, vec3d.m_7094_() * 1.0);
            }
            if (this.damageSinceGrabbed > 15.0f) {
                passenger.m_20334_(vec3d.m_7096_() * 1.0, 0.5, vec3d.m_7094_() * 1.0);
                if (passenger instanceof Player) {
                    ((Player)passenger).f_19864_ = true;
                }
            }
        }
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return IMMUNE_EFFECTS.contains(potioneffectIn.m_19544_()) ? false : super.m_7301_(potioneffectIn);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.8f;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    public BossEvent.BossBarColor getBossBarColor() {
        return BossEvent.BossBarColor.PINK;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return SkiesDungeonType.POISON;
    }

    @Override
    public int getProgression() {
        return 2;
    }

    @Override
    public boolean isEverbrightBoss() {
        return false;
    }

    public boolean isCeilingLocked() {
        return (Boolean)this.f_19804_.m_135370_(CEILING_LOCKED);
    }

    public void setCeilingLocked(boolean locked) {
        this.f_19804_.m_135381_(CEILING_LOCKED, (Object)locked);
        this.m_21573_().m_26573_();
        if (locked) {
            this.setTimeOnCeiling(this.getTicksUntilNextScreech() == 0 && this.isSecondPhase() ? 610 : (this.f_19796_.m_188503_(5) == 0 ? 300 : 600));
        } else {
            this.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_FLIP, this.m_6121_(), this.m_6100_());
            this.m_20242_(false);
            this.setTimeSinceLocked(0);
        }
    }

    public int getTimeOnCeiling() {
        return (Integer)this.f_19804_.m_135370_(TIME_ON_CEILING);
    }

    public void setTimeOnCeiling(int time) {
        this.f_19804_.m_135381_(TIME_ON_CEILING, (Object)time);
    }

    public int getTimeSinceLocked() {
        return (Integer)this.f_19804_.m_135370_(TIME_SINCE_LOCKED);
    }

    public void setTimeSinceLocked(int time) {
        this.f_19804_.m_135381_(TIME_SINCE_LOCKED, (Object)time);
    }

    public int getStunTime() {
        return (Integer)this.f_19804_.m_135370_(TIME_STUNNED);
    }

    public void setStunTime(int time) {
        this.f_19804_.m_135381_(TIME_STUNNED, (Object)time);
    }

    public int getTicksUntilNextScreech() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_NEXT_SCREECH);
    }

    public void setTicksUntilNextScreech(int time) {
        this.f_19804_.m_135381_(TICKS_UNTIL_NEXT_SCREECH, (Object)time);
    }

    @Override
    public boolean isStunned() {
        return (Boolean)this.f_19804_.m_135370_(STUNNED);
    }

    public void setStunned(boolean stunned) {
        this.f_19804_.m_135381_(STUNNED, (Object)stunned);
        if (stunned) {
            if (this.f_19853_.f_46443_) {
                this.playStunSound();
                return;
            }
            this.setStunTime(Math.max(20, 60 - this.getExtraPlayers() * 10));
        } else {
            this.setStunTime(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playStunSound() {
        if (!this.m_20067_() && this.f_19853_.f_46443_) {
            SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
            if (this.stunSound == null || this.stunSound != null && !soundHandler.m_120403_(this.stunSound)) {
                this.stunSound = new StunnedEntitySound((LivingEntity)this, SkiesSounds.ENTITY_ARACHNARCH_STUNNED, this.m_6121_());
                soundHandler.m_120367_(this.stunSound);
            }
        }
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charge) {
        this.f_19804_.m_135381_(CHARGING, (Object)charge);
    }

    public void setHolding(LivingEntity entity) {
        this.holdingTime = 100;
        if (!this.f_19853_.f_46443_) {
            entity.m_20329_((Entity)this);
            this.damageSinceGrabbed = 0.0f;
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected SoundEvent m_7515_() {
        return this.isStunned() ? null : SkiesSounds.ENTITY_ARACHNARCH_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_ARACHNARCH_HURT;
    }

    protected SoundEvent m_5592_() {
        this.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_DEATH, this.m_6121_(), 1.0f);
        return super.m_5592_();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 0.5f);
    }

    public float m_6100_() {
        return super.m_6100_();
    }

    @Override
    protected float m_6121_() {
        return 2.0f;
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    public void m_7601_(BlockState state, Vec3 motionVec) {
        if (state.m_60734_() != Blocks.f_50033_ && state.m_60734_() != SkiesBlocks.spider_webbing) {
            super.m_7601_(state, motionVec);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (!(target instanceof Player)) {
            this.spit(target);
        }
        for (Player players : this.getPlayersInDungeonArea()) {
            this.spit((LivingEntity)players);
        }
    }

    private void spit(LivingEntity target) {
        this.m_146922_(this.f_20885_);
        if (this.getDifficultyID() == ISkyBoss.BossLevel.PLATINUM.getId() && this.isSecondPhase() && this.m_20275_(this.getHome().m_123341_(), this.m_20186_(), this.getHome().m_123343_()) > 2.0) {
            VenomSpitEntity venomSpit = new VenomSpitEntity(this.f_19853_, (LivingEntity)this);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - venomSpit.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2))) * 0.2f;
            venomSpit.m_6686_(d0, d1 + (double)f, d2, 1.5f, 0.0f);
            this.f_19853_.m_7967_((Entity)venomSpit);
            this.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_SPIT, this.m_6121_(), 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        } else if (this.m_20270_((Entity)target) > 8.0f) {
            Vec3 predictedVec = target.m_20182_();
            if (target instanceof Player) {
                Player player = (Player)target;
                if (this.getDifficultyID() > ISkyBoss.BossLevel.BRONZE.getId() && this.oldPosRef != null && this.oldPosRef.containsKey(player.m_20148_())) {
                    predictedVec = target.m_20182_().m_82549_(target.m_20182_().m_82546_(this.oldPosRef.get(player.m_20148_())).m_82490_(8.0));
                }
            }
            VenomSpitEntity venomSpit = new VenomSpitEntity(this.f_19853_, (LivingEntity)this);
            double x = predictedVec.f_82479_ - venomSpit.m_20185_();
            double y = target.m_20191_().f_82289_ + (double)(target.m_20192_() / 3.0f) - venomSpit.m_20186_();
            double z = predictedVec.f_82481_ - venomSpit.m_20189_();
            float f = Mth.m_14116_((float)((float)(x * x + z * z))) * ((double)this.m_20270_((Entity)target) < 9.0 ? 0.0f : this.m_20270_((Entity)target) * 0.01f);
            venomSpit.m_6686_(x, y + (double)f, z, 1.5f, 0.0f);
            venomSpit.setDeadly(true);
            this.f_19853_.m_7967_((Entity)venomSpit);
            this.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_SPIT, this.m_6121_(), 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        } else {
            VenomBombEntity venomBomb = new VenomBombEntity(this.f_19853_, (LivingEntity)this);
            venomBomb.effect = new MobEffectInstance(SkiesEffects.DEADLY_VENOM, 100, (int)this.getDifficultyID());
            venomBomb.m_146926_(venomBomb.m_146909_() + 20.0f);
            venomBomb.m_6034_(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            Vec3 look = this.m_20252_(1.0f);
            venomBomb.m_6686_(look.m_7096_() * (double)0.1f, 0.0, look.m_7094_() * (double)0.1f, 0.15f, 10.0f);
            this.f_19853_.m_7967_((Entity)venomBomb);
            this.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_VENOM_DROP, this.m_6121_(), 1.0f);
        }
    }

    public List<NestedSpiderEntity> getSpidersInDungeonArea(double distance) {
        if (this.getHome() != null && this.getHome() != BlockPos.f_121853_) {
            return this.f_19853_.m_45976_(NestedSpiderEntity.class, new AABB((double)this.getHome().m_123341_() - distance, (double)this.getHome().m_123342_() - 1.0, (double)this.getHome().m_123343_() - distance, (double)this.getHome().m_123341_() + distance, (double)this.getHome().m_123342_() + 10.0, (double)this.getHome().m_123343_() + distance));
        }
        return ImmutableList.of();
    }

    public void slingToCeiling() {
        this.setCeilingLocked(true);
        this.m_20334_(0.0, 3.0, 0.0);
        this.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_SLING, this.m_6121_(), this.m_6100_());
    }

    protected void m_6153_() {
        boolean flag = this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_);
        if (this.isCeilingLocked()) {
            this.setCeilingLocked(false);
        }
        ++this.deathTicks;
        if (this.deathTicks < 20) {
            super.m_6153_();
        }
        float money = 40.0f;
        if (this.deathTicks > 30 && this.deathTicks % 5 == 0 && flag) {
            this.dropExperience(Mth.m_14143_((float)(money * 0.08f)));
        }
        if (this.deathTicks >= 100 && !this.f_19853_.f_46443_ && !this.f_19853_.f_46443_) {
            if (this.deathTicks >= 120) {
                this.m_146870_();
            }
            if (this.deathTicks % 2 == 0) {
                for (int i = 0; i < 20; ++i) {
                    this.f_19853_.m_7605_((Entity)this, (byte)5);
                }
            }
        }
        if (this.isCharging()) {
            this.setCharging(false);
        }
    }

    private void dropExperience(int amount) {
        while (amount > 0) {
            int i = ExperienceOrb.m_20782_((int)amount);
            amount -= i;
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), i));
        }
    }

    public void m_6074_() {
        this.m_146870_();
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn.m_6095_().m_204039_(SkiesEntityTags.POISON_ALLIES)) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return super.m_7307_(entityIn) && entityIn != null && entityIn != this;
    }

    class VenomAttackGoal
    extends RangedAttackGoal {
        private final ArachnarchEntity boss;
        private boolean nestedSpidersDead;

        public VenomAttackGoal(RangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            super(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
            this.boss = ArachnarchEntity.this;
            this.nestedSpidersDead = this.boss.getSpidersInDungeonArea(15.0).isEmpty();
        }

        public boolean m_8036_() {
            if (!this.nestedSpidersDead || !super.m_8036_()) {
                return false;
            }
            return this.boss.isCeilingLocked() && this.boss.m_20275_(this.boss.getHome().m_123341_(), this.boss.m_20186_(), this.boss.getHome().m_123343_()) <= 2.0 && this.boss.getTimeOnCeiling() > 300 && this.boss.getTimeOnCeiling() <= 600;
        }

        public boolean m_8045_() {
            if (!this.nestedSpidersDead || !super.m_8045_()) {
                return false;
            }
            return this.boss.isCeilingLocked() && this.boss.m_20275_(this.boss.getHome().m_123341_(), this.boss.m_20186_(), this.boss.getHome().m_123343_()) <= 2.0 && this.boss.getTimeOnCeiling() > 300 && this.boss.getTimeOnCeiling() <= 600;
        }
    }

    class VenomWalkingAttackGoal
    extends RangedAttackGoal {
        private final ArachnarchEntity boss;
        private boolean nestedSpidersDead;

        public VenomWalkingAttackGoal(RangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            super(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
            this.boss = ArachnarchEntity.this;
            this.nestedSpidersDead = this.boss.getSpidersInDungeonArea(15.0).isEmpty();
        }

        public boolean m_8036_() {
            if (!(this.nestedSpidersDead && super.m_8036_() && this.boss.m_20197_().isEmpty())) {
                return false;
            }
            return this.boss.getDifficultyID() == ISkyBoss.BossLevel.PLATINUM.getId() && this.boss.isCeilingLocked() && this.boss.getTimeOnCeiling() <= 300 && this.boss.isSecondPhase();
        }

        public boolean m_8045_() {
            if (!(this.nestedSpidersDead && super.m_8045_() && this.boss.m_20197_().isEmpty())) {
                return false;
            }
            return this.boss.getDifficultyID() == ISkyBoss.BossLevel.PLATINUM.getId() && this.boss.isCeilingLocked() && this.boss.getTimeOnCeiling() <= 300 && this.boss.isSecondPhase();
        }
    }

    class LungeAtTargetGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final ArachnarchEntity boss;
        private int chargeTime;

        public LungeAtTargetGoal() {
            super(ArachnarchEntity.this);
            this.boss = ArachnarchEntity.this;
        }

        public boolean m_8036_() {
            if (this.boss.m_5448_() == null) {
                return false;
            }
            return !this.boss.isCeilingLocked() && !this.boss.isStunned() && this.boss.getInvulTime() <= 0 && this.boss.m_20197_().isEmpty() && this.boss.getTimeSinceLocked() <= this.getTimeNeededForLunge();
        }

        public boolean m_8045_() {
            return !this.boss.isCeilingLocked() && this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.m_20197_().isEmpty();
        }

        public void m_8056_() {
            List playersInDungeon = this.boss.getPlayersInDungeonArea();
            for (Player players : playersInDungeon) {
                if (players == this.boss.m_5448_() || !this.boss.f_19796_.m_188499_() || playersInDungeon.size() <= 1) continue;
                this.boss.m_6710_((LivingEntity)players);
            }
            this.chargeTime = 80;
            this.boss.setCharging(true);
            this.boss.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_CHARGE, this.boss.m_6121_(), this.boss.m_6100_());
        }

        public void m_8037_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return;
            }
            Level world = this.boss.f_19853_;
            this.boss.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime == 20) {
                this.boss.setCharging(false);
                Vec3 vec3d = this.boss.m_20184_();
                Vec3 vec3d1 = new Vec3(target.m_20185_() - this.boss.m_20185_(), 0.0, target.m_20189_() - this.boss.m_20189_());
                if (vec3d1.m_82556_() > 1.0E-7) {
                    vec3d1 = vec3d1.m_82541_().m_82490_(3.0).m_82549_(vec3d.m_82490_(3.0));
                }
                this.boss.m_20334_(vec3d1.f_82479_, 0.4, vec3d1.f_82481_);
                this.boss.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_LUNGE, this.boss.m_6121_(), this.boss.m_6100_());
            }
            List list = world.m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(this.chargeTime <= 5 ? 0.5 : 0.0));
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity) || ((LivingEntity)entity).f_20916_ > 0) continue;
                if (this.boss.isStunned()) {
                    return;
                }
                LivingEntity living = (LivingEntity)entity;
                boolean attack = this.boss.m_7327_((Entity)living);
                if (!attack || !this.boss.m_20197_().isEmpty() || !this.boss.isCharging() && !(this.boss.m_21223_() <= this.boss.m_21233_() / 2.0f)) continue;
                this.boss.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_ATTACK, this.boss.m_6121_(), this.boss.m_6100_());
                if (living.m_21051_(Attributes.f_22278_).m_22135_() < 1.0) {
                    this.boss.setHolding(living);
                }
                return;
            }
        }

        private int getTimeNeededForLunge() {
            return 180;
        }
    }

    class WalkAndDropGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final ArachnarchEntity boss;
        private int walkTime;

        public WalkAndDropGoal() {
            super(ArachnarchEntity.this);
            this.boss = ArachnarchEntity.this;
        }

        public boolean m_8036_() {
            if (!this.boss.m_20197_().isEmpty()) {
                return false;
            }
            return this.boss.isCeilingLocked() && this.boss.m_5448_() != null && this.boss.getTimeOnCeiling() < 300;
        }

        public boolean m_8045_() {
            if (!this.boss.m_20197_().isEmpty()) {
                return false;
            }
            return this.boss.isCeilingLocked() && this.boss.m_5448_() != null && this.walkTime > 0;
        }

        public void m_8056_() {
            this.walkTime = 300;
        }

        public void m_8037_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return;
            }
            Level world = this.boss.f_19853_;
            this.boss.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.walkTime > 0) {
                --this.walkTime;
                if (this.boss.m_20270_((Entity)target) >= 2.0f) {
                    this.boss.m_21566_().m_6849_(target.m_20185_(), this.boss.m_20186_(), target.m_20189_(), 15.0);
                }
                if (this.boss.f_19797_ % 10 == 0) {
                    Vec3 look = this.boss.m_20252_(1.0f);
                    VenomBombEntity venomBomb = new VenomBombEntity(world, (LivingEntity)this.boss);
                    venomBomb.effect = new MobEffectInstance(SkiesEffects.DEADLY_VENOM, 50, (int)this.boss.getDifficultyID());
                    venomBomb.m_146926_(venomBomb.m_146909_() + 20.0f);
                    venomBomb.m_6034_(this.boss.m_20185_() - look.m_7096_() * 1.0, this.boss.m_20186_() - 1.0, this.boss.m_20189_() - look.m_7094_() * 1.0);
                    venomBomb.m_6686_(look.m_7096_() * (double)0.1f, 0.0, look.m_7094_() * (double)0.1f, 0.15f, 10.0f);
                    venomBomb.lingering = true;
                    world.m_7967_((Entity)venomBomb);
                    this.boss.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_VENOM_DROP, 1.0f, 1.0f);
                }
            }
        }
    }

    class ScreechAttackGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final ArachnarchEntity boss;
        private int screechTime;

        public ScreechAttackGoal() {
            super(ArachnarchEntity.this);
            this.boss = ArachnarchEntity.this;
        }

        public boolean m_8036_() {
            boolean closeToHome = this.boss.m_20275_(this.boss.getHome().m_123341_(), this.boss.m_20186_(), this.boss.getHome().m_123343_()) <= 2.0;
            return this.boss.isCeilingLocked() && this.boss.m_5448_() != null && !this.boss.isStunned() && this.boss.getInvulTime() == 0 && this.boss.m_20197_().isEmpty() && this.boss.isSecondPhase() && this.boss.getTicksUntilNextScreech() <= 0 && this.boss.getTimeOnCeiling() > 600 && closeToHome;
        }

        public boolean m_8045_() {
            return this.boss.isCeilingLocked() && this.boss.m_5448_() != null && this.screechTime > 0 && !this.boss.isStunned() && this.boss.m_20197_().isEmpty();
        }

        public void m_8056_() {
            this.screechTime = 80;
        }

        public void m_8037_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return;
            }
            this.boss.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.screechTime > 0) {
                --this.screechTime;
            }
            if (this.screechTime == 75) {
                this.boss.f_19853_.m_7605_((Entity)this.boss, (byte)6);
                this.boss.m_5496_(SkiesSounds.ENTITY_ARACHNARCH_SCREECH, this.boss.m_6121_(), this.boss.m_6100_());
            }
            if (this.screechTime == 79 && !this.boss.f_19853_.f_46443_) {
                for (Player players : this.boss.getPlayersInDungeonArea()) {
                    players.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 120, 0, true, false));
                }
            }
            if (this.screechTime == 20) {
                BlockPos homePos = this.boss.getHome();
                int radius = 15;
                if (this.boss.f_19853_ instanceof ServerLevel) {
                    ServerLevel world = (ServerLevel)this.boss.f_19853_;
                    PoiManager pointofinterestmanager = world.m_8904_();
                    pointofinterestmanager.m_27056_((LevelReader)this.boss.f_19853_, homePos, radius);
                    Stream optional = world.m_8904_().m_27166_(poiType -> poiType.m_203565_(SkiesPoiTypes.SPIDER_NEST.getKey()), homePos, radius, PoiManager.Occupancy.ANY);
                    optional.forEach(poi -> {
                        BlockPos pos = poi.m_27257_();
                        BlockState funny = this.boss.f_19853_.m_8055_(pos);
                        if (funny.m_60734_() instanceof SpiderNestBlock && this.boss.f_19853_.f_46441_.m_188501_() < 0.7f) {
                            SpiderNestBlock.spawnSpiders(funny, this.boss.f_19853_, pos, SkiesEntityTypes.NESTED_SPIDER);
                        }
                    });
                }
            }
            if (this.screechTime <= 1) {
                this.boss.setTicksUntilNextScreech(1200);
            }
        }
    }
}

