/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons;

import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBossMob;
import com.legacy.blue_skies.registries.SkiesDamageSources;
import com.legacy.blue_skies.registries.SkiesDamageTypes;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArtificialGolemEntity
extends SkiesMonsterEntity
implements ISkyBossMob,
RangedAttackMob {
    public static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.m_135353_(ArtificialGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RANGED = SynchedEntityData.m_135353_(ArtificialGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(ArtificialGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int attackTimer;
    private LivingEntity caster;
    private UUID casterUuid;

    public ArtificialGolemEntity(EntityType<? extends ArtificialGolemEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 0;
    }

    public ArtificialGolemEntity(Level worldIn, LivingEntity casterIn) {
        this((EntityType<? extends ArtificialGolemEntity>)SkiesEntityTypes.ARTIFICIAL_GOLEM, worldIn);
        this.setCaster(casterIn);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.m_213946_(worldIn.m_213780_(), difficulty);
        if (reason == MobSpawnType.SPAWN_EGG) {
            float chance = this.f_19853_.f_46441_.m_188501_();
            if (chance < 0.3f) {
                this.setRanged(true);
            } else if (chance < 0.6f) {
                this.setEnraged(true);
            }
        }
        return spawnDataIn;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeGolemAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new RangedGolemAttackGoal(this, this, 1.0, 20, 15.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> !this.playerSpawned()));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, entity -> this.playerSpawned() && entity instanceof Enemy && !(entity instanceof Creeper)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENRAGED, (Object)this.phaseTwoQualified());
        this.f_19804_.m_135372_(RANGED, (Object)false);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.22f);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public void m_8107_() {
        int lifeTicks;
        super.m_8107_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.m_21525_()) {
            return;
        }
        int n = lifeTicks = this.playerSpawned() ? 1200 : 100;
        if (this.getCaster() != null) {
            if (this.m_5448_() != null) {
                if (!this.getCaster().m_6084_() || this.getCaster().m_21223_() == 0.0f) {
                    this.m_21373_();
                    this.m_146870_();
                }
            } else if (!this.f_19853_.f_46443_ && (this.playerSpawned() && !this.getCaster().m_6084_() || this.f_19797_ > lifeTicks)) {
                this.m_21373_();
                this.m_146870_();
            }
        }
        if (this.m_5448_() != null) {
            float speed = 1.0f;
            if (!this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.m_21573_().m_5624_((Entity)this.m_5448_(), (double)speed);
            } else if (this.m_20270_((Entity)this.m_5448_()) > 1.5f) {
                this.m_21566_().m_6849_(this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_(), (double)speed);
            }
        } else if (this.playerSpawned()) {
            if (!this.isRanged() && this.getCaster().m_21223_() < this.getCaster().m_21233_() != this.isEnraged()) {
                this.m_5496_(this.isEnraged() ? SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_DEACTIVATE : SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_ACTIVATE, 1.0f, 1.0f);
                this.setEnraged(this.getCaster().m_21223_() < this.getCaster().m_21233_());
            }
            if (this.m_20270_((Entity)this.getCaster()) > 15.0f) {
                this.m_6021_(this.getCaster().m_20185_(), this.getCaster().m_20186_(), this.getCaster().m_20189_());
            } else if (this.m_20270_((Entity)this.getCaster()) > 7.0f) {
                this.m_21573_().m_5624_((Entity)this.getCaster(), 1.0);
                this.m_21563_().m_24960_((Entity)this.getCaster(), 40.0f, 40.0f);
            }
        }
    }

    public void m_20258_(CompoundTag tagCompound) {
        super.m_20258_(tagCompound);
        if (tagCompound.m_128441_("PhaseTwo")) {
            this.setEnraged(tagCompound.m_128471_("PhaseTwo"));
        } else {
            this.setEnraged(tagCompound.m_128471_("IsEnraged"));
        }
        if (tagCompound.m_128441_("IsArcher")) {
            this.setRanged(tagCompound.m_128471_("IsArcher"));
        } else {
            this.setRanged(tagCompound.m_128471_("IsRanged"));
        }
        if (tagCompound.m_128441_("OwnerUUID")) {
            this.casterUuid = tagCompound.m_128342_("OwnerUUID");
        }
        if (tagCompound.m_128441_("GolemAttacking")) {
            this.setAttacking(tagCompound.m_128471_("GolemAttacking"));
        }
    }

    public void m_7380_(CompoundTag tagCompound) {
        super.m_7380_(tagCompound);
        if (this.casterUuid != null) {
            tagCompound.m_128362_("OwnerUUID", this.casterUuid);
        }
        tagCompound.m_128379_("IsEnraged", this.isEnraged());
        tagCompound.m_128379_("IsRanged", this.isRanged());
        tagCompound.m_128379_("GolemAttacking", this.getAttacking());
    }

    public boolean m_7327_(Entity entityIn) {
        if (entityIn != null) {
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            this.attackTimer = 10;
            float damage = (this.playerSpawned() ? 2.0f : 0.0f) + (this.isEnraged() ? 3.5f : 2.5f);
            boolean flag = entityIn.m_6469_(this.getCaster() != null ? SkiesDamageSources.instance.summon((Entity)this, this.getCaster()) : this.m_269291_().m_269333_((LivingEntity)this), damage);
            if (flag) {
                this.m_19970_((LivingEntity)this, entityIn);
            }
            this.m_5496_(SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_ATTACK, 1.0f, 1.0f);
            return flag;
        }
        return super.m_7327_(entityIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.m_5496_(SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_ATTACK, 1.0f, 1.0f);
        } else {
            super.m_7822_(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (this.getCaster() != null && entityIn.equals((Object)this.getCaster())) {
            return true;
        }
        if (entityIn instanceof Vex) {
            return this.m_7307_((Entity)((Vex)entityIn).m_19749_());
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return super.m_7307_(entityIn) && entityIn != this;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269014_() && source.m_7639_() instanceof ArtificialGolemEntity) {
            return false;
        }
        return !source.m_276093_(SkiesDamageTypes.STRANGE_LIGHTNING.getKey()) && super.m_6469_(source, amount);
    }

    public void m_6710_(@Nullable LivingEntity entitylivingbaseIn) {
        super.m_6710_(entitylivingbaseIn);
        if (entitylivingbaseIn != null) {
            this.setAttacking(true);
        } else {
            this.setAttacking(false);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_DEATH;
    }

    public float m_6100_() {
        return EntityUtil.getSoundPitchWithStart(this.f_19796_, 0.9f, 0.15f);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    public void setRanged(boolean archer) {
        this.f_19804_.m_135381_(RANGED, (Object)archer);
        if (archer) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(this.m_21233_());
        }
    }

    public boolean isRanged() {
        return (Boolean)this.f_19804_.m_135370_(RANGED);
    }

    public void setAttacking(boolean att) {
        this.f_19804_.m_135381_(ATTACKING, (Object)att);
    }

    public boolean getAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setCaster(LivingEntity entityIn) {
        this.caster = entityIn;
        this.casterUuid = entityIn == null ? null : entityIn.m_20148_();
    }

    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void setEnraged(boolean phaseTwo) {
        if (this.isRanged()) {
            return;
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(phaseTwo ? (double)(this.shouldBuff() ? 0.27f : 0.25f) : (double)(this.shouldBuff() ? 0.25f : 0.22f));
        this.f_19804_.m_135381_(ENRAGED, (Object)phaseTwo);
    }

    public boolean isEnraged() {
        return (Boolean)this.f_19804_.m_135370_(ENRAGED);
    }

    public boolean phaseTwoQualified() {
        return this.getCaster() != null && this.getCaster().m_21223_() == this.getCaster().m_21223_() / this.getCaster().m_21233_();
    }

    public boolean playerSpawned() {
        return this.getCaster() != null && this.getCaster() instanceof Player;
    }

    private boolean shouldBuff() {
        SummonerEntity summoner;
        return this.getCaster() != null && this.getCaster() instanceof SummonerEntity && (summoner = (SummonerEntity)this.getCaster()).getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        AbstractArrow abstractarrowentity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)new ItemStack((ItemLike)Items.f_42412_), (float)distanceFactor);
        abstractarrowentity = ((BowItem)new ItemStack((ItemLike)Items.f_42411_).m_41720_()).customArrow(abstractarrowentity);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - abstractarrowentity.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    public boolean m_6072_() {
        return false;
    }

    protected boolean m_7341_(Entity pEntity) {
        return false;
    }

    class MeleeGolemAttackGoal
    extends MeleeAttackGoal {
        private int failedPathFindingPenalty;
        private double targetX;
        private double targetY;
        private double targetZ;
        private boolean longMemory;
        private boolean canPenalize;

        public MeleeGolemAttackGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
            this.failedPathFindingPenalty = 0;
            this.canPenalize = false;
            this.longMemory = useLongMemory;
        }

        public boolean m_8036_() {
            ArtificialGolemEntity golem = (ArtificialGolemEntity)this.f_25540_;
            return super.m_8036_() && !golem.isRanged();
        }

        public boolean m_8045_() {
            ArtificialGolemEntity golem = (ArtificialGolemEntity)this.f_25540_;
            return super.m_8045_() && !golem.isRanged();
        }

        public void m_8037_() {
            if (this.f_25540_ != null && this.f_25540_.m_5448_() == null || this.f_25540_ == null) {
                return;
            }
            LivingEntity livingentity = this.f_25540_.m_5448_();
            this.f_25540_.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            double d0 = this.f_25540_.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            this.f_25547_ = Math.max(this.f_25547_ - 1, 0);
            if ((this.longMemory || this.f_25540_.m_21574_().m_148306_((Entity)livingentity)) && this.f_25547_ <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.f_25540_.m_217043_().m_188501_() < 0.05f)) {
                this.targetX = livingentity.m_20185_();
                this.targetY = livingentity.m_20186_();
                this.targetZ = livingentity.m_20189_();
                this.f_25547_ = 4 + this.f_25540_.m_217043_().m_188503_(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.f_25547_ += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.f_25540_.m_21573_().m_26570_() != null ? ((finalPathPoint = this.f_25540_.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.f_25547_ += 10;
                } else if (d0 > 256.0) {
                    this.f_25547_ += 5;
                }
            }
            this.f_25548_ = Math.max(this.f_25548_ - 1, 0);
            this.m_6739_(livingentity, d0);
        }
    }

    class RangedGolemAttackGoal<T extends ArtificialGolemEntity>
    extends Goal {
        private final T entity;
        private final double moveSpeedAmp;
        private int attackCooldown;
        private final float maxAttackDistance;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        final /* synthetic */ ArtificialGolemEntity this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public RangedGolemAttackGoal(T t, double attackCooldownIn, int n, float f) {
            void maxAttackDistanceIn;
            void mob;
            this.this$0 = (ArtificialGolemEntity)this$0;
            this.entity = mob;
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.attackCooldown = (int)attackCooldownIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void setAttackCooldown(int attackCooldownIn) {
            this.attackCooldown = attackCooldownIn;
        }

        public boolean m_8036_() {
            return this.entity.m_5448_() == null ? false : ((ArtificialGolemEntity)this.entity).isRanged();
        }

        public boolean m_8045_() {
            return ((ArtificialGolemEntity)this.entity).isRanged() && (this.m_8036_() || !this.entity.m_21573_().m_26571_());
        }

        public void m_8056_() {
            super.m_8056_();
            this.entity.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.entity.m_21561_(false);
            this.seeTime = 0;
            this.entity.m_5810_();
        }

        public void m_8037_() {
            LivingEntity livingentity = this.entity.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.entity.m_20275_(livingentity.m_20185_(), livingentity.m_20191_().f_82289_, livingentity.m_20189_());
                boolean flag = this.entity.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    this.entity.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.entity.m_21573_().m_5624_((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.entity.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.entity.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                if (!flag && this.seeTime < -60) {
                    this.entity.m_5810_();
                } else if (flag && ((ArtificialGolemEntity)this.entity).f_19797_ % 40 == 0) {
                    this.entity.m_5810_();
                    this.entity.m_6504_(livingentity, BowItem.m_40661_((int)(20 + this.this$0.f_19796_.m_188503_(5))));
                }
            }
        }
    }
}

