/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.entities.util.base.SkiesMountEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.structure_gel.api.util.Positions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

public class CrogreEntity
extends SkiesMountEntity {
    private float prevJumpAnim;
    private float jumpAnim;
    private float prevSwimAnim;
    private float swimAnim;
    private boolean playSwimAnim;

    public CrogreEntity(EntityType<? extends CrogreEntity> type, Level worldIn) {
        super((EntityType<? extends SkiesMountEntity>)type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.getTameItem()}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            protected Vec3 m_7037_() {
                return LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)(this.f_25725_.m_20072_() ? 60 : 40), (int)10);
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_204166_(pos) != null && ((Biome)worldIn.m_204166_(pos).m_203334_()).m_264600_(pos) == Biome.Precipitation.RAIN ? 0.5f : 0.0f;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (distance > 10.0f) {
            return super.m_142535_(distance - 10.0f, damageMultiplier, source);
        }
        return false;
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.45;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.prevJumpAnim = this.jumpAnim;
            this.prevSwimAnim = this.swimAnim;
            this.jumpAnim = !this.m_21525_() && !this.m_20072_() && this.f_20899_ && this.m_20184_().m_7098_() > 0.0 ? Mth.m_14036_((float)(this.jumpAnim + 1.0f), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.jumpAnim - 1.0f), (float)0.0f, (float)6.0f);
            this.swimAnim = this.playSwimAnim ? Mth.m_14036_((float)(this.swimAnim + 1.0f), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.swimAnim - 1.0f), (float)0.0f, (float)6.0f);
        } else if (!this.m_21573_().m_26571_()) {
            Node path = this.m_21573_().m_26570_().m_77395_();
            double d1 = (double)path.f_77271_ - this.m_20185_();
            double d2 = (double)path.f_77273_ - this.m_20189_();
            this.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
        }
        if (!this.m_20072_()) {
            if (this.f_19861_ || this.m_20160_() && this.m_20184_().m_7098_() < 0.0) {
                this.m_6862_(false);
                this.f_19853_.m_7605_((Entity)this, (byte)5);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
            }
        }
        if (this.f_19797_ % 20 == 10) {
            if (this.f_20899_ && this.f_19861_) {
                this.m_6862_(false);
                this.f_19853_.m_7605_((Entity)this, (byte)5);
            }
            if (!this.m_20072_() || this.swimAnim >= 6.0f && this.prevSwimAnim >= 6.0f) {
                this.setCrogreSwimming(false);
            }
        }
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(jumping);
        if (jumping && !this.m_20072_() && !this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)10);
        }
    }

    public void setCrogreSwimming(boolean swimming) {
        if (swimming) {
            this.playSwimAnim = true;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        } else {
            this.playSwimAnim = false;
            this.f_19853_.m_7605_((Entity)this, (byte)9);
        }
    }

    protected SoundEvent m_7515_() {
        return this.f_19853_.m_46758_(this.m_20183_().m_7494_()) ? SkiesSounds.ENTITY_CROGRE_IDLE_HAPPY : SkiesSounds.ENTITY_CROGRE_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_CROGRE_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_CROGRE_DEATH;
    }

    @Override
    public AgeableMob createChild(AgeableMob ageable) {
        return (AgeableMob)SkiesEntityTypes.CROGRE.m_20615_(this.f_19853_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getJumpingAnimationScale(float pctIn) {
        return Mth.m_14179_((float)pctIn, (float)this.prevJumpAnim, (float)this.jumpAnim) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSwimmingAnimationScale(float pctIn) {
        return Mth.m_14179_((float)pctIn, (float)this.prevSwimAnim, (float)this.swimAnim) / 5.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                this.m_6862_(true);
                break;
            }
            case 5: {
                this.m_6862_(false);
                break;
            }
            case 8: {
                this.playSwimAnim = true;
                break;
            }
            case 9: {
                this.playSwimAnim = false;
                break;
            }
            case 10: {
                if (!this.f_19853_.f_46443_) break;
                EntityUtil.playMovingSound(SkiesSounds.ENTITY_CROGRE_JUMP, (LivingEntity)this, this.m_6121_(), this.m_6100_());
                break;
            }
            case 11: {
                if (!this.f_19853_.f_46443_) break;
                EntityUtil.playMovingSound(this.m_5501_(), (LivingEntity)this, 0.1f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public boolean m_6147_() {
        return false;
    }

    public void onMove(MoveHelperController helper, double distanceIn) {
        if (!this.m_21573_().m_26571_() && this.m_20197_().isEmpty() && !this.m_6109_()) {
            double motion;
            Node path = this.m_21573_().m_26570_().m_77395_();
            BlockPos finalPos = Positions.blockPos((long)path.f_77271_, (long)path.f_77272_, (long)path.f_77273_);
            Vec3 vector3d = this.m_20252_(1.0f);
            double distanceToFinal = EntityUtil.getDistanceToPos((Vec3i)this.m_20183_(), (Vec3i)finalPos);
            if (distanceToFinal < 0.5) {
                return;
            }
            double newMotion = 1.5 * distanceToFinal / 8.5;
            double d = motion = this.m_6162_() ? Math.min(newMotion, 0.5) : Math.min(newMotion, 1.5);
            if (!this.m_20072_() && this.f_19861_) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.m_6862_(true);
                helper.m_6849_(path.f_77271_, path.f_77272_, path.f_77273_, 1.0);
                Vec3 currentMotion = this.m_20184_();
                Vec3 motionTowardsTarget = new Vec3(this.m_20185_() - (double)path.f_77271_, 0.0, this.m_20189_() - (double)path.f_77273_);
                if (motionTowardsTarget.m_82556_() > 1.0E-7) {
                    motionTowardsTarget = motionTowardsTarget.m_82541_().m_82490_(-motion).m_82549_(currentMotion);
                }
                this.m_20256_(new Vec3(motionTowardsTarget.f_82479_, this.m_6162_() ? 0.5 : Math.min(1.0 * distanceToFinal / 5.0, 1.0), motionTowardsTarget.f_82481_));
                if (distanceToFinal <= 3.0) {
                    this.f_21344_.m_26573_();
                }
            }
            if (this.m_20072_() && this.m_20197_().isEmpty()) {
                if (distanceToFinal <= 2.0) {
                    this.f_21344_.m_26573_();
                }
                if (this.f_19797_ % 20 == 0) {
                    this.setCrogreSwimming(true);
                    this.m_20256_(new Vec3(vector3d.f_82479_ * 0.5, !this.f_19853_.m_45772_(this.m_20191_().m_82377_(0.5, 0.0, 0.5)) ? (double)0.2f : 0.0, vector3d.f_82481_ * 0.5));
                } else if (this.f_19797_ % 20 == 10) {
                    this.setCrogreSwimming(false);
                }
            }
        }
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return type == ForgeMod.WATER_TYPE.get();
    }

    @Override
    public void m_7023_(Vec3 travelVectorIn) {
        if (this.m_6084_()) {
            Entity entity;
            Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
            if (this.isSaddled() && entity instanceof Player) {
                boolean local;
                Player player = (Player)entity;
                this.m_146922_(entity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(entity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
                this.f_19793_ = 1.0f;
                float forward = player.f_20902_;
                float backward = 0.0f;
                if (forward <= 0.0f) {
                    backward = -forward;
                    forward = 0.0f;
                }
                if (local = this.m_6109_()) {
                    float f = (float)this.m_21051_(Attributes.f_22279_).m_22135_() * 0.225f;
                    this.m_7910_(f);
                }
                Vec3 vector3d = this.m_20252_(1.0f);
                if (forward > 0.0f) {
                    if (!this.m_20072_() && this.f_19861_) {
                        if (local) {
                            if (this.f_19853_.f_46443_) {
                                EntityUtil.playMovingSound(SkiesSounds.ENTITY_CROGRE_JUMP, (LivingEntity)this, this.m_6121_(), this.m_6100_());
                            }
                            this.m_6862_(true);
                            this.m_20256_(new Vec3(vector3d.f_82479_ * 1.0, 1.0, vector3d.f_82481_ * 1.0));
                        } else {
                            Level level = this.f_19853_;
                            if (level instanceof ServerLevel) {
                                ServerLevel sl = (ServerLevel)level;
                                sl.m_6269_(player, (Entity)this, SkiesSounds.ENTITY_CROGRE_JUMP, SoundSource.NEUTRAL, this.m_6121_(), this.m_6100_());
                            }
                            this.f_19853_.m_7605_((Entity)this, (byte)4);
                        }
                    } else if (this.m_20072_()) {
                        if (this.f_19797_ % 20 == 0) {
                            Level level;
                            if (local) {
                                this.setCrogreSwimming(true);
                                if (this.f_19853_.f_46443_) {
                                    EntityUtil.playMovingSound(this.m_5501_(), (LivingEntity)this, 0.1f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                                }
                                float strength = 0.8f;
                                this.m_20256_(new Vec3(vector3d.f_82479_ * (double)strength, !this.f_19853_.m_45772_(this.m_20191_().m_82377_(0.5, 0.0, 0.5)) ? (double)0.2f : 0.0, vector3d.f_82481_ * (double)strength));
                            }
                            if ((level = this.f_19853_) instanceof ServerLevel) {
                                ServerLevel sl = (ServerLevel)level;
                                sl.m_6269_(player, (Entity)this, this.m_5501_(), SoundSource.NEUTRAL, 0.1f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                            }
                        } else if (this.f_19797_ % 20 == 10 && local) {
                            this.setCrogreSwimming(false);
                        }
                    }
                } else if (local) {
                    float stopMul = backward > 0.0f ? 0.85f : 0.95f;
                    this.m_20256_(this.m_20184_().m_82542_((double)stopMul, 1.0, (double)stopMul));
                }
                if (local) {
                    super.m_7023_(new Vec3(0.0, 0.0, (double)forward));
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                this.f_19793_ = 0.5f;
                super.m_7023_(travelVectorIn);
            }
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!super.m_6071_(player, hand).m_19077_() && itemstack.m_41720_() == this.getTameItem()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (!this.f_19853_.f_46443_) {
                if (!this.isTamed()) {
                    if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                        this.playTameEffect(true);
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                        this.setTamed(true);
                    } else {
                        this.playTameEffect(false);
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                    }
                } else if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(2.0f);
                }
                this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void jumpInFluid(FluidType type) {
        if (this.m_6109_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.m_5842_() ? (double)0.05f : (this.f_19853_.m_46801_(Positions.blockPos((Position)this.m_146892_().m_82520_(0.0, (double)-0.1f, 0.0))) ? 0.02 : 0.0), 0.0));
        } else {
            super.jumpInFluid(type);
        }
    }

    @Override
    public Item getSaddleItem() {
        return Items.f_42450_;
    }

    @Override
    public Item getTameItem() {
        return SkiesItems.bug_guts;
    }

    @Override
    public boolean useTraditionalTravel() {
        return true;
    }

    @Override
    public int getMaxInventorySlots() {
        return 1;
    }

    class MoveHelperController
    extends MoveControl {
        private final CrogreEntity frog;

        public MoveHelperController(CrogreEntity frogIn) {
            super((Mob)frogIn);
            this.frog = frogIn;
        }

        public void m_8126_() {
            if (!this.frog.m_20197_().isEmpty()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                return;
            }
            double d0 = this.f_24975_ - this.f_24974_.m_20185_();
            double d1 = this.f_24977_ - this.f_24974_.m_20189_();
            double d3 = d0 * d0 + d1 * d1;
            this.frog.onMove(this, Mth.m_14116_((float)((float)d3)));
            if (!this.frog.m_21691_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
        }

        public MoveControl.Operation getAction() {
            return this.f_24981_;
        }
    }
}

