/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools.weapons;

import com.legacy.blue_skies.blocks.dungeon.SkyDecayingSpikeBlock;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.StringUtil;
import com.legacy.structure_gel.api.util.Positions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlchemyScrollItem
extends Item {
    public AlchemyScrollItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack useStack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (useStack.m_41720_() == this && player.m_7655_() == hand) {
            player.f_19853_.m_6269_(null, (Entity)player, SkiesSounds.ENTITY_PLAYER_PREPARE_ROCKS, SoundSource.PLAYERS, 1.0f, 1.0f);
            AlchemyScrollItem.beginSpikeSpawning(player, false);
        }
        return InteractionResultHolder.m_19098_((Object)useStack);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityIn, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        if (entityIn instanceof Player && i > 20) {
            Player player = (Player)entityIn;
            player.m_36335_().m_41524_((Item)this, 80);
            ItemStack itemstack = entityIn.m_21120_(player.m_7655_());
            itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
            AlchemyScrollItem.beginSpikeSpawning(player, true);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            player.f_19853_.m_6269_(null, (Entity)player, SkiesSounds.ENTITY_PLAYER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static void spawnSpikeLine(Player playerIn, double posX, double posZ, double maxY, double posY) {
        BlockPos blockpos = Positions.blockPos((double)posX, (double)posY, (double)posZ);
        boolean flag = playerIn.f_19853_.m_46859_(blockpos);
        double d0 = 0.0;
        if (flag) {
            BlockPos blockpos2 = Positions.blockPos((double)posX, (double)((double)blockpos.m_123342_() + d0 + 5.0), (double)posZ);
            DecayingSpikeEntity block = new DecayingSpikeEntity(playerIn.f_19853_, blockpos2, SkiesBlocks.decaying_spike.m_49966_(), (LivingEntity)playerIn);
            block.setDownwards(true);
            block.f_31942_ = 200;
            block.f_31943_ = false;
            playerIn.f_19853_.m_7967_((Entity)block);
        }
    }

    private static void spawnSpikeCircle(Player playerIn, double posX, double posZ, double maxY, double posY) {
        BlockPos blockpos = Positions.blockPos((double)posX, (double)posY, (double)posZ);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState iblockstate;
            VoxelShape voxelshape;
            if (!playerIn.f_19853_.m_46859_(blockpos) || playerIn.f_19853_.m_46859_(blockpos.m_7495_())) continue;
            if (!playerIn.f_19853_.m_46859_(blockpos) && (voxelshape = (iblockstate = playerIn.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)playerIn.f_19853_, blockpos)) != null) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
        if (flag) {
            BlockPos blockpos2 = Positions.blockPos((double)((double)blockpos.m_123341_() + d0), (double)((double)blockpos.m_123342_() + d0), (double)((double)blockpos.m_123343_() + d0));
            DecayingSpikeEntity block = new DecayingSpikeEntity(playerIn.f_19853_, blockpos2, (BlockState)SkiesBlocks.decaying_spike.m_49966_().m_61124_((Property)SkyDecayingSpikeBlock.DOWNWARD, (Comparable)Boolean.valueOf(false)), (LivingEntity)playerIn);
            block.setDownwards(false);
            block.m_6034_((double)blockpos2.m_123341_() + 0.5, blockpos2.m_123342_(), (double)blockpos2.m_123343_() + 0.5);
            block.f_31942_ = 200;
            block.m_20334_(0.0, 0.7, 0.0);
            block.f_31943_ = false;
            playerIn.f_19853_.m_7967_((Entity)block);
        }
    }

    private static void playSpikeParticles(Player playerIn, double posX, double posY, double posZ, double offsetX, double offsetY, double offsetZ) {
        int count = 20;
        if (playerIn.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)playerIn.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, SkiesBlocks.decaying_spike.m_49966_()), posX, posY, posZ, count, offsetX, offsetY, offsetZ, 0.05);
        }
    }

    public static void beginSpikeSpawning(Player playerIn, boolean spawnSpikes) {
        AlchemyScrollItem.beginSpikeSpawning(playerIn, spawnSpikes, 8);
    }

    public static void beginSpikeSpawning(Player playerIn, boolean spawnSpikes, int particleAmount) {
        Vec3 look = playerIn.m_20252_(1.0f);
        double targetX = playerIn.m_20185_() + look.m_7096_() * 3.0;
        double targetZ = playerIn.m_20189_() + look.m_7094_() * 3.0;
        double d0 = playerIn.m_20186_();
        double d1 = playerIn.m_20186_() + 1.0;
        float f = (float)Mth.m_14136_((double)(targetZ - playerIn.m_20189_()), (double)(targetX - playerIn.m_20185_()));
        if (playerIn.m_6144_()) {
            for (int k = 0; k < particleAmount; ++k) {
                float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                AlchemyScrollItem.playSpikeParticles(playerIn, playerIn.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.0, playerIn.m_20186_() + 0.2, playerIn.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.0, playerIn.m_20205_() / 4.0f, playerIn.m_20206_() / 4.0f, playerIn.m_20205_() / 4.0f);
                if (!spawnSpikes) continue;
                AlchemyScrollItem.spawnSpikeCircle(playerIn, playerIn.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.0, playerIn.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.0, d0, d1);
            }
        } else {
            for (int l = 0; l < particleAmount; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                AlchemyScrollItem.playSpikeParticles(playerIn, playerIn.m_20185_() + (double)Mth.m_14089_((float)f) * d2, playerIn.m_20186_() + 5.0, playerIn.m_20189_() + (double)Mth.m_14031_((float)f) * d2, playerIn.m_20205_() / 4.0f, playerIn.m_20206_() / 4.0f, playerIn.m_20205_() / 4.0f);
                if (!spawnSpikes) continue;
                AlchemyScrollItem.spawnSpikeLine(playerIn, playerIn.m_20185_() + (double)Mth.m_14089_((float)f) * d2, playerIn.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> lore, TooltipFlag flagIn) {
        lore.add((Component)Component.m_237113_((String)StringUtil.getAbilityText("gui.blue_skies.item.ability.alchemy_scroll")));
    }
}

