/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.items.util.PreparedFood;
import com.legacy.blue_skies.registries.SkiesItems;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraftforge.registries.ForgeRegistries;

public class FoodPrepUtils {
    public static final String INGREDIENTS_KEY = "Ingredients";
    public static final String TOTAL_HUNGER_KEY = "Total_Hunger";
    public static final String SATURATION_KEY = "Saturation";
    public static final String USES_KEY = "Uses";
    public static final String MAX_USES_KEY = "MaxUses";
    public static final String EFFECTS_KEY = "Effects";

    public static void serialize(CompoundTag itemNbt, PreparedFood preparedFood) {
        ListTag ingredients = new ListTag();
        preparedFood.getIngredients().forEach(i -> ingredients.add((Object)i.m_41739_(new CompoundTag())));
        itemNbt.m_128365_(INGREDIENTS_KEY, (Tag)ingredients);
        itemNbt.m_128405_(TOTAL_HUNGER_KEY, preparedFood.getTotalHunger());
        itemNbt.m_128350_(SATURATION_KEY, preparedFood.getSaturation());
        itemNbt.m_128405_(USES_KEY, preparedFood.getUses());
        itemNbt.m_128405_(MAX_USES_KEY, preparedFood.getMaxUses());
        ListTag effects = new ListTag();
        preparedFood.getEffects().forEach(e -> effects.add((Object)e.m_19555_(new CompoundTag())));
        itemNbt.m_128365_(EFFECTS_KEY, (Tag)effects);
    }

    public static PreparedFood deserialize(@Nullable CompoundTag itemNbt) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        int totalHunger = 1;
        int uses = 1;
        int maxUses = 1;
        float saturation = 0.0f;
        if (itemNbt != null) {
            if (itemNbt.m_128441_(INGREDIENTS_KEY)) {
                itemNbt.m_128437_(INGREDIENTS_KEY, 10).forEach(nbt -> {
                    ItemStack ingredient = null;
                    try {
                        ingredient = ItemStack.m_41712_((CompoundTag)((CompoundTag)nbt));
                    }
                    catch (Exception e) {
                        BlueSkies.LOGGER.warn((Object)e);
                    }
                    if (ingredient != null) {
                        ingredients.add(ingredient);
                    }
                });
            }
            if (itemNbt.m_128441_(EFFECTS_KEY)) {
                itemNbt.m_128437_(EFFECTS_KEY, 10).forEach(nbt -> {
                    MobEffectInstance effect = null;
                    try {
                        effect = MobEffectInstance.m_19560_((CompoundTag)((CompoundTag)nbt));
                    }
                    catch (Exception e) {
                        BlueSkies.LOGGER.warn((Object)e);
                    }
                    if (effect != null) {
                        effects.add(effect);
                    }
                });
            }
            if (itemNbt.m_128441_(TOTAL_HUNGER_KEY)) {
                totalHunger = itemNbt.m_128451_(TOTAL_HUNGER_KEY);
            }
            if (itemNbt.m_128441_(USES_KEY)) {
                uses = itemNbt.m_128451_(USES_KEY);
            }
            if (itemNbt.m_128441_(MAX_USES_KEY)) {
                maxUses = itemNbt.m_128451_(MAX_USES_KEY);
            }
            if (itemNbt.m_128441_(SATURATION_KEY)) {
                saturation = itemNbt.m_128457_(SATURATION_KEY);
            }
        }
        return new PreparedFood(ingredients, effects, totalHunger, uses, maxUses, saturation);
    }

    public static int getUses(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(USES_KEY)) {
            return tag.m_128451_(USES_KEY);
        }
        return FoodPrepUtils.getMaxUses(stack);
    }

    public static int getMaxUses(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(MAX_USES_KEY)) {
            return tag.m_128451_(MAX_USES_KEY);
        }
        return 1;
    }

    public static ItemStack createFoodFromItems(List<ItemLike> ingredients) {
        return FoodPrepUtils.createFood(ingredients.stream().map(item -> new ItemStack(item)).toList());
    }

    public static ItemStack createFood(Container inventory) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (slotStack.m_41619_()) continue;
            if (!FoodPrepUtils.isValidIngredient(slotStack)) {
                return ItemStack.f_41583_;
            }
            ingredients.add(slotStack);
        }
        return FoodPrepUtils.createFood(ingredients);
    }

    public static ItemStack createFood(List<ItemStack> ingredients) {
        if (ingredients.size() < 3) {
            return ItemStack.f_41583_;
        }
        int p = 0;
        for (int i = 0; i < ingredients.size(); ++i) {
            if (ingredients.get(i).m_41720_() == Items.f_42589_) {
                ++p;
            }
            if (p <= 2) continue;
            return ItemStack.f_41583_;
        }
        int totalHunger = FoodPrepUtils.getTotalHunger(ingredients);
        int maxUses = FoodPrepUtils.getMaxUses(totalHunger);
        ItemStack stack = new ItemStack((ItemLike)SkiesItems.prepared_food);
        FoodPrepUtils.serialize(stack.m_41784_(), new PreparedFood(ingredients, FoodPrepUtils.getEffects(ingredients, maxUses), totalHunger, maxUses, maxUses, FoodPrepUtils.getSaturation(ingredients)));
        return stack;
    }

    public static boolean isValidIngredient(ItemStack stack) {
        Item item = stack.m_41720_();
        return item.m_41472_() || item == Items.f_42589_ || item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof FlowerBlock;
    }

    public static void causeInstability(PreparedFood preparedFood, LivingEntity entity) {
        int potionCount = 0;
        for (ItemStack item : preparedFood.getIngredients()) {
            if (item.m_41720_() != Items.f_42589_) continue;
            ++potionCount;
        }
        if (!entity.f_19853_.f_46443_ && potionCount >= 2) {
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            if ((double)entity.m_217043_().m_188501_() < 0.333) {
                effects.add(new MobEffectInstance(MobEffects.f_19614_, 180, entity.m_217043_().m_188499_() ? 1 : 0));
            } else {
                effects.add(new MobEffectInstance(entity.m_217043_().m_188499_() ? MobEffects.f_19604_ : MobEffects.f_19597_, 150, entity.m_217043_().m_188499_() ? 1 : 0));
            }
            if (entity.m_217043_().m_188499_() && potionCount >= 3) {
                if (entity.m_217043_().m_188499_()) {
                    effects.add(new MobEffectInstance(MobEffects.f_19602_, 1, entity.m_217043_().m_188499_() ? 1 : 0));
                } else {
                    effects.add(new MobEffectInstance(MobEffects.f_19615_, 200, entity.m_217043_().m_188499_() ? 1 : 0));
                }
            }
            effects.forEach(arg_0 -> ((LivingEntity)entity).m_7292_(arg_0));
        }
    }

    private static int getTotalHunger(List<ItemStack> ingredients) {
        double hunger = 0.0;
        ArrayList<Item> usedIngredients = new ArrayList<Item>();
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.m_41614_()) continue;
            hunger += (double)ingredient.getFoodProperties(null).m_38744_() + (!usedIngredients.contains(ingredient.m_41720_()) ? 2.5 : 0.0);
            usedIngredients.add(ingredient.m_41720_());
        }
        return (int)Math.max(1.0, hunger);
    }

    private static int getMaxUses(int totalHunger) {
        return Math.max(1, Math.round((float)totalHunger / 6.0f));
    }

    private static float getSaturation(List<ItemStack> ingredients) {
        float saturation = 0.0f;
        float count = 0.0f;
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.m_41614_()) continue;
            saturation += ingredient.getFoodProperties(null).m_38745_();
            count += 1.0f;
        }
        return Math.max(0.1f, count == 0.0f ? 0.1f : saturation / count);
    }

    private static List<MobEffectInstance> getEffects(List<ItemStack> ingredients, int maxUses) {
        LinkedHashMap<MobEffect, MobEffectInstance> effectMap = new LinkedHashMap<MobEffect, MobEffectInstance>();
        boolean brewberryFlag = false;
        for (ItemStack ingredient : ingredients) {
            if (ingredient.m_41720_() instanceof BlockItem && ((BlockItem)ingredient.m_41720_()).m_40614_() instanceof FlowerBlock) {
                FlowerBlock flower = (FlowerBlock)((BlockItem)ingredient.m_41720_()).m_40614_();
                MobEffect flowerEffect = flower.m_53521_();
                int flowerDuration = flower.m_53522_();
                FoodPrepUtils.addEffect(effectMap, new MobEffectInstance(flowerEffect, flowerDuration));
            }
            if (ingredient.m_41614_()) {
                for (MobEffectInstance effect : ingredient.getFoodProperties(null).m_38749_().stream().map(Pair::getFirst).collect(Collectors.toList())) {
                    FoodPrepUtils.addEffect(effectMap, effect);
                }
            }
            if (ingredient.m_41720_() == Items.f_42589_) {
                PotionUtils.m_43566_((CompoundTag)ingredient.m_41784_()).forEach(e -> FoodPrepUtils.addEffect(effectMap, e));
            }
            if (ingredient.m_41720_() != SkiesItems.brewberry) continue;
            brewberryFlag = true;
        }
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (Map.Entry entry : effectMap.entrySet()) {
            MobEffectInstance effect;
            effect = (MobEffectInstance)entry.getValue();
            if (effect.m_19544_() instanceof InstantenousMobEffect && effect.m_19544_() != MobEffects.f_19618_) continue;
            float time = (float)effect.m_19557_() / (float)maxUses;
            effects.add(new MobEffectInstance(effect.m_19544_(), Math.round(time *= brewberryFlag ? 1.4f : 1.1f), effect.m_19564_()));
        }
        return effects;
    }

    private static void addEffect(Map<MobEffect, MobEffectInstance> map, MobEffectInstance newEffect) {
        if (map.containsKey(newEffect.m_19544_())) {
            MobEffectInstance oldEffect = map.get(newEffect.m_19544_());
            if (newEffect.m_19564_() > oldEffect.m_19564_()) {
                int duration = (int)((float)newEffect.m_19557_() + (float)oldEffect.m_19557_() * ((float)(oldEffect.m_19564_() + 1) / (float)(newEffect.m_19564_() + 1)));
                map.put(newEffect.m_19544_(), new MobEffectInstance(newEffect.m_19544_(), duration, newEffect.m_19564_()));
            } else if (newEffect.m_19564_() < oldEffect.m_19564_()) {
                int duration = (int)((float)oldEffect.m_19557_() + (float)newEffect.m_19557_() * ((float)(newEffect.m_19564_() + 1) / (float)(oldEffect.m_19564_() + 1)));
                map.put(newEffect.m_19544_(), new MobEffectInstance(newEffect.m_19544_(), duration, oldEffect.m_19564_()));
            } else {
                int duration = oldEffect.m_19557_() + newEffect.m_19557_();
                map.put(newEffect.m_19544_(), new MobEffectInstance(newEffect.m_19544_(), duration, newEffect.m_19564_()));
            }
        } else {
            map.put(newEffect.m_19544_(), new MobEffectInstance(newEffect.m_19544_(), newEffect.m_19557_(), newEffect.m_19564_()));
        }
    }

    public static enum FoodColor {
        BEEF(8079412, new ItemLike[]{Items.f_42579_, Items.f_42580_, Items.f_42658_, Items.f_42659_, Items.f_42583_}),
        LETTUCE(6991719, new ItemLike[0]),
        CHEESE(15390090, new ItemLike[]{Items.f_42529_}),
        APPLE(15013926, new ItemLike[]{Items.f_42410_, Items.f_42575_, SkiesItems.cherry}),
        BREAD(10449954, new ItemLike[]{Items.f_42406_, Items.f_42572_}),
        PORK(11638883, new ItemLike[]{Items.f_42485_, Items.f_42486_, Items.f_42526_, Items.f_42530_, SkiesItems.monitor_tail, SkiesItems.cooked_monitor_tail}),
        SALMON(11227435, new ItemLike[]{Items.f_42527_, Items.f_42531_}),
        KELP(4472114, new ItemLike[]{Items.f_41910_}),
        CHICKEN(12811088, new ItemLike[]{Items.f_42581_, Items.f_42582_, Items.f_42697_, Items.f_42698_, Items.f_42699_, Items.f_42400_, Items.f_42718_}),
        CARROT(14712350, new ItemLike[]{Items.f_42619_, Items.f_42528_}),
        POTATO(12489280, new ItemLike[]{Items.f_42620_, Items.f_42674_, Items.f_42675_, Items.f_42687_, SkiesItems.solnut}),
        BEET(11353666, new ItemLike[]{Items.f_42732_, Items.f_42734_, SkiesItems.fiery_beans}),
        SWEET_BERRY(10032151, new ItemLike[]{Items.f_42780_, SkiesItems.brewberry}),
        WINTER_LEAF(7193708, new ItemLike[]{SkiesItems.winter_leaves, SkiesItems.municipal_monkfish, SkiesItems.cooked_municipal_monkfish}),
        CRYO_ROOT(7323079, new ItemLike[]{SkiesItems.cryo_root}),
        SCALEFRUIT(13919381, new ItemLike[]{Items.f_42591_, SkiesItems.scalefruit, SkiesItems.pink_brewberry}),
        PINE_FRUIT(4924430, new ItemLike[]{SkiesItems.pine_fruit}),
        CRESCENT_FRUIT(13453571, new ItemLike[]{SkiesItems.crescent_fruit}),
        CARABEEF(3490920, new ItemLike[]{SkiesItems.carabeef, SkiesItems.cooked_carabeef, SkiesItems.venison, SkiesItems.cooked_venison}),
        GRITTLE_FLATFISH(5453392, new ItemLike[]{SkiesItems.grittle_flatfish, SkiesItems.cooked_grittle_flatfish}),
        CHARSCALE(14978148, new ItemLike[]{SkiesItems.charscale_moki, SkiesItems.cooked_charscale_moki}),
        PEPPER(8657439, new ItemLike[]{SkiesItems.fiery_beans}),
        BACKBERRY(3945297, new ItemLike[]{SkiesItems.black_brewberry}),
        CHORUS(9792434, new ItemLike[]{Items.f_42730_}),
        GOLDEN(15577123, new ItemLike[]{Items.f_42436_, Items.f_42437_, Items.f_42677_, Items.f_42787_, Items.f_151079_, SkiesItems.horizofin_tunid, SkiesItems.cooked_horizofin_tunid});

        private static final HashMap<Item, FoodColor> COLORS;
        public final int color;
        public final Set<ItemLike> foods;

        private FoodColor(int color, ItemLike ... foods) {
            this.color = color;
            this.foods = Set.of(foods);
        }

        public static FoodColor get(Item item) {
            if (COLORS.containsKey(item)) {
                return COLORS.get(item);
            }
            return BEEF;
        }

        public static void setupColors() {
            COLORS.clear();
            block2: for (Item item : ForgeRegistries.ITEMS) {
                try {
                    if (!FoodPrepUtils.isValidIngredient(new ItemStack((ItemLike)item))) continue;
                    for (FoodColor color : FoodColor.values()) {
                        if (!color.foods.contains(item)) continue;
                        COLORS.put(item, color);
                        continue block2;
                    }
                    COLORS.put(item, FoodColor.values()[new Random(ForgeRegistries.ITEMS.getKey((Object)item).hashCode()).nextInt(FoodColor.values().length)]);
                }
                catch (Exception exception) {}
            }
        }

        static {
            COLORS = new HashMap();
        }
    }
}

