/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.entities.util.damage_source.SummonedDamageSource;
import com.legacy.blue_skies.registries.SkiesDamageTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SkiesDamageSources {
    public static SkiesDamageSources instance;
    private final DamageSource summon;
    private final Registry<DamageType> damageTypes;

    public SkiesDamageSources(RegistryAccess registryAccess) {
        this.damageTypes = registryAccess.m_175515_(Registries.f_268580_);
        this.summon = this.source((ResourceKey<DamageType>)SkiesDamageTypes.SUMMON.getKey());
    }

    private DamageSource source(ResourceKey<DamageType> type) {
        return new DamageSource((Holder)this.damageTypes.m_246971_(type));
    }

    private DamageSource source(ResourceKey<DamageType> type, @Nullable Entity directEntity) {
        return new DamageSource((Holder)this.damageTypes.m_246971_(type), directEntity);
    }

    private DamageSource source(ResourceKey<DamageType> type, @Nullable Entity directEntity, @Nullable Entity causer) {
        return new DamageSource((Holder)this.damageTypes.m_246971_(type), directEntity, causer);
    }

    public DamageSource crusherRoot(@Nullable Entity root, @Nullable Entity caster) {
        return this.source((ResourceKey<DamageType>)SkiesDamageTypes.CRUSHER_ROOT.getKey(), root, caster);
    }

    public DamageSource fallingSpike(@Nullable Entity spike, @Nullable Entity dropper) {
        return this.source((ResourceKey<DamageType>)(dropper != null ? SkiesDamageTypes.FALLING_SPIKE_INDIRECT.getKey() : SkiesDamageTypes.FALLING_SPIKE.getKey()), spike, dropper);
    }

    public DamageSource summon(@Nonnull Entity directEntity, @Nonnull LivingEntity summoner) {
        return new SummonedDamageSource((Holder<DamageType>)this.summon.m_269150_(), directEntity, (Entity)summoner);
    }

    public DamageSource ember(@Nullable Entity directEntity) {
        return this.source((ResourceKey<DamageType>)SkiesDamageTypes.EMBER.getKey(), directEntity);
    }

    public DamageSource bite(@Nullable Entity directEntity) {
        return this.source((ResourceKey<DamageType>)SkiesDamageTypes.BITE.getKey(), directEntity);
    }

    public DamageSource strangeLightning(@Nullable Entity bolt, @Nullable Entity caster) {
        return this.source((ResourceKey<DamageType>)SkiesDamageTypes.STRANGE_LIGHTNING.getKey(), bolt, caster);
    }

    public DamageSource fluctuantSphere(@Nullable Entity sphere, @Nullable Entity caster) {
        return this.source((ResourceKey<DamageType>)SkiesDamageTypes.FLUCTUANT_SPHERE.getKey(), sphere, caster);
    }

    public DamageSource venomSpit() {
        return this.venomSpit(null, null);
    }

    public DamageSource venomSpit(@Nullable Entity spit, @Nullable Entity shooter) {
        return this.source((ResourceKey<DamageType>)(shooter != null ? SkiesDamageTypes.VENOM_SPIT_INDIRECT.getKey() : SkiesDamageTypes.VENOM_SPIT.getKey()), spit, shooter);
    }

    public DamageSource slam(@Nullable Entity directEntity) {
        return this.source((ResourceKey<DamageType>)SkiesDamageTypes.SLAM.getKey(), null, directEntity);
    }
}

