/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.natural.BrewberryBushBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.world.everbright.gen.features.BluebrightTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.BrumbleFeature;
import com.legacy.blue_skies.world.everbright.gen.features.BrumbleVineFeature;
import com.legacy.blue_skies.world.everbright.gen.features.ChilledLilyFeature;
import com.legacy.blue_skies.world.everbright.gen.features.FallenLogFeature;
import com.legacy.blue_skies.world.everbright.gen.features.FrostbrightTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.OceanSpikeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.PatchySnowFeature;
import com.legacy.blue_skies.world.everbright.gen.features.SeaMossFeature;
import com.legacy.blue_skies.world.everbright.gen.features.SkyIceAndSnowFeature;
import com.legacy.blue_skies.world.everbright.gen.features.SmallPineTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.SnowcapMushroomFeature;
import com.legacy.blue_skies.world.everbright.gen.features.StarlitTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.cave.EverbrightCaveSpawnerFeature;
import com.legacy.blue_skies.world.everbright.gen.features.cave.GiantCaveIcicleFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.CrescentFruitTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.CrystalizedTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.DuskTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.GlimmerReedFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.LargeDuskTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.LunarTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.MapleTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.MoonlitWaterLilyFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.MoonstoneSpikeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.ReservoirTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.ShortMoonstoneSpikeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.CaveCrystalFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.CaveMagmaFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.CaveWallCrystalFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.EverdawnCaveSpawnerFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.LunarLavaSpireFeature;
import com.legacy.blue_skies.world.general_features.BushFeature;
import com.legacy.blue_skies.world.general_features.CherryTreeFeature;
import com.legacy.blue_skies.world.general_features.LargeRockFeature;
import com.legacy.blue_skies.world.general_features.SkyLakesFeature;
import com.legacy.blue_skies.world.general_features.SkyOreFeature;
import com.legacy.blue_skies.world.general_features.carver.SkyCanyonWorldCarver;
import com.legacy.blue_skies.world.general_features.carver.SkyCaveWorldCarver;
import com.legacy.blue_skies.world.general_features.carver.SkyNoiseCarver;
import com.legacy.blue_skies.world.general_features.cave.CaveGrassFeature;
import com.legacy.blue_skies.world.general_features.cave.CavePlantFeature;
import com.legacy.blue_skies.world.general_features.cave.CaveVineFeature;
import com.legacy.blue_skies.world.general_features.cave.CaveWallFeature;
import com.legacy.blue_skies.world.general_features.cave.SkyDripstoneFeature;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;

public class SkiesFeatures {
    public static final TreeFeature BLUEBRIGHT_TREE = new BluebrightTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, 5);
    public static final TreeFeature STARLIT_TREE = new StarlitTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_);
    public static final TreeFeature SNOWY_FROSTBRIGHT_TREE = new FrostbrightTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, true);
    public static final TreeFeature FROSTBRIGHT_TREE = new FrostbrightTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, false);
    public static final TreeFeature LUNAR_TREE = new LunarTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, 5);
    public static final TreeFeature DUSK_TREE = new DuskTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, 5);
    public static final TreeFeature VINED_LARGE_DUSK_TREE = new LargeDuskTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, true);
    public static final TreeFeature LARGE_DUSK_TREE = new LargeDuskTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, false);
    public static final TreeFeature MAPLE_TREE = new MapleTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, true);
    public static final TreeFeature MAPLE_TREE_UNNATURAL = new MapleTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, false);
    public static final TreeFeature CRESCENT_FRUIT_TREE = new CrescentFruitTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_);
    public static final TreeFeature CHERRY_TREE = new CherryTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, false);
    public static final TreeFeature NATURE_CHERRY_TREE = new CherryTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, true);
    public static final TreeFeature SMALL_BLUEBRIGHT_TREE = new SmallPineTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, 3, SkiesBlocks.bluebright_leaves.m_49966_(), SkiesBlocks.bluebright_log.m_49966_());
    public static final TreeFeature SMALL_STARLIT_TREE = new SmallPineTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, 5, SkiesBlocks.starlit_leaves.m_49966_(), SkiesBlocks.starlit_log.m_49966_());
    public static final TreeFeature SMALL_FROSTBRIGHT_TREE = new SmallPineTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, 6, SkiesBlocks.frostbright_leaves.m_49966_(), SkiesBlocks.frostbright_log.m_49966_());
    public static final TreeFeature RESERVOIR_TREE = new ReservoirTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, 7);
    public static final TreeFeature CRYSTALIZED_TREE = new CrystalizedTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, true);
    public static final TreeFeature CRYSTALIZED_TREE_UNNATURAL = new CrystalizedTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, false);
    public static final TreeFeature SNOWCAP_MUSHROOM = new SnowcapMushroomFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_);
    public static final Feature<NoneFeatureConfiguration> CHILLED_LILY = new ChilledLilyFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<MoonstoneSpikeFeature.Config> MOONSTONE_SPIKE = new MoonstoneSpikeFeature(MoonstoneSpikeFeature.Config.CODEC);
    public static final Feature<BlockStateConfiguration> EVERBRIGHT_LAKE = new SkyLakesFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_, false);
    public static final Feature<BlockStateConfiguration> EVERDAWN_LAKE = new SkyLakesFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_, true);
    public static final Feature<OreConfiguration> ORE = new SkyOreFeature((Codec<OreConfiguration>)OreConfiguration.f_67837_);
    public static final Feature<BushFeature.Config> BUSH = new BushFeature(BushFeature.Config.CODEC);
    public static final Feature<FallenLogFeature.Config> FALLEN_LOG = new FallenLogFeature(FallenLogFeature.Config.CODEC);
    public static final Feature<BlockStateConfiguration> LARGE_ROCK = new LargeRockFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_);
    public static final Feature<NoneFeatureConfiguration> SEA_MOSS = new SeaMossFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> GLIMMER_REEDS = new GlimmerReedFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> MOONLIT_WATER_LILIES = new MoonlitWaterLilyFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> OCEAN_SPIKE = new OceanSpikeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> BRUMBLE = new BrumbleFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> BRUMBLE_VINE = new BrumbleVineFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> SHORT_MOONSTONE_SPIKE = new ShortMoonstoneSpikeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> PATCHY_SNOW = new PatchySnowFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> ICE_AND_SNOW_NO_PATH = new SkyIceAndSnowFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> LUNAR_LAVA_SPIRE = new LunarLavaSpireFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<CaveVineFeature.Config> CAVE_VINE = new CaveVineFeature(CaveVineFeature.Config.CODEC);
    public static final Feature<CaveGrassFeature.Config> CAVE_GRASS = new CaveGrassFeature(CaveGrassFeature.Config.CODEC);
    public static final Feature<CaveWallFeature.Config> CAVE_WALL = new CaveWallFeature(CaveWallFeature.Config.CODEC);
    public static final Feature<SkyDripstoneFeature.Config> DRIPSTONE = new SkyDripstoneFeature(SkyDripstoneFeature.Config.CODEC);
    public static final Feature<NoneFeatureConfiguration> MOONSTONE_CAVE_CRYSTAL = new CaveCrystalFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<CavePlantFeature.Config> CAVE_PLANT = new CavePlantFeature(CavePlantFeature.Config.CODEC);
    public static final Feature<CaveWallCrystalFeature.Config> CAVE_WALL_CRYSTAL = new CaveWallCrystalFeature(CaveWallCrystalFeature.Config.CODEC);
    public static final Feature<NoneFeatureConfiguration> CAVE_MAGMA = new CaveMagmaFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> GIANT_CAVE_ICICLE = new GiantCaveIcicleFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> EVERBRIGHT_CAVE_SPAWNER = new EverbrightCaveSpawnerFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final Feature<NoneFeatureConfiguration> EVERDAWN_CAVE_SPAWNER = new EverdawnCaveSpawnerFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static RegisterEvent registerEvent;

    public static void init(RegisterEvent event) {
        registerEvent = event;
        SkiesFeatures.register("bluebright_tree", BLUEBRIGHT_TREE);
        SkiesFeatures.register("starlit_tree", STARLIT_TREE);
        SkiesFeatures.register("snowy_frostbright_tree", SNOWY_FROSTBRIGHT_TREE);
        SkiesFeatures.register("frostbright_tree", FROSTBRIGHT_TREE);
        SkiesFeatures.register("lunar_tree", LUNAR_TREE);
        SkiesFeatures.register("dusk_tree", DUSK_TREE);
        SkiesFeatures.register("vined_large_dusk_tree", VINED_LARGE_DUSK_TREE);
        SkiesFeatures.register("large_dusk_tree", LARGE_DUSK_TREE);
        SkiesFeatures.register("maple_tree", MAPLE_TREE);
        SkiesFeatures.register("maple_tree_unnatural", MAPLE_TREE_UNNATURAL);
        SkiesFeatures.register("crescent_fruit_tree", CRESCENT_FRUIT_TREE);
        SkiesFeatures.register("cherry_tree", CHERRY_TREE);
        SkiesFeatures.register("nature_cherry_tree", NATURE_CHERRY_TREE);
        SkiesFeatures.register("small_bluebright_tree", SMALL_BLUEBRIGHT_TREE);
        SkiesFeatures.register("small_starlit_tree", SMALL_STARLIT_TREE);
        SkiesFeatures.register("small_frostbright_tree", SMALL_FROSTBRIGHT_TREE);
        SkiesFeatures.register("reservoir_tree", RESERVOIR_TREE);
        SkiesFeatures.register("crystalized_tree", CRYSTALIZED_TREE);
        SkiesFeatures.register("crystalized_tree_unnatural", CRYSTALIZED_TREE_UNNATURAL);
        SkiesFeatures.register("snowcap_mushroom", SNOWCAP_MUSHROOM);
        SkiesFeatures.register("chilled_lily", CHILLED_LILY);
        SkiesFeatures.register("moonstone_spike", MOONSTONE_SPIKE);
        SkiesFeatures.register("short_moonstone_spike", SHORT_MOONSTONE_SPIKE);
        SkiesFeatures.register("everbright_lake", EVERBRIGHT_LAKE);
        SkiesFeatures.register("everdawn_lake", EVERDAWN_LAKE);
        SkiesFeatures.register("ore", ORE);
        SkiesFeatures.register("bush", BUSH);
        SkiesFeatures.register("fallen_log", FALLEN_LOG);
        SkiesFeatures.register("large_rock", LARGE_ROCK);
        SkiesFeatures.register("glimmer_reeds", GLIMMER_REEDS);
        SkiesFeatures.register("moonlit_water_lilies", MOONLIT_WATER_LILIES);
        SkiesFeatures.register("sea_moss", SEA_MOSS);
        SkiesFeatures.register("ocean_spike", OCEAN_SPIKE);
        SkiesFeatures.register("brumble", BRUMBLE);
        SkiesFeatures.register("brumble_vine", BRUMBLE_VINE);
        SkiesFeatures.register("patchy_snow", PATCHY_SNOW);
        SkiesFeatures.register("ice_and_snow_no_path", ICE_AND_SNOW_NO_PATH);
        SkiesFeatures.register("lunar_lava_spire", LUNAR_LAVA_SPIRE);
        SkiesFeatures.register("cave_vine", CAVE_VINE);
        SkiesFeatures.register("cave_grass", CAVE_GRASS);
        SkiesFeatures.register("cave_wall", CAVE_WALL);
        SkiesFeatures.register("dripstone", DRIPSTONE);
        SkiesFeatures.register("moonstone_cave_crystal", MOONSTONE_CAVE_CRYSTAL);
        SkiesFeatures.register("cave_plant", CAVE_PLANT);
        SkiesFeatures.register("cave_wall_crystal", CAVE_WALL_CRYSTAL);
        SkiesFeatures.register("cave_magma", CAVE_MAGMA);
        SkiesFeatures.register("giant_cave_icicle", GIANT_CAVE_ICICLE);
        SkiesFeatures.register("everbright_cave_spawner", EVERBRIGHT_CAVE_SPAWNER);
        SkiesFeatures.register("everdawn_cave_spawner", EVERDAWN_CAVE_SPAWNER);
    }

    private static void register(String key, Feature<?> feature) {
        registerEvent.register(Registries.f_256833_, BlueSkies.locate(key), () -> feature);
    }

    public static class Carvers {
        public static final Set<Block> CARVABLE_BLOCKS = Set.of(SkiesBlocks.turquoise_stone, SkiesBlocks.lunar_stone, SkiesBlocks.turquoise_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.lunar_grass_block, SkiesBlocks.crystal_sand, SkiesBlocks.crystal_sandstone, SkiesBlocks.midnight_sand, SkiesBlocks.midnight_sandstone, Blocks.f_49994_, Blocks.f_50125_, Blocks.f_50069_, Blocks.f_50354_, Blocks.f_50126_);
        public static final Set<Block> CARVABLE_SEA_BLOCKS = (Set)Streams.concat((Stream[])new Stream[]{CARVABLE_BLOCKS.stream(), ImmutableSet.of((Object)Blocks.f_49990_, (Object)Blocks.f_49991_, (Object)Blocks.f_50080_, (Object)Blocks.f_50016_, (Object)Blocks.f_50627_).stream()}).collect(ImmutableSet.toImmutableSet());
        public static final WorldCarver<CarverConfiguration> SKY_NOISE_CARVER = new SkyNoiseCarver((Codec<CarverConfiguration>)CarverConfiguration.f_159087_.codec(), 90);
        public static final WorldCarver<CarverConfiguration> EVERBRIGHT_NOISE_CARVER = new SkyNoiseCarver(CarverConfiguration.f_159087_.codec(), 90){

            @Override
            protected BlockState getStateForPlace(RandomSource rand, int y) {
                if (y <= 10) {
                    return y == 10 && rand.m_188501_() < 0.4f ? Blocks.f_50354_.m_49966_() : Blocks.f_50126_.m_49966_();
                }
                return f_64980_;
            }
        };
        public static final WorldCarver<CaveCarverConfiguration> EVERBRIGHT_CAVE_CARVER = new SkyCaveWorldCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.f_159154_, true);
        public static final WorldCarver<CanyonCarverConfiguration> EVERBRIGHT_CANYON_CARVER = new SkyCanyonWorldCarver((Codec<CanyonCarverConfiguration>)CanyonCarverConfiguration.f_158966_, true);
        public static final WorldCarver<CaveCarverConfiguration> SKY_CAVE_CARVER = new SkyCaveWorldCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.f_159154_, false);
        public static final WorldCarver<CanyonCarverConfiguration> SKY_CANYON_CARVER = new SkyCanyonWorldCarver((Codec<CanyonCarverConfiguration>)CanyonCarverConfiguration.f_158966_, false);

        public static void init(RegisterEvent event) {
            Carvers.register(event, "everbright_noise_carver", EVERBRIGHT_NOISE_CARVER);
            Carvers.register(event, "sky_noise_carver", SKY_NOISE_CARVER);
            Carvers.register(event, "everbright_cave_carver", EVERBRIGHT_CAVE_CARVER);
            Carvers.register(event, "everbright_canyon_carver", EVERBRIGHT_CANYON_CARVER);
            Carvers.register(event, "sky_cave_carver", SKY_CAVE_CARVER);
            Carvers.register(event, "sky_canyon_carver", SKY_CANYON_CARVER);
        }

        private static void register(RegisterEvent event, String name, WorldCarver<?> entry) {
            event.register(Registries.f_256812_, BlueSkies.locate(name), () -> entry);
        }
    }

    public static class Configs {
        public static final List<BlockState> EVERBRIGHT_CHERRY_GRASS_STATES = new ArrayList<BlockState>(SkiesPoiTypes.getAllStates(new Block[]{SkiesBlocks.turquoise_cherry_grass_block}));
        public static final RandomPatchConfiguration TALL_TURQUOISE_GRASS_CONFIG = Configs.filteredPatch("tall_turquoise_grass", SkiesBlocks.tall_turquoise_grass.m_49966_(), 16, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration SNOWCAP_CONFIG = Configs.filteredPatch("snowcap", SkiesBlocks.snowcap_mushroom.m_49966_(), 64, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration CAMELLIA_CONFIG = Configs.filteredPatch("camellia", SkiesBlocks.camellia.m_49966_(), 64, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration SNOWBLOOM_CONFIG = Configs.filteredPatch("snowbloom", SkiesBlocks.snowbloom.m_49966_(), 64, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration BREWBERRY_CONFIG = Configs.filteredPatch("brewberry", (BlockState)SkiesBlocks.brewberry_bush.m_49966_().m_61124_((Property)BrewberryBushBlock.MATURE, (Comparable)Boolean.valueOf(true)), 64, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration BRITTLEBUSH_CONFIG = Configs.filteredPatch("brittlebush", SkiesBlocks.brittlebush.m_49966_(), 64, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration POLAR_POSY_CONFIG = Configs.filteredPatch("polar_posy", SkiesBlocks.polar_posy.m_49966_(), 64, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration CHILLWEED_CONFIG = Configs.filteredPatch("chillweed", SkiesBlocks.chillweed.m_49966_(), 64, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration SEA_MOSS_CONFIG = Configs.simplePatch("sea_moss", SkiesBlocks.sea_moss.m_49966_(), 64);
        public static final RandomPatchConfiguration SNOWCAP_PINHEAD_CONFIG = Configs.filteredPatch("snowcap_pinhead", SkiesBlocks.snowcap_pinhead.m_49966_(), 64, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration MIDDAY_BAYHOP_CONFIG = Configs.filteredPatch("midday_bayhop", SkiesBlocks.midday_bayhop.m_49966_(), 64, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration TALL_LUNAR_GRASS_CONFIG = Configs.simplePatch("tall_lunar_grass", SkiesBlocks.tall_lunar_grass.m_49966_(), 16);
        public static final RandomPatchConfiguration MOONLIT_BLOOM_CONFIG = Configs.simplePatch("moonlit_bloom", SkiesBlocks.moonlit_bloom.m_49966_(), 64);
        public static final RandomPatchConfiguration BANEFUL_MUSHROOM_CONFIG = Configs.simplePatch("baneful_mushroom", SkiesBlocks.baneful_mushroom.m_49966_(), 16);
        public static final RandomPatchConfiguration BLAZE_BUD_CONFIG = Configs.simplePatch("blaze_bud", SkiesBlocks.blaze_bud.m_49966_(), 64);
        public static final RandomPatchConfiguration CRYSTAL_FLOWER_CONFIG = Configs.simplePatch("crystal_flower", SkiesBlocks.crystal_flower.m_49966_(), 64);
        public static final RandomPatchConfiguration FLARE_FLORET_CONFIG = Configs.simplePatch("flare_floret", SkiesBlocks.flare_floret.m_49966_(), 64);
        public static final RandomPatchConfiguration MUCKWEED_CONFIG = Configs.simplePatch("muckweed", SkiesBlocks.muckweed.m_49966_(), 64);
        public static final RandomPatchConfiguration LUCENTROOT_CONFIG = Configs.simplePatch("lucentroot", SkiesBlocks.lucentroot.m_49966_(), 16);
        public static final RandomPatchConfiguration NIGHTCRESS_CONFIG = Configs.simplePatch("nightcress", SkiesBlocks.nightcress.m_49966_(), 64);
        public static final RandomPatchConfiguration LUNAR_GRASS_MUCKWEED_MIX_CONFIG = Configs.weightedPatch("lunar_grass_muckweed_mix", (SimpleWeightedRandomList.Builder<BlockState>)Configs.weighted().m_146271_((Object)SkiesBlocks.lunar_grass.m_49966_(), 3).m_146271_((Object)SkiesBlocks.muckweed.m_49966_(), 1), 32);
        public static final RandomPatchConfiguration FlARE_BLAZE_LUCENTROOT_MIX_CONFIG = Configs.weightedPatch("flare_blaze_lucentroot_mix", (SimpleWeightedRandomList.Builder<BlockState>)Configs.weighted().m_146271_((Object)SkiesBlocks.flare_floret.m_49966_(), 2).m_146271_((Object)SkiesBlocks.blaze_bud.m_49966_(), 2).m_146271_((Object)SkiesBlocks.lucentroot.m_49966_(), 1), 64);
        public static final RandomPatchConfiguration MOONLIT_BLOOM_NIGHTCRESS_LUCENTROOT_MIX_CONFIG = Configs.weightedPatch("moonlit_bloom_nightcress_lucentroot_mix", (SimpleWeightedRandomList.Builder<BlockState>)Configs.weighted().m_146271_((Object)SkiesBlocks.moonlit_bloom.m_49966_(), 2).m_146271_((Object)SkiesBlocks.nightcress.m_49966_(), 2).m_146271_((Object)SkiesBlocks.lucentroot.m_49966_(), 1), 64);
        public static final RandomPatchConfiguration BRISK_MEADOW_FLOWER_CONFIG = Configs.weightedPatch("brisk_meadow_flower", (SimpleWeightedRandomList.Builder<BlockState>)Configs.weighted().m_146271_((Object)SkiesBlocks.briskbloom.m_49966_(), 5).m_146271_((Object)SkiesBlocks.chillweed.m_49966_(), 1).m_146271_((Object)SkiesBlocks.brittlebush.m_49966_(), 1), 80, c -> PlacementUtils.m_206498_((Feature)((Feature)c.getLeft()), (FeatureConfiguration)((FeatureConfiguration)c.getRight()), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50016_}), (BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)BlockPos.f_121853_.m_7495_(), (Block[])new Block[]{SkiesBlocks.turquoise_cherry_grass_block})))));
        public static final RandomPatchConfiguration SHADED_WOODLANDS_FLOWER_CONFIG = Configs.weightedPatch("shaded_woodlands_flower", (SimpleWeightedRandomList.Builder<BlockState>)Configs.weighted().m_146271_((Object)SkiesBlocks.moonlit_bloom.m_49966_(), 2).m_146271_((Object)SkiesBlocks.nightcress.m_49966_(), 2).m_146271_((Object)SkiesBlocks.lucentroot.m_49966_(), 1), 6);
        public static final RandomPatchConfiguration TURQUOISE_GRASS = Configs.filteredPatch("turquoise_grass", SkiesBlocks.turquoise_grass.m_49966_(), 32, SkiesBlocks.turquoise_cherry_grass_block);
        public static final RandomPatchConfiguration LUNAR_GRASS = Configs.simplePatch("lunar_grass", SkiesBlocks.lunar_grass.m_49966_(), 32);
        public static final RandomPatchConfiguration CRYSTALLIZED_GRASS = Configs.simplePatch("crystallized_grass", SkiesBlocks.crystallized_grass.m_49966_(), 32);
        public static final RandomPatchConfiguration LIGHT_CRYSTALLIZED_GRASS = Configs.simplePatch("light_crystallized_grass", SkiesBlocks.crystallized_grass.m_49966_(), 16);
        public static final RuleTest TURQUOISE_RULE_TEST = new BlockMatchTest(SkiesBlocks.turquoise_stone);
        public static final RuleTest LUNAR_RULE_TEST = new BlockMatchTest(SkiesBlocks.lunar_stone);

        public static RandomPatchConfiguration simplePatch(String name, BlockState state, int tries) {
            return Configs.simplePatch(name, state, tries, p -> PlacementUtils.m_206495_((Feature)((Feature)p.getLeft()), (FeatureConfiguration)((FeatureConfiguration)p.getRight())));
        }

        public static RandomPatchConfiguration filteredPatch(String name, BlockState state, int tries, Block notBlock) {
            return Configs.simplePatch(name, state, tries, p -> PlacementUtils.m_206498_((Feature)((Feature)p.getLeft()), (FeatureConfiguration)((FeatureConfiguration)p.getRight()), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50016_}), (BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)BlockPos.f_121853_.m_7495_(), (Block[])new Block[]{notBlock})))));
        }

        public static <FC extends FeatureConfiguration, F extends Feature<FC>> RandomPatchConfiguration simplePatch(String name, BlockState state, int tries, Function<Pair<F, FC>, Holder<PlacedFeature>> cons) {
            return Configs.randomPatchConfig(name, tries, cons.apply(Pair.of((Object)Feature.f_65741_, (Object)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)))));
        }

        public static RandomPatchConfiguration weightedPatch(String name, SimpleWeightedRandomList.Builder<BlockState> builder, int tries) {
            return Configs.weightedPatch(name, builder, tries, p -> PlacementUtils.m_206495_((Feature)((Feature)p.getLeft()), (FeatureConfiguration)((FeatureConfiguration)p.getRight())));
        }

        public static <FC extends FeatureConfiguration, F extends Feature<FC>> RandomPatchConfiguration weightedPatch(String name, SimpleWeightedRandomList.Builder<BlockState> builder, int tries, Function<Pair<F, FC>, Holder<PlacedFeature>> cons) {
            return Configs.randomPatchConfig(name, tries, cons.apply(Pair.of((Object)Feature.f_65741_, (Object)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder)))));
        }

        public static <FC extends FeatureConfiguration, F extends Feature<FC>> RandomPatchConfiguration randomPatchConfig(String name, int tries, Holder<PlacedFeature> placedHolder) {
            return FeatureUtils.m_206470_((int)tries, placedHolder);
        }

        public static SimpleWeightedRandomList.Builder<BlockState> weighted() {
            return SimpleWeightedRandomList.m_146263_();
        }

        public static List<OreConfiguration.TargetBlockState> oreConfig(BlockState bright, BlockState dawn) {
            return List.of(OreConfiguration.m_161021_((RuleTest)TURQUOISE_RULE_TEST, (BlockState)bright), OreConfiguration.m_161021_((RuleTest)LUNAR_RULE_TEST, (BlockState)dawn));
        }
    }
}

