/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features;

import com.legacy.blue_skies.data.objects.tags.SkiesStructureTags;
import com.legacy.blue_skies.world.general_features.IStructureRestricted;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;

public abstract class AbstractSkyTreeFeature
extends TreeFeature
implements IStructureRestricted {
    private static final Map<Direction, BooleanProperty> VINE_PROPERTIES = (Map)VineBlock.f_57838_.entrySet().stream().filter(e -> e.getKey() != Direction.UP).collect(Util.m_137448_());
    protected final boolean natural;

    public AbstractSkyTreeFeature(Codec<TreeConfiguration> config, boolean natural) {
        super(config);
        this.natural = natural;
    }

    @Internal
    public final boolean m_225257_(WorldGenLevel level, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves, FoliagePlacer.FoliageSetter whatIsThis, TreeConfiguration config) {
        BlockPos groundPos = pos.m_7495_();
        if (this.isValidGround(level, level.m_8055_(groundPos), groundPos) && this.shouldGenerate(level, pos)) {
            return this.place(level, rand, pos, changedLogs, changedLeaves);
        }
        return false;
    }

    public abstract boolean place(WorldGenLevel var1, RandomSource var2, BlockPos var3, BiConsumer<BlockPos, BlockState> var4, BiConsumer<BlockPos, BlockState> var5);

    @Override
    public boolean pieceSpecific() {
        return true;
    }

    @Override
    public TagKey<Structure> disallowedStructures() {
        return SkiesStructureTags.TREE_DISALLOWED;
    }

    public boolean isValidGround(WorldGenLevel level, BlockState state, BlockPos pos) {
        if (this.natural) {
            return AbstractSkyTreeFeature.m_159759_((BlockState)state);
        }
        return AbstractSkyTreeFeature.m_159759_((BlockState)state) || state.m_60734_() instanceof FarmBlock;
    }

    protected boolean setBlockIfOk(@Nullable BiConsumer<BlockPos, BlockState> changedBlocks, WorldGenLevel level, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof RotatedPillarBlock) {
            if (this.isReplaceableByLogs(level, pos)) {
                this.setBlock(changedBlocks, level, pos, state);
                return true;
            }
            return false;
        }
        if (block instanceof LeavesBlock) {
            if (this.isReplaceableByLeaves(level, pos)) {
                this.setBlock(changedBlocks, level, pos, state);
                return true;
            }
            return false;
        }
        if (level.m_46859_(pos) && state.m_60710_((LevelReader)level, pos)) {
            BlockState lower;
            this.setBlock(changedBlocks, level, pos, state);
            if (block instanceof SnowLayerBlock && (lower = level.m_8055_(pos.m_7495_())).m_61138_((Property)BlockStateProperties.f_61451_)) {
                level.m_7731_(pos.m_7495_(), (BlockState)lower.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)), 2);
            }
            return true;
        }
        return false;
    }

    protected void setBlock(@Nullable BiConsumer<BlockPos, BlockState> changedBlocks, WorldGenLevel level, BlockPos pos, BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        TreeFeature.m_67256_((LevelWriter)level, (BlockPos)pos, (BlockState)state);
        if (changedBlocks != null) {
            changedBlocks.accept(pos, state);
        }
    }

    public boolean isReplaceableByLeaves(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60767_().m_76336_() || state.m_204336_(BlockTags.f_13035_);
    }

    public boolean isReplaceableByLogs(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60767_().m_76336_() || this.isLeavesOrLog(state) || state.m_60767_() == Material.f_76300_;
    }

    public boolean isLeavesOrLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_);
    }

    public static void placeVines(WorldGenLevel level, BlockPos trunkStart, RandomSource rand, int areaWidth, int areaHeight, int minVineLength, int maxVineLength, float placementChance, BlockState vine, Set<Block> allowedAttachmentBlocks) {
        int halfWidth = Math.max((areaWidth - 1) / 2, 1);
        for (int x = -halfWidth; x <= halfWidth; ++x) {
            for (int z = -halfWidth; z <= halfWidth; ++z) {
                for (int y = 2; y <= areaHeight; ++y) {
                    BlockPos offsetPos = trunkStart.m_7918_(x, y, z);
                    if (!level.m_46859_(offsetPos) || !(rand.m_188501_() < placementChance)) continue;
                    for (Map.Entry<Direction, BooleanProperty> prop : VINE_PROPERTIES.entrySet()) {
                        BlockState vineBlock = (BlockState)vine.m_61124_((Property)prop.getValue(), (Comparable)Boolean.valueOf(true));
                        if (!vineBlock.m_60710_((LevelReader)level, offsetPos) || !allowedAttachmentBlocks.isEmpty() && !allowedAttachmentBlocks.contains(level.m_8055_(offsetPos.m_121945_(prop.getKey())).m_60734_())) continue;
                        int maxLength = rand.m_188503_(maxVineLength - minVineLength) + minVineLength;
                        for (int vineLength = 0; vineLength <= maxLength && level.m_46859_(offsetPos.m_6625_(vineLength)) && vineBlock.m_60710_((LevelReader)level, offsetPos); ++vineLength) {
                            level.m_7731_(offsetPos.m_6625_(vineLength), vineBlock, 6);
                        }
                    }
                }
            }
        }
    }

    public boolean isAreaOk(WorldGenLevel level, BlockPos pos, int trunkHeight, int trunkWidth, int leafStartHeight, int leafWidth) {
        if (pos.m_123342_() >= 1 && pos.m_123342_() + trunkHeight + 1 < level.m_141928_()) {
            if (trunkWidth == 1) {
                for (y = 0; y <= 1 + trunkHeight && pos.m_123342_() + y >= 1 && pos.m_123342_() + y < level.m_141928_(); ++y) {
                    if (this.isReplaceableByLogs(level, pos.m_6630_(y)) || this.isLeavesOrLog(level.m_8055_(pos.m_6630_(y)))) continue;
                    return false;
                }
            } else {
                for (y = 0; y <= 1 + trunkHeight && pos.m_123342_() + y >= 1 && pos.m_123342_() + y < level.m_141928_(); ++y) {
                    for (int x = 0; x < trunkWidth; ++x) {
                        for (int z = 0; z < trunkWidth; ++z) {
                            if (this.isReplaceableByLogs(level, pos.m_7918_(x, y, z)) || this.isLeavesOrLog(level.m_8055_(pos.m_7918_(x, y, z)))) continue;
                            return false;
                        }
                    }
                }
            }
            int width = Math.max((leafWidth - 1) / 2, 1);
            for (int y = leafStartHeight; y <= trunkHeight + 2 && pos.m_123342_() + y >= 0 && pos.m_123342_() + y < level.m_141928_(); ++y) {
                for (int x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        if (this.isReplaceableByLeaves(level, pos.m_7918_(x, y, z)) || this.isLeavesOrLog(level.m_8055_(pos.m_7918_(x, y, z)))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }
}

