/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread_common_fabric.util;

import com.natamus.collective_common_fabric.functions.BlockFunctions;
import com.natamus.collective_common_fabric.functions.CompareBlockFunctions;
import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.collective_common_fabric.functions.DimensionFunctions;
import com.natamus.collective_common_fabric.functions.HashMapFunctions;
import com.natamus.collective_common_fabric.functions.NumberFunctions;
import com.natamus.collective_common_fabric.functions.StringFunctions;
import com.natamus.collective_common_fabric.functions.WorldFunctions;
import com.natamus.collective_common_fabric.objects.RandomCollection;
import com.natamus.netherportalspread_common_fabric.config.ConfigHandler;
import com.natamus.netherportalspread_common_fabric.data.Variables;
import com.natamus.netherportalspread_common_fabric.util.DefaultConfigs;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7924;

public class Util {
    public static HashMap<class_1937, CopyOnWriteArrayList<class_2338>> portals = new HashMap();
    public static HashMap<class_1937, HashMap<class_2338, Boolean>> preventedportals = new HashMap();
    private static final HashMap<class_2248, HashMap<class_2248, Double>> convertinto = new HashMap();
    private static final List<class_2248> convertblocks = new ArrayList<class_2248>();
    private static final List<class_2248> convertedblocks = new ArrayList<class_2248>();
    private static class_2248 preventSpreadBlock = null;

    public static void attemptSpreadBlockProcess(class_1937 level) {
        if (!Variables.processedSpreadBlockLoad) {
            try {
                Util.loadSpreadBlocks(level);
                Variables.processedSpreadBlockLoad = true;
            }
            catch (IOException ex) {
                System.out.println("[Nether Portal Spread] Something went wrong loading the nether spread block config.");
            }
        }
    }

    public static void loadSpreadBlocks(class_1937 level) throws IOException {
        class_2378 blockRegistry = level.method_30349().method_30530(class_7924.field_41254);
        String dirpath = DataFunctions.getConfigDirectory() + File.separator + "netherportalspread";
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "spreadsettings.txt");
        if (dir.isDirectory() && file.isFile()) {
            String spreadsettings = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "spreadsettings.txt", new String[0])));
            spreadsettings = spreadsettings.replace("\n", "").replace("\r", "").replace(" ", "");
            for (String line : spreadsettings.split(",")) {
                if (line.length() < 4) {
                    System.out.println("The Nether Portal Spread spread settings contains an empty line. Ignoring it.");
                    continue;
                }
                String[] linespl = line.split(";");
                if (linespl.length != 2) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors. Ignoring it.");
                    continue;
                }
                Object fromblockstr = linespl[0];
                if (!((String)fromblockstr).contains(":")) {
                    fromblockstr = "minecraft:" + (String)fromblockstr;
                }
                class_2960 frl = new class_2960((String)fromblockstr);
                if (!blockRegistry.method_10235().contains(frl)) {
                    System.out.println("[Nether Portal Spread] Unable to find from-block '" + (String)fromblockstr + "' in the Forge block registry. Ignoring it.");
                    continue;
                }
                class_2248 fromblock = (class_2248)blockRegistry.method_10223(frl);
                String toblocks = linespl[1].replace("[", "").replace("]", "");
                double totalweight = 0.0;
                HashMap<class_2248, Double> tempmap = new HashMap<class_2248, Double>();
                for (String tb : toblocks.split("\\+")) {
                    String[] tbspl = tb.split(">");
                    if (tbspl.length < 2) continue;
                    Object toblockstr = tbspl[0];
                    if (!((String)toblockstr).contains(":")) {
                        toblockstr = "minecraft:" + (String)toblockstr;
                    }
                    double weight = 1.0;
                    try {
                        weight = Double.parseDouble(tbspl[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    totalweight += weight;
                    class_2960 trl = new class_2960((String)toblockstr);
                    if (blockRegistry.method_10235().contains(trl)) {
                        tempmap.put((class_2248)blockRegistry.method_10223(trl), weight);
                        continue;
                    }
                    System.out.println("[Nether Portal Spread] Unable to find to-block '" + (String)toblockstr + "' in the Forge block registry. Ignoring it.");
                }
                if (tempmap.size() == 0 || totalweight == 0.0) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors, no convert blocks were found. Ignoring it.");
                    continue;
                }
                for (class_2248 key : tempmap.keySet()) {
                    Double weightvalue = (Double)tempmap.get(key);
                    tempmap.put(key, 1.0 / totalweight * weightvalue);
                }
                convertinto.put(fromblock, tempmap);
            }
            for (class_2248 b0 : convertinto.keySet()) {
                convertblocks.add(b0);
                convertedblocks.addAll(convertinto.get(b0).keySet());
            }
        } else {
            dir.mkdirs();
            List<String> defaultconfig = DefaultConfigs.getDefaultConfigForVersion("[1.19.4]");
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "spreadsettings.txt", StandardCharsets.UTF_8);
            for (String line : defaultconfig) {
                writer.println(line);
            }
            writer.close();
            Util.loadSpreadBlocks(level);
        }
        if (preventSpreadBlock == null) {
            String psbstr = ConfigHandler.preventSpreadBlockString.strip().replaceAll("[^a-z0-9_.-:]", "");
            try {
                class_2960 psbrl = new class_2960(psbstr);
                if (blockRegistry.method_10235().contains(psbrl)) {
                    preventSpreadBlock = (class_2248)blockRegistry.method_10223(psbrl);
                    return;
                }
            }
            catch (class_151 class_1512) {
                // empty catch block
            }
            System.out.println("[Nether Portal Spread] Unable to get a prevent-spread-block from the string '" + psbstr + "'. Using the default coal block instead.");
            preventSpreadBlock = class_2246.field_10381;
        }
    }

    public static void loadPortalsFromWorld(class_1937 level) {
        String portalfolder = WorldFunctions.getWorldPath((class_3218)((class_3218)level)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals";
        String specificportalfolder = portalfolder + File.separator + DimensionFunctions.getSimpleDimensionString((class_1937)level);
        if (specificportalfolder.endsWith("overworld")) {
            File[] files;
            File sourceDir = new File(portalfolder);
            File destinationDir = new File(specificportalfolder);
            destinationDir.mkdirs();
            for (File f : files = sourceDir.listFiles(pathname -> pathname.getName().endsWith(".portal"))) {
                Path sourcePath = Paths.get(sourceDir.getAbsolutePath() + File.separator + f.getName(), new String[0]);
                Path destinationPath = Paths.get(destinationDir.getAbsolutePath() + File.separator + f.getName(), new String[0]);
                try {
                    Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        File dir = new File(specificportalfolder);
        dir.mkdirs();
        File[] listOfFiles = dir.listFiles();
        if (listOfFiles == null) {
            return;
        }
        int r = ConfigHandler.portalSpreadRadius;
        int psamount = ConfigHandler.preventSpreadBlockAmountNeeded;
        for (File listOfFile : listOfFiles) {
            String[] cs;
            String filename = listOfFile.getName();
            if (!filename.endsWith(".portal") || (cs = filename.replace(".portal", "").split("_")).length != 3 || !NumberFunctions.isNumeric((String)cs[0]) || !NumberFunctions.isNumeric((String)cs[1]) || !NumberFunctions.isNumeric((String)cs[2])) continue;
            int x = Integer.parseInt(cs[0]);
            int y = Integer.parseInt(cs[1]);
            int z = Integer.parseInt(cs[2]);
            class_2338 portal = new class_2338(x, y, z);
            ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())).add(portal);
            if (!ConfigHandler.preventSpreadWithBlock) continue;
            int coalcount = 0;
            Iterator it = class_2338.method_17962((int)(portal.method_10263() - r), (int)(portal.method_10264() - r), (int)(portal.method_10260() - r), (int)(portal.method_10263() + r), (int)(portal.method_10264() + r), (int)(portal.method_10260() + r)).iterator();
            while (it.hasNext()) {
                try {
                    class_2338 np = (class_2338)it.next();
                    if (!level.method_8320(np).method_26204().equals(preventSpreadBlock) || ++coalcount < psamount) continue;
                    break;
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            ((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).put(portal, coalcount >= psamount);
        }
    }

    public static void savePortalToWorld(class_1937 level, class_2338 portal) {
        String portalfolder = WorldFunctions.getWorldPath((class_3218)((class_3218)level)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals" + File.separator + DimensionFunctions.getSimpleDimensionString((class_1937)level);
        File dir = new File(portalfolder);
        dir.mkdirs();
        String filename = portal.method_10263() + "_" + portal.method_10264() + "_" + portal.method_10260() + ".portal";
        try {
            PrintWriter writer = new PrintWriter(portalfolder + File.separator + filename, StandardCharsets.UTF_8);
            writer.close();
        }
        catch (Exception e) {
            System.out.println("[Error] Nether Portal Spread: Something went wrong while saving a portal location.");
        }
    }

    private static Boolean portalExists(class_1937 level, class_2338 pos) {
        for (class_2338 portalpos : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())) {
            double distance = pos.method_10262(new class_2382(portalpos.method_10263(), portalpos.method_10264(), portalpos.method_10260()));
            if (!(distance < 10.0)) continue;
            return true;
        }
        return false;
    }

    public static void validatePortalAndAdd(class_1937 level, class_2338 p) {
        int netherblockcount;
        class_2338 rawportal = null;
        int r = 3;
        Iterator it = class_2338.method_17962((int)(p.method_10263() - r), (int)(p.method_10264() - r), (int)(p.method_10260() - r), (int)(p.method_10263() + r), (int)(p.method_10264() + r), (int)(p.method_10260() + r)).iterator();
        while (it.hasNext()) {
            class_2338 nextpos = (class_2338)it.next();
            class_2248 block = level.method_8320(nextpos).method_26204();
            if (!CompareBlockFunctions.isPortalBlock((class_2248)block)) continue;
            rawportal = nextpos.method_10062();
            break;
        }
        if (rawportal == null) {
            return;
        }
        while (CompareBlockFunctions.isPortalBlock((class_2248)level.method_8320(rawportal.method_10074()).method_26204())) {
            rawportal = rawportal.method_10074().method_10062();
        }
        while (CompareBlockFunctions.isPortalBlock((class_2248)level.method_8320(rawportal.method_10067()).method_26204())) {
            rawportal = rawportal.method_10067().method_10062();
        }
        while (CompareBlockFunctions.isPortalBlock((class_2248)level.method_8320(rawportal.method_10095()).method_26204())) {
            rawportal = rawportal.method_10095().method_10062();
        }
        if (((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())).contains(rawportal) || ((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).containsKey(rawportal)) {
            return;
        }
        if (Util.portalExists(level, p).booleanValue()) {
            return;
        }
        Util.sendSpreadingMessage(level, p);
        preventedportals.get(level).put(p, false);
        portals.get(level).add(rawportal);
        Util.savePortalToWorld(level, rawportal);
        if (netherblockcount < ConfigHandler.instantConvertAmount) {
            for (netherblockcount = Util.countNetherBlocks(level, p); netherblockcount < ConfigHandler.instantConvertAmount && Util.spreadNextBlock(level, p).booleanValue(); ++netherblockcount) {
            }
        }
    }

    public static void removePortal(class_1937 level, class_2338 portal) {
        String portalfolder = WorldFunctions.getWorldPath((class_3218)((class_3218)level)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals";
        String filename = portal.method_10263() + "_" + portal.method_10264() + "_" + portal.method_10260() + ".portal";
        File filepath = new File(portalfolder + File.separator + filename);
        try {
            Files.deleteIfExists(filepath.toPath());
        }
        catch (Exception e) {
            System.out.println("[Error] Nether Portal Spread: Something went wrong while removing an old portal location.");
        }
        ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())).remove(portal);
        ((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).remove(portal);
        Util.sendBrokenPortalMessage(level, portal);
    }

    public static Boolean spreadNextBlock(class_1937 level, class_2338 portal) {
        if (!level.method_8393(portal.method_10263() >> 4, portal.method_10260() >> 4)) {
            return true;
        }
        class_2680 pbs = level.method_8320(portal);
        if (pbs == null) {
            return false;
        }
        if (!CompareBlockFunctions.isPortalBlock((class_2248)pbs.method_26204())) {
            Util.removePortal(level, portal);
            return false;
        }
        int r = ConfigHandler.portalSpreadRadius;
        class_2338 closest = null;
        double nearestdistance = 100000.0;
        int coalcount = 0;
        int psamount = ConfigHandler.preventSpreadBlockAmountNeeded;
        Iterator it = class_2338.method_17962((int)(portal.method_10263() - r), (int)(portal.method_10264() - r), (int)(portal.method_10260() - r), (int)(portal.method_10263() + r), (int)(portal.method_10264() + r), (int)(portal.method_10260() + r)).iterator();
        while (it.hasNext()) {
            try {
                class_2338 np = (class_2338)it.next();
                if (ConfigHandler.preventSpreadWithBlock && level.method_8320(np).method_26204().equals(preventSpreadBlock) && ++coalcount >= psamount) break;
                double npnd = portal.method_10262(new class_2382(np.method_10263(), np.method_10264(), np.method_10260()));
                if (!(npnd < nearestdistance) || !Util.isNetherTarget(level, np, false).booleanValue()) continue;
                nearestdistance = npnd;
                closest = np.method_10062();
            }
            catch (NullPointerException np) {}
        }
        if (ConfigHandler.preventSpreadWithBlock && coalcount >= psamount) {
            boolean prevented = false;
            if (((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).containsKey(portal)) {
                prevented = preventedportals.get(level).get(portal);
            }
            if (!prevented) {
                Util.sendPreventedMessage(level, portal);
            }
            preventedportals.get(level).put(portal, true);
            return true;
        }
        if (closest != null) {
            boolean prevented = false;
            if (((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).containsKey(portal)) {
                prevented = preventedportals.get(level).get(portal);
            }
            if (prevented) {
                Util.sendSpreadingMessage(level, portal);
            }
            preventedportals.get(level).put(portal, false);
            Util.spreadNetherToBlock(level, closest);
            return true;
        }
        return false;
    }

    public static int countNetherBlocks(class_1937 level, class_2338 p) {
        int nethercount = 0;
        int r = ConfigHandler.portalSpreadRadius;
        Iterator it = class_2338.method_17962((int)(p.method_10263() - r), (int)(p.method_10264() - r), (int)(p.method_10260() - r), (int)(p.method_10263() + r), (int)(p.method_10264() + r), (int)(p.method_10260() + r)).iterator();
        while (it.hasNext()) {
            class_2338 np = (class_2338)it.next();
            if (!Util.isNetherTarget(level, np, true).booleanValue()) continue;
            ++nethercount;
        }
        return nethercount;
    }

    public static Boolean isNetherTarget(class_1937 level, class_2338 pos, Boolean count) {
        if (level == null) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (count.booleanValue()) {
            return convertedblocks.contains(block);
        }
        return convertblocks.contains(block);
    }

    public static void spreadNetherToBlock(class_1937 level, class_2338 pos) {
        if (level == null) {
            return;
        }
        class_2680 newblockstate = null;
        class_2680 curstate = level.method_8320(pos);
        class_2248 curblock = curstate.method_26204();
        if (convertblocks.contains(curblock)) {
            RandomCollection rc = new RandomCollection();
            HashMap<class_2248, Double> hashmap = convertinto.get(curblock);
            for (class_2248 b0 : hashmap.keySet()) {
                Double weight = hashmap.get(b0);
                rc.add(weight * 100.0, (Object)b0);
            }
            newblockstate = ((class_2248)rc.next()).method_9564();
        }
        if (newblockstate != null) {
            level.method_8501(pos, newblockstate);
        }
    }

    private static void sendSpreadingMessage(class_1937 level, class_2338 p) {
        if (!ConfigHandler.sendMessageOnPortalCreation) {
            return;
        }
        String message = ConfigHandler.messageOnPortalCreation;
        StringFunctions.sendMessageToPlayersAround((class_1937)level, (class_2338)p, (int)ConfigHandler.portalSpreadRadius, (String)Util.formatAroundString(message, ConfigHandler.preventSpreadBlockAmountNeeded, p), (class_124)class_124.field_1061);
    }

    private static void sendPreventedMessage(class_1937 level, class_2338 p) {
        if (!ConfigHandler.sendMessageOnPreventSpreadBlocksFound) {
            return;
        }
        String message = ConfigHandler.messageOnPreventSpreadBlocksFound;
        StringFunctions.sendMessageToPlayersAround((class_1937)level, (class_2338)p, (int)ConfigHandler.portalSpreadRadius, (String)Util.formatAroundString(message, ConfigHandler.preventSpreadBlockAmountNeeded, p), (class_124)class_124.field_1077);
    }

    private static void sendBrokenPortalMessage(class_1937 level, class_2338 p) {
        if (!ConfigHandler.sendMessageOnPortalBroken) {
            return;
        }
        String message = ConfigHandler.messageOnPortalBroken;
        StringFunctions.sendMessageToPlayersAround((class_1937)level, (class_2338)p, (int)ConfigHandler.portalSpreadRadius, (String)Util.formatAroundString(message, ConfigHandler.preventSpreadBlockAmountNeeded, p), (class_124)class_124.field_1077);
    }

    private static String formatAroundString(String message, int amountneeded, class_2338 portal) {
        if (preventSpreadBlock == null) {
            preventSpreadBlock = class_2246.field_10381;
        }
        String blockstring = BlockFunctions.blockToReadableString((class_2248)preventSpreadBlock, (int)amountneeded);
        message = ((String)message).replace("%preventSpreadBlockString%", blockstring);
        message = ((String)message).replace("%preventSpreadBlockAmountNeeded%", "" + amountneeded);
        message = ((String)message).replace("%portalSpreadRadius%", "" + ConfigHandler.portalSpreadRadius);
        if (ConfigHandler.prefixPortalCoordsInMessage) {
            message = "Portal {" + portal.method_10263() + ", " + portal.method_10264() + ", " + portal.method_10260() + "}: " + (String)message;
        }
        return message;
    }
}

