/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread_common_forge.util;

import com.natamus.collective_common_forge.functions.BlockFunctions;
import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.functions.DimensionFunctions;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.collective_common_forge.objects.RandomCollection;
import com.natamus.netherportalspread_common_forge.config.ConfigHandler;
import com.natamus.netherportalspread_common_forge.data.Variables;
import com.natamus.netherportalspread_common_forge.util.DefaultConfigs;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Util {
    public static HashMap<Level, CopyOnWriteArrayList<BlockPos>> portals = new HashMap();
    public static HashMap<Level, HashMap<BlockPos, Boolean>> preventedportals = new HashMap();
    private static final HashMap<Block, HashMap<Block, Double>> convertinto = new HashMap();
    private static final List<Block> convertblocks = new ArrayList<Block>();
    private static final List<Block> convertedblocks = new ArrayList<Block>();
    private static Block preventSpreadBlock = null;

    public static void attemptSpreadBlockProcess(Level level) {
        if (!Variables.processedSpreadBlockLoad) {
            try {
                Util.loadSpreadBlocks(level);
                Variables.processedSpreadBlockLoad = true;
            }
            catch (IOException ex) {
                System.out.println("[Nether Portal Spread] Something went wrong loading the nether spread block config.");
            }
        }
    }

    public static void loadSpreadBlocks(Level level) throws IOException {
        Registry blockRegistry = level.m_9598_().m_175515_(Registries.f_256747_);
        String dirpath = DataFunctions.getConfigDirectory() + File.separator + "netherportalspread";
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "spreadsettings.txt");
        if (dir.isDirectory() && file.isFile()) {
            String spreadsettings = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "spreadsettings.txt", new String[0])));
            spreadsettings = spreadsettings.replace("\n", "").replace("\r", "").replace(" ", "");
            for (String line : spreadsettings.split(",")) {
                if (line.length() < 4) {
                    System.out.println("The Nether Portal Spread spread settings contains an empty line. Ignoring it.");
                    continue;
                }
                String[] linespl = line.split(";");
                if (linespl.length != 2) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors. Ignoring it.");
                    continue;
                }
                Object fromblockstr = linespl[0];
                if (!((String)fromblockstr).contains(":")) {
                    fromblockstr = "minecraft:" + (String)fromblockstr;
                }
                ResourceLocation frl = new ResourceLocation((String)fromblockstr);
                if (!blockRegistry.m_6566_().contains(frl)) {
                    System.out.println("[Nether Portal Spread] Unable to find from-block '" + (String)fromblockstr + "' in the Forge block registry. Ignoring it.");
                    continue;
                }
                Block fromblock = (Block)blockRegistry.m_7745_(frl);
                String toblocks = linespl[1].replace("[", "").replace("]", "");
                double totalweight = 0.0;
                HashMap<Block, Double> tempmap = new HashMap<Block, Double>();
                for (String tb : toblocks.split("\\+")) {
                    String[] tbspl = tb.split(">");
                    if (tbspl.length < 2) continue;
                    Object toblockstr = tbspl[0];
                    if (!((String)toblockstr).contains(":")) {
                        toblockstr = "minecraft:" + (String)toblockstr;
                    }
                    double weight = 1.0;
                    try {
                        weight = Double.parseDouble(tbspl[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    totalweight += weight;
                    ResourceLocation trl = new ResourceLocation((String)toblockstr);
                    if (blockRegistry.m_6566_().contains(trl)) {
                        tempmap.put((Block)blockRegistry.m_7745_(trl), weight);
                        continue;
                    }
                    System.out.println("[Nether Portal Spread] Unable to find to-block '" + (String)toblockstr + "' in the Forge block registry. Ignoring it.");
                }
                if (tempmap.size() == 0 || totalweight == 0.0) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors, no convert blocks were found. Ignoring it.");
                    continue;
                }
                for (Block key : tempmap.keySet()) {
                    Double weightvalue = (Double)tempmap.get(key);
                    tempmap.put(key, 1.0 / totalweight * weightvalue);
                }
                convertinto.put(fromblock, tempmap);
            }
            for (Block b0 : convertinto.keySet()) {
                convertblocks.add(b0);
                convertedblocks.addAll(convertinto.get(b0).keySet());
            }
        } else {
            dir.mkdirs();
            List<String> defaultconfig = DefaultConfigs.getDefaultConfigForVersion("[1.19.4]");
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "spreadsettings.txt", StandardCharsets.UTF_8);
            for (String line : defaultconfig) {
                writer.println(line);
            }
            writer.close();
            Util.loadSpreadBlocks(level);
        }
        if (preventSpreadBlock == null) {
            String psbstr = ConfigHandler.preventSpreadBlockString.strip().replaceAll("[^a-z0-9_.-:]", "");
            try {
                ResourceLocation psbrl = new ResourceLocation(psbstr);
                if (blockRegistry.m_6566_().contains(psbrl)) {
                    preventSpreadBlock = (Block)blockRegistry.m_7745_(psbrl);
                    return;
                }
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
            System.out.println("[Nether Portal Spread] Unable to get a prevent-spread-block from the string '" + psbstr + "'. Using the default coal block instead.");
            preventSpreadBlock = Blocks.f_50353_;
        }
    }

    public static void loadPortalsFromWorld(Level level) {
        String portalfolder = WorldFunctions.getWorldPath((ServerLevel)((ServerLevel)level)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals";
        String specificportalfolder = portalfolder + File.separator + DimensionFunctions.getSimpleDimensionString((Level)level);
        if (specificportalfolder.endsWith("overworld")) {
            File[] files;
            File sourceDir = new File(portalfolder);
            File destinationDir = new File(specificportalfolder);
            destinationDir.mkdirs();
            for (File f : files = sourceDir.listFiles(pathname -> pathname.getName().endsWith(".portal"))) {
                Path sourcePath = Paths.get(sourceDir.getAbsolutePath() + File.separator + f.getName(), new String[0]);
                Path destinationPath = Paths.get(destinationDir.getAbsolutePath() + File.separator + f.getName(), new String[0]);
                try {
                    Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        File dir = new File(specificportalfolder);
        dir.mkdirs();
        File[] listOfFiles = dir.listFiles();
        if (listOfFiles == null) {
            return;
        }
        int r = ConfigHandler.portalSpreadRadius;
        int psamount = ConfigHandler.preventSpreadBlockAmountNeeded;
        for (File listOfFile : listOfFiles) {
            String[] cs;
            String filename = listOfFile.getName();
            if (!filename.endsWith(".portal") || (cs = filename.replace(".portal", "").split("_")).length != 3 || !NumberFunctions.isNumeric((String)cs[0]) || !NumberFunctions.isNumeric((String)cs[1]) || !NumberFunctions.isNumeric((String)cs[2])) continue;
            int x = Integer.parseInt(cs[0]);
            int y = Integer.parseInt(cs[1]);
            int z = Integer.parseInt(cs[2]);
            BlockPos portal = new BlockPos(x, y, z);
            ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())).add(portal);
            if (!ConfigHandler.preventSpreadWithBlock) continue;
            int coalcount = 0;
            Iterator it = BlockPos.m_121886_((int)(portal.m_123341_() - r), (int)(portal.m_123342_() - r), (int)(portal.m_123343_() - r), (int)(portal.m_123341_() + r), (int)(portal.m_123342_() + r), (int)(portal.m_123343_() + r)).iterator();
            while (it.hasNext()) {
                try {
                    BlockPos np = (BlockPos)it.next();
                    if (!level.m_8055_(np).m_60734_().equals(preventSpreadBlock) || ++coalcount < psamount) continue;
                    break;
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            ((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).put(portal, coalcount >= psamount);
        }
    }

    public static void savePortalToWorld(Level level, BlockPos portal) {
        String portalfolder = WorldFunctions.getWorldPath((ServerLevel)((ServerLevel)level)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals" + File.separator + DimensionFunctions.getSimpleDimensionString((Level)level);
        File dir = new File(portalfolder);
        dir.mkdirs();
        String filename = portal.m_123341_() + "_" + portal.m_123342_() + "_" + portal.m_123343_() + ".portal";
        try {
            PrintWriter writer = new PrintWriter(portalfolder + File.separator + filename, StandardCharsets.UTF_8);
            writer.close();
        }
        catch (Exception e) {
            System.out.println("[Error] Nether Portal Spread: Something went wrong while saving a portal location.");
        }
    }

    private static Boolean portalExists(Level level, BlockPos pos) {
        for (BlockPos portalpos : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())) {
            double distance = pos.m_123331_(new Vec3i(portalpos.m_123341_(), portalpos.m_123342_(), portalpos.m_123343_()));
            if (!(distance < 10.0)) continue;
            return true;
        }
        return false;
    }

    public static void validatePortalAndAdd(Level level, BlockPos p) {
        int netherblockcount;
        BlockPos rawportal = null;
        int r = 3;
        Iterator it = BlockPos.m_121886_((int)(p.m_123341_() - r), (int)(p.m_123342_() - r), (int)(p.m_123343_() - r), (int)(p.m_123341_() + r), (int)(p.m_123342_() + r), (int)(p.m_123343_() + r)).iterator();
        while (it.hasNext()) {
            BlockPos nextpos = (BlockPos)it.next();
            Block block = level.m_8055_(nextpos).m_60734_();
            if (!CompareBlockFunctions.isPortalBlock((Block)block)) continue;
            rawportal = nextpos.m_7949_();
            break;
        }
        if (rawportal == null) {
            return;
        }
        while (CompareBlockFunctions.isPortalBlock((Block)level.m_8055_(rawportal.m_7495_()).m_60734_())) {
            rawportal = rawportal.m_7495_().m_7949_();
        }
        while (CompareBlockFunctions.isPortalBlock((Block)level.m_8055_(rawportal.m_122024_()).m_60734_())) {
            rawportal = rawportal.m_122024_().m_7949_();
        }
        while (CompareBlockFunctions.isPortalBlock((Block)level.m_8055_(rawportal.m_122012_()).m_60734_())) {
            rawportal = rawportal.m_122012_().m_7949_();
        }
        if (((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())).contains(rawportal) || ((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).containsKey(rawportal)) {
            return;
        }
        if (Util.portalExists(level, p).booleanValue()) {
            return;
        }
        Util.sendSpreadingMessage(level, p);
        preventedportals.get(level).put(p, false);
        portals.get(level).add(rawportal);
        Util.savePortalToWorld(level, rawportal);
        if (netherblockcount < ConfigHandler.instantConvertAmount) {
            for (netherblockcount = Util.countNetherBlocks(level, p); netherblockcount < ConfigHandler.instantConvertAmount && Util.spreadNextBlock(level, p).booleanValue(); ++netherblockcount) {
            }
        }
    }

    public static void removePortal(Level level, BlockPos portal) {
        String portalfolder = WorldFunctions.getWorldPath((ServerLevel)((ServerLevel)level)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals";
        String filename = portal.m_123341_() + "_" + portal.m_123342_() + "_" + portal.m_123343_() + ".portal";
        File filepath = new File(portalfolder + File.separator + filename);
        try {
            Files.deleteIfExists(filepath.toPath());
        }
        catch (Exception e) {
            System.out.println("[Error] Nether Portal Spread: Something went wrong while removing an old portal location.");
        }
        ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())).remove(portal);
        ((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).remove(portal);
        Util.sendBrokenPortalMessage(level, portal);
    }

    public static Boolean spreadNextBlock(Level level, BlockPos portal) {
        if (!level.m_7232_(portal.m_123341_() >> 4, portal.m_123343_() >> 4)) {
            return true;
        }
        BlockState pbs = level.m_8055_(portal);
        if (pbs == null) {
            return false;
        }
        if (!CompareBlockFunctions.isPortalBlock((Block)pbs.m_60734_())) {
            Util.removePortal(level, portal);
            return false;
        }
        int r = ConfigHandler.portalSpreadRadius;
        BlockPos closest = null;
        double nearestdistance = 100000.0;
        int coalcount = 0;
        int psamount = ConfigHandler.preventSpreadBlockAmountNeeded;
        Iterator it = BlockPos.m_121886_((int)(portal.m_123341_() - r), (int)(portal.m_123342_() - r), (int)(portal.m_123343_() - r), (int)(portal.m_123341_() + r), (int)(portal.m_123342_() + r), (int)(portal.m_123343_() + r)).iterator();
        while (it.hasNext()) {
            try {
                BlockPos np = (BlockPos)it.next();
                if (ConfigHandler.preventSpreadWithBlock && level.m_8055_(np).m_60734_().equals(preventSpreadBlock) && ++coalcount >= psamount) break;
                double npnd = portal.m_123331_(new Vec3i(np.m_123341_(), np.m_123342_(), np.m_123343_()));
                if (!(npnd < nearestdistance) || !Util.isNetherTarget(level, np, false).booleanValue()) continue;
                nearestdistance = npnd;
                closest = np.m_7949_();
            }
            catch (NullPointerException np) {}
        }
        if (ConfigHandler.preventSpreadWithBlock && coalcount >= psamount) {
            boolean prevented = false;
            if (((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).containsKey(portal)) {
                prevented = preventedportals.get(level).get(portal);
            }
            if (!prevented) {
                Util.sendPreventedMessage(level, portal);
            }
            preventedportals.get(level).put(portal, true);
            return true;
        }
        if (closest != null) {
            boolean prevented = false;
            if (((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).containsKey(portal)) {
                prevented = preventedportals.get(level).get(portal);
            }
            if (prevented) {
                Util.sendSpreadingMessage(level, portal);
            }
            preventedportals.get(level).put(portal, false);
            Util.spreadNetherToBlock(level, closest);
            return true;
        }
        return false;
    }

    public static int countNetherBlocks(Level level, BlockPos p) {
        int nethercount = 0;
        int r = ConfigHandler.portalSpreadRadius;
        Iterator it = BlockPos.m_121886_((int)(p.m_123341_() - r), (int)(p.m_123342_() - r), (int)(p.m_123343_() - r), (int)(p.m_123341_() + r), (int)(p.m_123342_() + r), (int)(p.m_123343_() + r)).iterator();
        while (it.hasNext()) {
            BlockPos np = (BlockPos)it.next();
            if (!Util.isNetherTarget(level, np, true).booleanValue()) continue;
            ++nethercount;
        }
        return nethercount;
    }

    public static Boolean isNetherTarget(Level level, BlockPos pos, Boolean count) {
        if (level == null) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (count.booleanValue()) {
            return convertedblocks.contains(block);
        }
        return convertblocks.contains(block);
    }

    public static void spreadNetherToBlock(Level level, BlockPos pos) {
        if (level == null) {
            return;
        }
        BlockState newblockstate = null;
        BlockState curstate = level.m_8055_(pos);
        Block curblock = curstate.m_60734_();
        if (convertblocks.contains(curblock)) {
            RandomCollection rc = new RandomCollection();
            HashMap<Block, Double> hashmap = convertinto.get(curblock);
            for (Block b0 : hashmap.keySet()) {
                Double weight = hashmap.get(b0);
                rc.add(weight * 100.0, (Object)b0);
            }
            newblockstate = ((Block)rc.next()).m_49966_();
        }
        if (newblockstate != null) {
            level.m_46597_(pos, newblockstate);
        }
    }

    private static void sendSpreadingMessage(Level level, BlockPos p) {
        if (!ConfigHandler.sendMessageOnPortalCreation) {
            return;
        }
        String message = ConfigHandler.messageOnPortalCreation;
        StringFunctions.sendMessageToPlayersAround((Level)level, (BlockPos)p, (int)ConfigHandler.portalSpreadRadius, (String)Util.formatAroundString(message, ConfigHandler.preventSpreadBlockAmountNeeded, p), (ChatFormatting)ChatFormatting.RED);
    }

    private static void sendPreventedMessage(Level level, BlockPos p) {
        if (!ConfigHandler.sendMessageOnPreventSpreadBlocksFound) {
            return;
        }
        String message = ConfigHandler.messageOnPreventSpreadBlocksFound;
        StringFunctions.sendMessageToPlayersAround((Level)level, (BlockPos)p, (int)ConfigHandler.portalSpreadRadius, (String)Util.formatAroundString(message, ConfigHandler.preventSpreadBlockAmountNeeded, p), (ChatFormatting)ChatFormatting.DARK_GREEN);
    }

    private static void sendBrokenPortalMessage(Level level, BlockPos p) {
        if (!ConfigHandler.sendMessageOnPortalBroken) {
            return;
        }
        String message = ConfigHandler.messageOnPortalBroken;
        StringFunctions.sendMessageToPlayersAround((Level)level, (BlockPos)p, (int)ConfigHandler.portalSpreadRadius, (String)Util.formatAroundString(message, ConfigHandler.preventSpreadBlockAmountNeeded, p), (ChatFormatting)ChatFormatting.DARK_GREEN);
    }

    private static String formatAroundString(String message, int amountneeded, BlockPos portal) {
        if (preventSpreadBlock == null) {
            preventSpreadBlock = Blocks.f_50353_;
        }
        String blockstring = BlockFunctions.blockToReadableString((Block)preventSpreadBlock, (int)amountneeded);
        message = ((String)message).replace("%preventSpreadBlockString%", blockstring);
        message = ((String)message).replace("%preventSpreadBlockAmountNeeded%", "" + amountneeded);
        message = ((String)message).replace("%portalSpreadRadius%", "" + ConfigHandler.portalSpreadRadius);
        if (ConfigHandler.prefixPortalCoordsInMessage) {
            message = "Portal {" + portal.m_123341_() + ", " + portal.m_123342_() + ", " + portal.m_123343_() + "}: " + (String)message;
        }
        return message;
    }
}

