/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v2.data;

import fuzs.puzzleslib.api.capability.v2.data.CapabilityComponent;

public abstract class PlayerRespawnCopyStrategy {
    public static final PlayerRespawnCopyStrategy ALWAYS = new PlayerRespawnCopyStrategy(){

        @Override
        public void copy(CapabilityComponent oldCapability, CapabilityComponent newCapability, boolean returningFromEnd, boolean keepInventory) {
            PlayerRespawnCopyStrategy.actuallyCopy(oldCapability, newCapability);
        }
    };
    public static final PlayerRespawnCopyStrategy KEEP_INVENTORY = new PlayerRespawnCopyStrategy(){

        @Override
        public void copy(CapabilityComponent oldCapability, CapabilityComponent newCapability, boolean returningFromEnd, boolean keepInventory) {
            if (returningFromEnd || keepInventory) {
                PlayerRespawnCopyStrategy.actuallyCopy(oldCapability, newCapability);
            }
        }
    };
    public static final PlayerRespawnCopyStrategy RETURNING_FROM_END = new PlayerRespawnCopyStrategy(){

        @Override
        public void copy(CapabilityComponent oldCapability, CapabilityComponent newCapability, boolean returningFromEnd, boolean keepInventory) {
            if (returningFromEnd) {
                PlayerRespawnCopyStrategy.actuallyCopy(oldCapability, newCapability);
            }
        }
    };
    public static final PlayerRespawnCopyStrategy NEVER = new PlayerRespawnCopyStrategy(){

        @Override
        public void copy(CapabilityComponent oldCapability, CapabilityComponent newCapability, boolean returningFromEnd, boolean keepInventory) {
        }
    };

    public abstract void copy(CapabilityComponent var1, CapabilityComponent var2, boolean var3, boolean var4);

    private static void actuallyCopy(CapabilityComponent oldCapability, CapabilityComponent newCapability) {
        newCapability.read(oldCapability.toCompoundTag());
    }
}

