/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.core.v1;

import fuzs.puzzleslib.api.client.core.v1.context.AdditionalModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BuildCreativeModeTabContentsContext;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.core.v1.context.ClientTooltipComponentsContext;
import fuzs.puzzleslib.api.client.core.v1.context.ColorProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicBakingCompletedContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicModifyBakingResultContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntitySpectatorShaderContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemDecorationContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.core.v1.context.ParticleProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import fuzs.puzzleslib.api.client.core.v1.context.SearchRegistryContext;
import fuzs.puzzleslib.api.client.core.v1.context.SkullRenderersContext;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.context.AddReloadListenersContext;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.core.ClientFactories;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.util.Strings;

public interface ClientModConstructor {
    public static void construct(String modId, Supplier<ClientModConstructor> modConstructor, ContentRegistrationFlags ... contentRegistrations) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("mod id must not be empty");
        }
        ModContext.get(modId).scheduleClientModConstruction(() -> {
            PuzzlesLib.LOGGER.info("Constructing client components for mod {}", (Object)modId);
            ClientFactories.INSTANCE.constructClientMod(modId, modConstructor, contentRegistrations);
        });
    }

    default public void onConstructMod() {
    }

    default public void onClientSetup(ModLifecycleContext context) {
    }

    default public void onRegisterEntityRenderers(EntityRenderersContext context) {
    }

    default public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
    }

    default public void onRegisterClientTooltipComponents(ClientTooltipComponentsContext context) {
    }

    default public void onRegisterParticleProviders(ParticleProvidersContext context) {
    }

    default public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
    }

    default public void onRegisterSearchTrees(SearchRegistryContext context) {
    }

    default public void onModifyBakingResult(DynamicModifyBakingResultContext context) {
    }

    default public void onBakingCompleted(DynamicBakingCompletedContext context) {
    }

    default public void onRegisterAdditionalModels(AdditionalModelsContext context) {
    }

    default public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
    }

    default public void onRegisterBuiltinModelItemRenderers(BuiltinModelItemRendererContext context) {
    }

    default public void onRegisterItemDecorations(ItemDecorationContext context) {
    }

    default public void onRegisterEntitySpectatorShaders(EntitySpectatorShaderContext context) {
    }

    default public void onRegisterSkullRenderers(SkullRenderersContext context) {
    }

    default public void onRegisterResourcePackReloadListeners(AddReloadListenersContext context) {
    }

    default public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
    }

    default public void onRegisterKeyMappings(KeyMappingsContext context) {
    }

    default public void onRegisterBlockRenderTypes(RenderTypesContext<Block> context) {
    }

    default public void onRegisterFluidRenderTypes(RenderTypesContext<Fluid> context) {
    }

    default public void onRegisterBlockColorProviders(ColorProvidersContext<Block, BlockColor> context) {
    }

    default public void onRegisterItemColorProviders(ColorProvidersContext<Item, ItemColor> context) {
    }

    default public void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsContext context) {
    }

    default public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
    }
}

