/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.DistType;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class DistTypeExecutor {
    @Nullable
    public static <T> T callWhenOn(DistType envType, Supplier<Callable<T>> toRun) {
        if (ModLoaderEnvironment.INSTANCE.isEnvironmentType(envType)) {
            try {
                return toRun.get().call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void runWhenOn(DistType envType, Supplier<Runnable> toRun) {
        if (ModLoaderEnvironment.INSTANCE.isEnvironmentType(envType)) {
            toRun.get().run();
        }
    }

    @Nullable
    public static <T> T getWhenOn(DistType envType, Supplier<Supplier<T>> toGet) {
        if (ModLoaderEnvironment.INSTANCE.isEnvironmentType(envType)) {
            return toGet.get().get();
        }
        return null;
    }

    public static <T> T getForDistType(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return switch (ModLoaderEnvironment.INSTANCE.getEnvironmentType()) {
            default -> throw new IncompatibleClassChangeError();
            case DistType.CLIENT -> clientTarget.get().get();
            case DistType.SERVER -> serverTarget.get().get();
        };
    }
}

