/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.context.AddReloadListenersContext;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesModifyContext;
import fuzs.puzzleslib.api.core.v1.context.FlammableBlocksContext;
import fuzs.puzzleslib.api.core.v1.context.FuelBurnTimesContext;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.core.CommonFactories;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.function.Supplier;
import org.apache.logging.log4j.util.Strings;

public interface ModConstructor {
    public static void construct(String modId, Supplier<ModConstructor> supplier, ContentRegistrationFlags ... contentRegistrations) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("mod id must not be empty");
        }
        PuzzlesLib.LOGGER.info("Constructing common components for mod {}", (Object)modId);
        ModConstructor modConstructor = supplier.get();
        ModContext modContext = ModContext.get(modId);
        modContext.beforeModConstruction();
        CommonFactories.INSTANCE.constructMod(modId, modConstructor, contentRegistrations);
        modContext.afterModConstruction();
    }

    default public void onConstructMod() {
    }

    default public void onCommonSetup(ModLifecycleContext context) {
    }

    default public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
    }

    default public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
    }

    default public void onEntityAttributeModification(EntityAttributesModifyContext context) {
    }

    default public void onRegisterFuelBurnTimes(FuelBurnTimesContext context) {
    }

    default public void onRegisterBiomeModifications(BiomeModificationsContext context) {
    }

    default public void onRegisterFlammableBlocks(FlammableBlocksContext context) {
    }

    default public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
    }

    default public void onAddDataPackFinders(PackRepositorySourcesContext context) {
    }

    default public void onRegisterDataPackReloadListeners(AddReloadListenersContext context) {
    }
}

