/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v1;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.registries.ForgeRegistries;

public final class AbstractLootProvider {
    public static LootTableProvider createProvider(PackOutput packOutput, LootTableSubProvider provider, LootContextParamSet paramSet) {
        return new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(() -> provider, paramSet)));
    }

    public static abstract class Simple
    implements LootTableSubProvider,
    DataProvider {
        private final LootTableProvider provider;
        private final Map<ResourceLocation, LootTable.Builder> values = Maps.newHashMap();

        public Simple(PackOutput packOutput, LootContextParamSet paramSet) {
            this.provider = AbstractLootProvider.createProvider(packOutput, this, paramSet);
        }

        public final CompletableFuture<?> m_213708_(CachedOutput output) {
            return this.provider.m_213708_(output);
        }

        public String m_6055_() {
            return this.provider.m_6055_();
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> exporter) {
            this.generate();
            this.values.forEach(exporter);
        }

        protected void add(ResourceLocation table, LootTable.Builder builder) {
            this.values.put(table, builder);
        }

        public abstract void generate();
    }

    public static abstract class EntityTypes
    extends EntityLootSubProvider
    implements DataProvider {
        private final LootTableProvider provider;
        private final String modId;

        public EntityTypes(PackOutput packOutput, String modId) {
            super(FeatureFlags.f_244280_.m_247355_());
            this.provider = AbstractLootProvider.createProvider(packOutput, (LootTableSubProvider)this, LootContextParamSets.f_81415_);
            this.modId = modId;
        }

        public final CompletableFuture<?> m_213708_(CachedOutput output) {
            return this.provider.m_213708_(output);
        }

        public String m_6055_() {
            return "Entity Type Loot Tables";
        }

        public abstract void m_246942_();

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return ForgeRegistries.ENTITY_TYPES.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId)).map(Map.Entry::getValue);
        }

        protected boolean m_245552_(EntityType<?> pEntityType) {
            return true;
        }
    }

    public static abstract class Blocks
    extends BlockLootSubProvider
    implements DataProvider {
        private final LootTableProvider provider;
        private final String modId;

        public Blocks(PackOutput packOutput, String modId) {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
            this.provider = AbstractLootProvider.createProvider(packOutput, (LootTableSubProvider)this, LootContextParamSets.f_81421_);
            this.modId = modId;
        }

        public final CompletableFuture<?> m_213708_(CachedOutput output) {
            return this.provider.m_213708_(output);
        }

        public String m_6055_() {
            return "Block Loot Tables";
        }

        public abstract void m_245660_();

        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId)).map(Map.Entry::getValue).collect(Collectors.toSet());
        }
    }
}

