/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;

public class LegacySmithingTransformRecipe
extends SmithingTransformRecipe {
    public static final String RECIPE_SERIALIZER_ID = "legacy_smithing_transform";
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;

    public LegacySmithingTransformRecipe(ResourceLocation id, Ingredient base, Ingredient addition, ItemStack result) {
        super(id, Ingredient.m_151265_(), base, addition, result);
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public RecipeSerializer<?> m_7707_() {
        return LegacySmithingTransformRecipe.getModSerializer(this.m_6423_().m_135827_());
    }

    public static RecipeSerializer<?> getModSerializer(String modId) {
        RecipeSerializer recipeSerializer = (RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(new ResourceLocation(modId, RECIPE_SERIALIZER_ID));
        Objects.requireNonNull(recipeSerializer, "legacy smithing transform recipe serializer for %s is null".formatted(modId));
        return recipeSerializer;
    }

    public static class Serializer
    implements RecipeSerializer<LegacySmithingTransformRecipe> {
        public LegacySmithingTransformRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"base"));
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"addition"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new LegacySmithingTransformRecipe(resourceLocation, base, addition, result);
        }

        public LegacySmithingTransformRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf);
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf);
            ItemStack result = friendlyByteBuf.m_130267_();
            return new LegacySmithingTransformRecipe(resourceLocation, base, addition, result);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, LegacySmithingTransformRecipe smithingTransformRecipe) {
            smithingTransformRecipe.base.m_43923_(friendlyByteBuf);
            smithingTransformRecipe.addition.m_43923_(friendlyByteBuf);
            friendlyByteBuf.m_130055_(smithingTransformRecipe.result);
        }
    }
}

