/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.core;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicBakingCompletedContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicModifyBakingResultContext;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.core.DynamicModifyBakingResultContextImpl;
import fuzs.puzzleslib.impl.client.core.context.AdditionalModelsContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockColorProvidersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockEntityRenderersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockRenderTypesContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BuildCreativeModeTabContentsContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BuiltinModelItemRendererContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ClientTooltipComponentsContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.DynamicBakingCompletedContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.EntityRenderersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.EntitySpectatorShaderContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.FluidRenderTypesContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemColorProvidersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemDecorationContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemModelPropertiesContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.KeyMappingsContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.LayerDefinitionsContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.LivingEntityRenderLayersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ParticleProvidersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ResourcePackSourcesContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.SearchRegistryContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.SkullRenderersContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.AddReloadListenersContextForgeImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.ArrayUtils;

public final class ForgeClientModConstructor {
    private ForgeClientModConstructor() {
    }

    public static void construct(ClientModConstructor constructor, String modId, ContentRegistrationFlags ... contentRegistrations) {
        ModContainerHelper.findModEventBus(modId).ifPresent(eventBus -> {
            ForgeClientModConstructor.registerModHandlers(constructor, modId, eventBus, Lists.newArrayList(), contentRegistrations);
            constructor.onConstructMod();
        });
    }

    private static void registerModHandlers(ClientModConstructor constructor, String modId, IEventBus eventBus, List<ResourceManagerReloadListener> dynamicRenderers, ContentRegistrationFlags[] contentRegistrations) {
        eventBus.addListener(evt -> {
            constructor.onClientSetup(arg_0 -> ((FMLClientSetupEvent)evt).enqueueWork(arg_0));
            constructor.onRegisterSearchTrees(new SearchRegistryContextForgeImpl());
            constructor.onRegisterItemModelProperties(new ItemModelPropertiesContextForgeImpl());
            constructor.onRegisterBuiltinModelItemRenderers(new BuiltinModelItemRendererContextForgeImpl(dynamicRenderers));
            constructor.onRegisterBlockRenderTypes(new BlockRenderTypesContextForgeImpl());
            constructor.onRegisterFluidRenderTypes(new FluidRenderTypesContextForgeImpl());
        });
        eventBus.addListener(evt -> {
            constructor.onRegisterEntityRenderers(new EntityRenderersContextForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerEntityRenderer(arg_0, arg_1)));
            constructor.onRegisterBlockEntityRenderers(new BlockEntityRenderersContextForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerBlockEntityRenderer(arg_0, arg_1)));
        });
        eventBus.addListener(evt -> constructor.onRegisterClientTooltipComponents(new ClientTooltipComponentsContextForgeImpl((arg_0, arg_1) -> ((RegisterClientTooltipComponentFactoriesEvent)evt).register(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterParticleProviders(new ParticleProvidersContextForgeImpl((RegisterParticleProvidersEvent)evt)));
        eventBus.addListener(evt -> constructor.onRegisterLayerDefinitions(new LayerDefinitionsContextForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)evt).registerLayerDefinition(arg_0, arg_1))));
        eventBus.addListener(evt -> ForgeClientModConstructor.onModifyBakingResult(constructor::onModifyBakingResult, modId, evt.getModels(), evt.getModelBakery()));
        eventBus.addListener(evt -> ForgeClientModConstructor.onBakingCompleted(constructor::onBakingCompleted, modId, evt.getModelManager(), evt.getModels(), evt.getModelBakery()));
        eventBus.addListener(evt -> constructor.onRegisterAdditionalModels(new AdditionalModelsContextForgeImpl(arg_0 -> ((ModelEvent.RegisterAdditional)evt).register(arg_0))));
        eventBus.addListener(evt -> constructor.onRegisterItemDecorations(new ItemDecorationContextForgeImpl((arg_0, arg_1) -> ((RegisterItemDecorationsEvent)evt).register(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterEntitySpectatorShaders(new EntitySpectatorShaderContextForgeImpl((arg_0, arg_1) -> ((RegisterEntitySpectatorShadersEvent)evt).register(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterSkullRenderers(new SkullRenderersContextForgeImpl(evt.getEntityModelSet(), (arg_0, arg_1) -> ((EntityRenderersEvent.CreateSkullModels)evt).registerSkullModel(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterResourcePackReloadListeners(new AddReloadListenersContextForgeImpl(arg_0 -> ((RegisterClientReloadListenersEvent)evt).registerReloadListener(arg_0))));
        eventBus.addListener(evt -> ForgeClientModConstructor.registerBuiltInItemModelRenderersReloadListeners(arg_0 -> ((RegisterClientReloadListenersEvent)evt).registerReloadListener(arg_0), modId, dynamicRenderers, contentRegistrations));
        eventBus.addListener(evt -> constructor.onRegisterLivingEntityRenderLayers(new LivingEntityRenderLayersContextForgeImpl((EntityRenderersEvent.AddLayers)evt)));
        eventBus.addListener(evt -> constructor.onRegisterKeyMappings(new KeyMappingsContextForgeImpl(arg_0 -> ((RegisterKeyMappingsEvent)evt).register(arg_0))));
        eventBus.addListener(evt -> constructor.onRegisterBlockColorProviders(new BlockColorProvidersContextForgeImpl((x$0, xva$1) -> evt.register(x$0, new Block[]{xva$1}), evt.getBlockColors())));
        eventBus.addListener(evt -> constructor.onRegisterItemColorProviders(new ItemColorProvidersContextForgeImpl((x$0, xva$1) -> evt.register(x$0, new ItemLike[]{xva$1}), evt.getItemColors())));
        eventBus.addListener(evt -> {
            ResourceLocation identifier = CreativeModeTabRegistry.getName((CreativeModeTab)evt.getTab());
            if (identifier != null) {
                constructor.onBuildCreativeModeTabContents(new BuildCreativeModeTabContentsContextForgeImpl(identifier, evt.getParameters(), (CreativeModeTab.Output)evt));
            }
        });
        eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.CLIENT_RESOURCES) {
                constructor.onAddResourcePackFinders(new ResourcePackSourcesContextForgeImpl(arg_0 -> ((AddPackFindersEvent)evt).addRepositorySource(arg_0)));
            }
        });
    }

    private static void onBakingCompleted(Consumer<DynamicBakingCompletedContext> consumer, String modId, ModelManager modelManager, Map<ResourceLocation, BakedModel> models, ModelBakery modelBakery) {
        try {
            consumer.accept(new DynamicBakingCompletedContextForgeImpl(modelManager, models, modelBakery));
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing during baking completed phase provided by {}", (Object)modId, (Object)e);
        }
    }

    private static void onModifyBakingResult(Consumer<DynamicModifyBakingResultContext> consumer, String modId, Map<ResourceLocation, BakedModel> models, ModelBakery modelBakery) {
        try {
            consumer.accept(new DynamicModifyBakingResultContextImpl(models, modelBakery));
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing during modify baking result phase provided by {}", (Object)modId, (Object)e);
        }
    }

    private static void registerBuiltInItemModelRenderersReloadListeners(Consumer<PreparableReloadListener> consumer, String modId, List<ResourceManagerReloadListener> dynamicRenderers, ContentRegistrationFlags[] contentRegistrations) {
        if (ArrayUtils.contains((Object[])contentRegistrations, (Object)((Object)ContentRegistrationFlags.DYNAMIC_RENDERERS))) {
            consumer.accept((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
                for (ResourceManagerReloadListener listener : dynamicRenderers) {
                    try {
                        listener.m_6213_(resourceManager);
                    }
                    catch (Exception e) {
                        PuzzlesLib.LOGGER.error("Unable to execute dynamic built-in model item renderers reload provided by {}", (Object)modId, (Object)e);
                    }
                }
            }));
        }
    }
}

