/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.core.context;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.init.v1.DynamicBuiltinItemRenderer;
import fuzs.puzzleslib.impl.client.core.ForwardingClientItemExtensions;
import fuzs.puzzleslib.mixin.client.accessor.ItemForgeAccessor;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public record BuiltinModelItemRendererContextForgeImpl(List<ResourceManagerReloadListener> dynamicRenderers) implements BuiltinModelItemRendererContext
{
    @Override
    public void registerItemRenderer(final DynamicBuiltinItemRenderer renderer, ItemLike ... items) {
        if (FMLLoader.getLaunchHandler().isData()) {
            return;
        }
        Objects.requireNonNull(renderer, "renderer is null");
        Objects.requireNonNull(items, "items is null");
        Preconditions.checkPositionIndex((int)1, (int)items.length, (String)"items is empty");
        IClientItemExtensions itemExtensions = new IClientItemExtensions(){
            @Nullable
            private BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.blockEntityWithoutLevelRenderer == null) {
                    this.blockEntityWithoutLevelRenderer = new ForwardingBlockEntityWithoutLevelRenderer(Minecraft.m_91087_(), renderer);
                }
                return this.blockEntityWithoutLevelRenderer;
            }
        };
        for (ItemLike item : items) {
            Objects.requireNonNull(item, "item is null");
            BuiltinModelItemRendererContextForgeImpl.setClientItemExtensions(item, itemExtensions);
        }
        this.dynamicRenderers.add(renderer);
    }

    private static void setClientItemExtensions(ItemLike item, final IClientItemExtensions itemExtensions) {
        Object renderProperties = ((ItemForgeAccessor)item.m_5456_()).puzzleslib$getRenderProperties();
        ((ItemForgeAccessor)item.m_5456_()).puzzleslib$setRenderProperties(renderProperties != null ? new ForwardingClientItemExtensions((IClientItemExtensions)renderProperties){

            @Override
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return itemExtensions.getCustomRenderer();
            }
        } : itemExtensions);
    }

    private static class ForwardingBlockEntityWithoutLevelRenderer
    extends BlockEntityWithoutLevelRenderer {
        private final DynamicBuiltinItemRenderer renderer;

        public ForwardingBlockEntityWithoutLevelRenderer(Minecraft minecraft, DynamicBuiltinItemRenderer renderer) {
            super(minecraft.m_167982_(), minecraft.m_167973_());
            this.renderer = renderer;
        }

        public void m_108829_(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
            this.renderer.renderByItem(stack, mode, matrices, vertexConsumers, light, overlay);
        }
    }
}

