/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.event;

import fuzs.puzzleslib.api.client.event.v1.ClientChunkEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientEntityLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientLevelTickEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientPlayerEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.ContainerScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.CustomizeChatPanelCallback;
import fuzs.puzzleslib.api.client.event.v1.InputEvents;
import fuzs.puzzleslib.api.client.event.v1.InventoryMobEffectsCallback;
import fuzs.puzzleslib.api.client.event.v1.ItemTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderGuiCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderGuiElementEvents;
import fuzs.puzzleslib.api.client.event.v1.RenderHandCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderNameTagCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderPlayerEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenKeyboardEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenOpeningCallback;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.data.MutableBoolean;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.impl.client.event.ForgeButtonList;
import fuzs.puzzleslib.impl.event.ForgeEventInvokerRegistryImpl;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;

public final class ForgeClientEventInvokers {
    public static void register() {
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientTickEvents.Start.class, TickEvent.ClientTickEvent.class, (callback, evt) -> {
            if (evt.phase == TickEvent.Phase.START) {
                callback.onStartTick(Minecraft.m_91087_());
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientTickEvents.End.class, TickEvent.ClientTickEvent.class, (callback, evt) -> {
            if (evt.phase == TickEvent.Phase.END) {
                callback.onEndTick(Minecraft.m_91087_());
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderGuiCallback.class, RenderGuiEvent.Post.class, (callback, evt) -> callback.onRenderGui(Minecraft.m_91087_(), evt.getPoseStack(), evt.getPartialTick(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ItemTooltipCallback.class, ItemTooltipEvent.class, (callback, evt) -> callback.onItemTooltip(evt.getItemStack(), evt.getEntity(), evt.getToolTip(), evt.getFlags()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderNameTagCallback.class, RenderNameTagEvent.class, (callback, evt) -> {
            DefaultedValue<Component> content = DefaultedValue.fromEvent(arg_0 -> ((RenderNameTagEvent)evt).setContent(arg_0), () -> ((RenderNameTagEvent)evt).getContent(), () -> ((RenderNameTagEvent)evt).getOriginalContent());
            EventResult result = callback.onRenderNameTag(evt.getEntity(), content, evt.getEntityRenderer(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight(), evt.getPartialTick());
            if (result.isInterrupt()) {
                evt.setResult(result.getAsBoolean() ? Event.Result.ALLOW : Event.Result.DENY);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ContainerScreenEvents.Background.class, ContainerScreenEvent.Render.Background.class, (callback, evt) -> callback.onDrawBackground(evt.getContainerScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ContainerScreenEvents.Foreground.class, ContainerScreenEvent.Render.Foreground.class, (callback, evt) -> callback.onDrawForeground(evt.getContainerScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InventoryMobEffectsCallback.class, ScreenEvent.RenderInventoryMobEffects.class, (callback, evt) -> {
            MutableBoolean fullSizeRendering = MutableBoolean.fromEvent(arg_0 -> ((ScreenEvent.RenderInventoryMobEffects)evt).setCompact(arg_0), () -> ((ScreenEvent.RenderInventoryMobEffects)evt).isCompact());
            MutableInt horizontalOffset = MutableInt.fromEvent(arg_0 -> ((ScreenEvent.RenderInventoryMobEffects)evt).setHorizontalOffset(arg_0), () -> ((ScreenEvent.RenderInventoryMobEffects)evt).getHorizontalOffset());
            EventResult result = callback.onInventoryMobEffects(evt.getScreen(), evt.getAvailableSpace(), fullSizeRendering, horizontalOffset);
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ScreenOpeningCallback.class, ScreenEvent.Opening.class, (callback, evt) -> {
            DefaultedValue<Screen> newScreen = DefaultedValue.fromEvent(arg_0 -> ((ScreenEvent.Opening)evt).setNewScreen(arg_0), () -> ((ScreenEvent.Opening)evt).getNewScreen(), () -> ((ScreenEvent.Opening)evt).getScreen());
            EventResult result = callback.onScreenOpening(evt.getCurrentScreen(), newScreen);
            if (result.isInterrupt() || newScreen.getAsOptional().filter(screen -> screen == evt.getCurrentScreen()).isPresent()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ComputeFovModifierCallback.class, ComputeFovModifierEvent.class, (callback, evt) -> {
            float fovEffectScale = ((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()).floatValue();
            if (fovEffectScale == 0.0f) {
                return;
            }
            Consumer<Float> consumer = value -> evt.setNewFovModifier(Mth.m_14179_((float)fovEffectScale, (float)1.0f, (float)value.floatValue()));
            Supplier<Float> supplier = () -> Float.valueOf((evt.getNewFovModifier() - 1.0f) / fovEffectScale + 1.0f);
            callback.onComputeFovModifier(evt.getPlayer(), DefaultedFloat.fromEvent(consumer, supplier, () -> ((ComputeFovModifierEvent)evt).getFovModifier()));
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ScreenEvents.BeforeInit.class, ScreenEvent.Init.Pre.class, (callback, evt) -> callback.onBeforeInit(Minecraft.m_91087_(), evt.getScreen(), evt.getScreen().f_96543_, evt.getScreen().f_96544_, new ForgeButtonList(evt.getScreen().f_169369_)));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ScreenEvents.AfterInit.class, ScreenEvent.Init.Post.class, (callback, evt) -> callback.onAfterInit(Minecraft.m_91087_(), evt.getScreen(), evt.getScreen().f_96543_, evt.getScreen().f_96544_, new ForgeButtonList(evt.getScreen().f_169369_), arg_0 -> ((ScreenEvent.Init.Post)evt).addListener(arg_0), arg_0 -> ((ScreenEvent.Init.Post)evt).removeListener(arg_0)));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.Remove.class, ScreenEvent.Closing.class, (callback, evt) -> callback.onRemove(evt.getScreen()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.BeforeRender.class, ScreenEvent.Render.Pre.class, (callback, evt) -> callback.onBeforeRender(evt.getScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.AfterRender.class, ScreenEvent.Render.Post.class, (callback, evt) -> callback.onAfterRender(evt.getScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseClick.class, ScreenEvent.MouseButtonPressed.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseClick(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseClick.class, ScreenEvent.MouseButtonPressed.Post.class, (callback, evt) -> callback.onAfterMouseClick(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseRelease.class, ScreenEvent.MouseButtonReleased.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseRelease(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseRelease.class, ScreenEvent.MouseButtonReleased.Post.class, (callback, evt) -> callback.onAfterMouseRelease(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseScroll.class, ScreenEvent.MouseScrolled.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseScroll(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getScrollDelta(), evt.getScrollDelta());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseScroll.class, ScreenEvent.MouseScrolled.Post.class, (callback, evt) -> callback.onAfterMouseScroll(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getScrollDelta(), evt.getScrollDelta()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseDrag.class, ScreenEvent.MouseDragged.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseDrag(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getMouseButton(), evt.getDragX(), evt.getDragY());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseDrag.class, ScreenEvent.MouseDragged.Post.class, (callback, evt) -> callback.onAfterMouseDrag(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getMouseButton(), evt.getDragX(), evt.getDragY()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyPress.class, ScreenEvent.KeyPressed.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeKeyPress(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyPress.class, ScreenEvent.KeyPressed.Post.class, (callback, evt) -> callback.onAfterKeyPress(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyRelease.class, ScreenEvent.KeyReleased.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeKeyRelease(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyRelease.class, ScreenEvent.KeyReleased.Post.class, (callback, evt) -> callback.onAfterKeyRelease(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderGuiElementEvents.Before.class, RenderGuiOverlayEvent.Pre.class, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            RenderGuiElementEvents.GuiOverlay overlay = (RenderGuiElementEvents.GuiOverlay)context;
            Minecraft minecraft = Minecraft.m_91087_();
            if (!evt.getOverlay().id().equals((Object)overlay.id()) || !overlay.filter().test(minecraft)) {
                return;
            }
            EventResult result = callback.onBeforeRenderGuiElement(minecraft, evt.getPoseStack(), evt.getPartialTick(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderGuiElementEvents.After.class, RenderGuiOverlayEvent.Post.class, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            RenderGuiElementEvents.GuiOverlay overlay = (RenderGuiElementEvents.GuiOverlay)context;
            Minecraft minecraft = Minecraft.m_91087_();
            if (!evt.getOverlay().id().equals((Object)overlay.id()) || !overlay.filter().test(minecraft)) {
                return;
            }
            callback.onAfterRenderGuiElement(minecraft, evt.getPoseStack(), evt.getPartialTick(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(CustomizeChatPanelCallback.class, CustomizeGuiOverlayEvent.Chat.class, (callback, evt) -> {
            MutableInt posX = MutableInt.fromEvent(arg_0 -> ((CustomizeGuiOverlayEvent.Chat)evt).setPosX(arg_0), () -> ((CustomizeGuiOverlayEvent.Chat)evt).getPosX());
            MutableInt posY = MutableInt.fromEvent(arg_0 -> ((CustomizeGuiOverlayEvent.Chat)evt).setPosY(arg_0), () -> ((CustomizeGuiOverlayEvent.Chat)evt).getPosY());
            callback.onRenderChatPanel(evt.getWindow(), evt.getPoseStack(), evt.getPartialTick(), posX, posY);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientEntityLevelEvents.Load.class, EntityJoinLevelEvent.class, (callback, evt) -> {
            if (!evt.getLevel().f_46443_) {
                return;
            }
            EventResult result = callback.onEntityLoad(evt.getEntity(), (ClientLevel)evt.getLevel());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientEntityLevelEvents.Unload.class, EntityLeaveLevelEvent.class, (callback, evt) -> {
            if (!evt.getLevel().f_46443_) {
                return;
            }
            callback.onEntityUnload(evt.getEntity(), (ClientLevel)evt.getLevel());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.BeforeMouseAction.class, InputEvent.MouseButton.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseAction(evt.getButton(), evt.getAction(), evt.getModifiers());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.AfterMouseAction.class, InputEvent.MouseButton.Post.class, (callback, evt) -> callback.onAfterMouseAction(evt.getButton(), evt.getAction(), evt.getModifiers()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.BeforeMouseScroll.class, InputEvent.MouseScrollingEvent.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseScroll(evt.isLeftDown(), evt.isMiddleDown(), evt.isRightDown(), evt.getScrollDelta(), evt.getScrollDelta());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.AfterMouseScroll.class, InputEvent.MouseScrollingEvent.class, (callback, evt) -> callback.onAfterMouseScroll(evt.isLeftDown(), evt.isMiddleDown(), evt.isRightDown(), evt.getScrollDelta(), evt.getScrollDelta()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.BeforeKeyAction.class, InputEvent.Key.class, (callback, evt) -> callback.onBeforeKeyAction(evt.getKey(), evt.getScanCode(), evt.getAction(), evt.getModifiers()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.AfterKeyAction.class, InputEvent.Key.class, (callback, evt) -> callback.onAfterKeyAction(evt.getKey(), evt.getScanCode(), evt.getAction(), evt.getModifiers()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ComputeCameraAnglesCallback.class, ViewportEvent.ComputeCameraAngles.class, (callback, evt) -> {
            MutableFloat pitch = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setPitch(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)evt).getPitch());
            MutableFloat yaw = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setYaw(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)evt).getYaw());
            MutableFloat roll = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setRoll(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)evt).getRoll());
            callback.onComputeCameraAngles(evt.getRenderer(), evt.getCamera(), evt.getPitch(), pitch, yaw, roll);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderPlayerEvents.Before.class, RenderPlayerEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeRenderPlayer(evt.getEntity(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderPlayerEvents.After.class, RenderPlayerEvent.Post.class, (callback, evt) -> callback.onAfterRenderPlayer(evt.getEntity(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderHandCallback.class, RenderHandEvent.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            EventResult result = callback.onRenderHand((Player)minecraft.f_91074_, evt.getHand(), evt.getItemStack(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight(), evt.getPartialTick(), evt.getInterpolatedPitch(), evt.getSwingProgress(), evt.getEquipProgress());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientLevelTickEvents.Start.class, TickEvent.LevelTickEvent.class, (callback, evt) -> {
            Level patt17857$temp;
            if (evt.phase != TickEvent.Phase.START || !((patt17857$temp = evt.level) instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt17857$temp;
            callback.onStartLevelTick(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientLevelTickEvents.End.class, TickEvent.LevelTickEvent.class, (callback, evt) -> {
            Level patt18206$temp;
            if (evt.phase != TickEvent.Phase.END || !((patt18206$temp = evt.level) instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt18206$temp;
            callback.onEndLevelTick(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientChunkEvents.Load.class, ChunkEvent.Load.class, (callback, evt) -> {
            LevelAccessor patt18498$temp = evt.getLevel();
            if (!(patt18498$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt18498$temp;
            callback.onChunkLoad(level, evt.getChunk());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientChunkEvents.Unload.class, ChunkEvent.Unload.class, (callback, evt) -> {
            LevelAccessor patt18786$temp = evt.getLevel();
            if (!(patt18786$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt18786$temp;
            callback.onChunkUnload(level, evt.getChunk());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientPlayerEvents.LoggedIn.class, ClientPlayerNetworkEvent.LoggingIn.class, (callback, evt) -> callback.onLoggedIn(evt.getPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientPlayerEvents.LoggedOut.class, ClientPlayerNetworkEvent.LoggingOut.class, (callback, evt) -> {
            if (evt.getPlayer() == null || evt.getMultiPlayerGameMode() == null) {
                return;
            }
            Objects.requireNonNull(evt.getConnection(), "connection is null");
            callback.onLoggedOut(evt.getPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientPlayerEvents.Copy.class, ClientPlayerNetworkEvent.Clone.class, (callback, evt) -> callback.onCopy(evt.getOldPlayer(), evt.getNewPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection()));
    }

    private static <T, E extends ScreenEvent> void registerScreenEvent(Class<T> clazz, Class<E> event, BiConsumer<T, E> converter) {
        ForgeEventInvokerRegistryImpl.INSTANCE.register(clazz, event, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            if (!((Class)context).isInstance(evt.getScreen())) {
                return;
            }
            converter.accept(callback, evt);
        });
    }
}

