/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.init;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.client.init.v1.ItemModelOverrides;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemModelOverridesImpl
implements ItemModelOverrides {
    private static final Map<Item, ItemModelData> ITEM_MODEL_PROVIDERS = Maps.newIdentityHashMap();

    public static Optional<BakedModel> getSpecificModelOverride(ItemModelShaper itemModelShaper, ItemStack stack, ItemDisplayContext transformType) {
        return ItemModelOverridesImpl.getModelOverride(itemModelShaper, stack, (Level)Minecraft.m_91087_().f_91073_, null, 0, data -> data.getModelLocationByType(transformType));
    }

    public static Optional<BakedModel> getGenericModelOverride(ItemModelShaper itemModelShaper, ItemStack stack, @Nullable Level level, @Nullable LivingEntity livingEntity, int seed) {
        return ItemModelOverridesImpl.getModelOverride(itemModelShaper, stack, level, livingEntity, seed, ItemModelData::customModel);
    }

    public static Optional<BakedModel> getModelOverride(ItemModelShaper itemModelShaper, ItemStack stack, @Nullable Level level, @Nullable LivingEntity livingEntity, int seed, Function<ItemModelData, ModelResourceLocation> modelGetter) {
        return ItemModelOverridesImpl.getItemModelData(stack).map(modelGetter).map(arg_0 -> ((ModelManager)itemModelShaper.m_109393_()).m_119422_(arg_0)).map(model -> ItemModelOverridesImpl.resolveVanillaModelOverrides(model, itemModelShaper, stack, level, livingEntity, seed));
    }

    private static Optional<ItemModelData> getItemModelData(ItemStack stack) {
        if (stack.m_41619_()) {
            return Optional.empty();
        }
        return Optional.ofNullable(ITEM_MODEL_PROVIDERS.get(stack.m_41720_()));
    }

    private static BakedModel resolveVanillaModelOverrides(BakedModel bakedModel, ItemModelShaper itemModelShaper, ItemStack itemStack, @Nullable Level level, @Nullable LivingEntity livingEntity, int seed) {
        ClientLevel clientLevel = level instanceof ClientLevel ? (ClientLevel)level : null;
        BakedModel modelOverride = bakedModel.m_7343_().m_173464_(bakedModel, itemStack, clientLevel, livingEntity, seed);
        return modelOverride == null ? itemModelShaper.m_109393_().m_119409_() : modelOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Item item, ModelResourceLocation itemModel, ModelResourceLocation customModel, ItemDisplayContext ... itemModelTransforms) {
        Class<ItemModelOverridesImpl> clazz = ItemModelOverridesImpl.class;
        synchronized (ItemModelOverridesImpl.class) {
            if (ITEM_MODEL_PROVIDERS.put(item, new ItemModelData(itemModel, customModel, (Set<ItemDisplayContext>)ImmutableSet.copyOf((Object[])itemModelTransforms))) != null) {
                throw new IllegalStateException("Duplicate custom item model provider registered for item %s".formatted(BuiltInRegistries.f_257033_.m_7981_((Object)item)));
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private record ItemModelData(ModelResourceLocation itemModel, ModelResourceLocation customModel, Set<ItemDisplayContext> itemModelTransforms) {
        @Nullable
        public ModelResourceLocation getModelLocationByType(ItemDisplayContext transformType) {
            return this.itemModelTransforms.contains(transformType) ? this.itemModel : null;
        }
    }
}

