/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.init;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.init.v2.RegistryManager;
import fuzs.puzzleslib.api.init.v2.RegistryReference;
import fuzs.puzzleslib.api.init.v2.builder.ExtendedMenuSupplier;
import fuzs.puzzleslib.api.init.v2.builder.PoiTypeBuilder;
import fuzs.puzzleslib.impl.init.ForgeRegistryReference;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ForgeRegistryManager
implements RegistryManager {
    private final String namespace;
    private final IEventBus eventBus;
    private final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> deferredRegisters = Maps.newIdentityHashMap();
    @Nullable
    private Set<ModLoader> allowedModLoaders;

    public ForgeRegistryManager(String modId) {
        this.namespace = modId;
        this.eventBus = ModContainerHelper.findModEventBus(modId).orElseThrow();
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public RegistryManager whenOn(ModLoader ... allowedModLoaders) {
        if (allowedModLoaders.length == 0) {
            throw new IllegalArgumentException("Must provide at least one mod loader to register on");
        }
        this.allowedModLoaders = ImmutableSet.copyOf((Object[])allowedModLoaders);
        return this;
    }

    @Override
    public <T> RegistryReference<T> register(ResourceKey<? extends Registry<? super T>> registryKey, String path, Supplier<T> supplier) {
        Set<ModLoader> modLoaders = this.allowedModLoaders;
        this.allowedModLoaders = null;
        if (modLoaders != null && !modLoaders.contains((Object)ModLoader.FORGE)) {
            return this.placeholder(registryKey, path);
        }
        DeferredRegister register = this.deferredRegisters.computeIfAbsent(registryKey, key -> {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registryKey, (String)this.namespace);
            deferredRegister.register(this.eventBus);
            return deferredRegister;
        });
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        RegistryObject registryObject = register.register(path, supplier);
        return new ForgeRegistryReference(registryObject, registryKey);
    }

    @Override
    public RegistryReference<Item> registerSpawnEggItem(RegistryReference<? extends EntityType<? extends Mob>> entityTypeReference, int backgroundColor, int highlightColor, Item.Properties itemProperties) {
        return this.registerItem(entityTypeReference.getResourceLocation().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(entityTypeReference::get, backgroundColor, highlightColor, itemProperties));
    }

    @Override
    public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerExtendedMenuType(String path, Supplier<ExtendedMenuSupplier<T>> entry) {
        return this.register(Registries.f_256798_, path, () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)(arg_0, arg_1, arg_2) -> ForgeRegistryManager.lambda$registerExtendedMenuType$2((Supplier)entry, arg_0, arg_1, arg_2)), FeatureFlags.f_244377_));
    }

    @Override
    public RegistryReference<PoiType> registerPoiTypeBuilder(String path, Supplier<PoiTypeBuilder> entry) {
        return this.register(Registries.f_256805_, path, () -> {
            PoiTypeBuilder builder = (PoiTypeBuilder)entry.get();
            return new PoiType((Set)ImmutableSet.copyOf(builder.blocks()), builder.ticketCount(), builder.searchDistance());
        });
    }

    private static /* synthetic */ AbstractContainerMenu lambda$registerExtendedMenuType$2(Supplier entry, int containerId, Inventory inventory, FriendlyByteBuf data) {
        return ((ExtendedMenuSupplier)entry.get()).create(containerId, inventory, data);
    }
}

