/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.markdown.MarkdownComponentRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class BookPageRenderer<T extends BookPage> {
    public int left;
    public int top;
    protected T page;
    protected BookContentScreen parentScreen;
    protected Minecraft mc;
    protected Font font;
    private List<Button> buttons = new ArrayList<Button>();

    public BookPageRenderer(T page) {
        this.page = page;
    }

    public void onBeginDisplayPage(BookContentScreen parentScreen, int left, int top) {
        this.parentScreen = parentScreen;
        this.mc = parentScreen.getMinecraft();
        this.font = this.mc.f_91062_;
        this.left = left;
        this.top = top;
        this.buttons = new ArrayList<Button>();
    }

    public T getPage() {
        return this.page;
    }

    public void onEndDisplayPage(BookContentScreen parentScreen) {
        parentScreen.removeRenderableWidgets(this.buttons);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    public void renderBookTextHolder(BookTextHolder text, PoseStack poseStack, int x, int y, int width) {
        width += this.parentScreen.getBook().getBookTextOffsetWidth();
        BookPageRenderer.renderBookTextHolder(text, this.font, poseStack, x += this.parentScreen.getBook().getBookTextOffsetX(), y += this.parentScreen.getBook().getBookTextOffsetY(), width -= this.parentScreen.getBook().getBookTextOffsetX());
    }

    public static void renderBookTextHolder(BookTextHolder text, Font font, PoseStack poseStack, int x, int y, int width) {
        if (text.hasComponent()) {
            for (FormattedCharSequence formattedcharsequence : font.m_92923_((FormattedText)text.getComponent(), width)) {
                font.m_92877_(poseStack, formattedcharsequence, (float)x, (float)y, 0);
                Objects.requireNonNull(font);
                y += 9;
            }
        } else if (text instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            List<MutableComponent> components = renderedText.getRenderedText();
            for (MutableComponent component : components) {
                List<FormattedCharSequence> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, width, width - 10, font);
                for (FormattedCharSequence formattedcharsequence : wrapped) {
                    font.m_92877_(poseStack, formattedcharsequence, (float)x, (float)y, 0);
                    Objects.requireNonNull(font);
                    y += 9;
                }
            }
        } else {
            Modonomicon.LOGGER.warn("BookTextHolder with String {} has no component, but is not rendered to markdown either.", (Object)text.getString());
        }
    }

    public void renderTitle(BookTextHolder title, boolean showTitleSeparator, PoseStack poseStack, int x, int y) {
        poseStack.m_85836_();
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.m_13744_(renderedTitle.getRenderedText().stream().map(Component::m_7532_).toList());
            float scale = Math.min(1.0f, 120.0f / (float)this.font.m_92724_(formattedCharSequence));
            if (scale < 1.0f) {
                poseStack.m_252880_(0.0f, (float)y - (float)y * scale, 0.0f);
                poseStack.m_85841_(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(poseStack, formattedCharSequence, x, y, 0, scale);
        } else {
            float scale = Math.min(1.0f, 120.0f / (float)this.font.m_92724_(title.getComponent().m_7532_()));
            if (scale < 1.0f) {
                poseStack.m_252880_(0.0f, (float)y - (float)y * scale, 0.0f);
                poseStack.m_85841_(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(poseStack, title.getComponent().m_7532_(), x, y, 0, scale);
        }
        poseStack.m_85849_();
        if (showTitleSeparator) {
            BookContentScreen.drawTitleSeparator(poseStack, ((BookPage)this.page).getBook(), x, y + 12);
        }
    }

    public abstract void render(PoseStack var1, int var2, int var3, float var4);

    public void drawCenteredStringNoShadow(PoseStack poseStack, FormattedCharSequence s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.m_92724_(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        this.font.m_92877_(poseStack, s, f, f2 + 9.0f * (1.0f - scale), color);
    }

    public void drawCenteredStringNoShadow(PoseStack poseStack, String s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.m_92895_(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        this.font.m_92883_(poseStack, s, f, f2 + 9.0f * (1.0f - scale), color);
    }

    public void drawWrappedStringNoShadow(PoseStack poseStack, Component s, int x, int y, int color, int width) {
        for (FormattedCharSequence formattedcharsequence : this.font.m_92923_((FormattedText)s, width)) {
            float f = x;
            Objects.requireNonNull(this.font);
            this.font.m_92877_(poseStack, formattedcharsequence, f, (float)(y + 9), color);
            Objects.requireNonNull(this.font);
            y += 9;
        }
    }

    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        return null;
    }

    protected void addButton(Button button) {
        button.m_252865_(button.m_252754_() + this.parentScreen.getBookLeft() + this.left);
        button.m_253211_(button.m_252907_() + this.parentScreen.getBookTop() + this.top);
        this.buttons.add(button);
        this.parentScreen.m_142416_(button);
    }

    @Nullable
    protected Style getClickedComponentStyleAtForTitle(BookTextHolder title, int x, int y, double pMouseX, double pMouseY) {
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.m_13744_(renderedTitle.getRenderedText().stream().map(Component::m_7532_).toList());
            if (pMouseY > (double)y) {
                Objects.requireNonNull(this.font);
                if (pMouseY < (double)(y + 9)) {
                    if (pMouseX < (double)(x -= this.font.m_92724_(formattedCharSequence) / 2)) {
                        return null;
                    }
                    return this.font.m_92865_().m_92338_(formattedCharSequence, (int)pMouseX - x);
                }
            }
        } else if (pMouseY > (double)y) {
            Objects.requireNonNull(this.font);
            if (pMouseY < (double)(y + 9)) {
                FormattedCharSequence formattedCharSequence = title.getComponent().m_7532_();
                if (pMouseX < (double)(x -= this.font.m_92724_(formattedCharSequence) / 2)) {
                    return null;
                }
                return this.font.m_92865_().m_92338_(formattedCharSequence, (int)pMouseX - x);
            }
        }
        return null;
    }

    @Nullable
    protected Style getClickedComponentStyleAtForTextHolder(BookTextHolder text, int x, int y, int width, double pMouseX, double pMouseY) {
        block8: {
            block7: {
                if (!text.hasComponent()) break block7;
                for (FormattedCharSequence formattedcharsequence : this.font.m_92923_((FormattedText)text.getComponent(), width)) {
                    if (pMouseY > (double)y) {
                        Objects.requireNonNull(this.font);
                        if (pMouseY < (double)(y + 9)) {
                            return this.font.m_92865_().m_92338_(formattedcharsequence, (int)pMouseX - x);
                        }
                    }
                    Objects.requireNonNull(this.font);
                    y += 9;
                }
                break block8;
            }
            if (!(text instanceof RenderedBookTextHolder)) break block8;
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            List<MutableComponent> components = renderedText.getRenderedText();
            for (MutableComponent component : components) {
                List<FormattedCharSequence> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, width, width - 10, this.font);
                for (FormattedCharSequence formattedcharsequence : wrapped) {
                    if (pMouseY > (double)y) {
                        Objects.requireNonNull(this.font);
                        if (pMouseY < (double)(y + 9)) {
                            return this.font.m_92865_().m_92338_(formattedcharsequence, (int)pMouseX - x);
                        }
                    }
                    Objects.requireNonNull(this.font);
                    y += 9;
                }
            }
        }
        return null;
    }
}

