/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.network.messages;

import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.network.Message;
import com.klikli_dev.modonomicon.registry.CapabilityRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class BookEntryReadMessage
implements Message {
    public ResourceLocation bookId;
    public ResourceLocation entryId;

    public BookEntryReadMessage(ResourceLocation bookId, ResourceLocation entryId) {
        this.bookId = bookId;
        this.entryId = entryId;
    }

    public BookEntryReadMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.bookId);
        buf.m_130085_(this.entryId);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.bookId = buf.m_130281_();
        this.entryId = buf.m_130281_();
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        player.getCapability(CapabilityRegistry.BOOK_UNLOCK).ifPresent(capability -> {
            BookEntry entry = BookDataManager.get().getBook(this.bookId).getEntry(this.entryId);
            if (capability.read(entry)) {
                capability.update(player);
                capability.sync(player);
            }
        });
    }
}

