/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.network.messages;

import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.capability.BookStateCapability;
import com.klikli_dev.modonomicon.capability.bookstate.CategoryState;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.network.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SaveCategoryStateMessage
implements Message {
    public BookCategory category;
    public float scrollX = 0.0f;
    public float scrollY = 0.0f;
    public float targetZoom;
    public ResourceLocation openEntry = null;

    public SaveCategoryStateMessage(BookCategory category, float scrollX, float scrollY, float targetZoom, ResourceLocation openEntry) {
        this.category = category;
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        this.targetZoom = targetZoom;
        this.openEntry = openEntry;
    }

    public SaveCategoryStateMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.category.getBook().getId());
        buf.m_130085_(this.category.getId());
        buf.writeFloat(this.scrollX);
        buf.writeFloat(this.scrollY);
        buf.writeFloat(this.targetZoom);
        buf.writeBoolean(this.openEntry != null);
        if (this.openEntry != null) {
            buf.m_130085_(this.openEntry);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.category = BookDataManager.get().getBook(buf.m_130281_()).getCategory(buf.m_130281_());
        this.scrollX = buf.readFloat();
        this.scrollY = buf.readFloat();
        this.targetZoom = buf.readFloat();
        if (buf.readBoolean()) {
            this.openEntry = buf.m_130281_();
        }
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        CategoryState currentState = BookStateCapability.getCategoryStateFor((Player)player, this.category);
        currentState.scrollX = this.scrollX;
        currentState.scrollY = this.scrollY;
        currentState.targetZoom = this.targetZoom;
        currentState.openEntry = this.openEntry;
        BookStateCapability.setCategoryStateFor((Player)player, this.category, currentState);
        BookStateCapability.syncFor(player);
    }
}

