/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeLevel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.inventory.EnhancerSlot;
import com.stal111.forbidden_arcanus.common.inventory.HephaestusForgeMenu;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;

public class HephaestusForgeScreen
extends AbstractContainerScreen<HephaestusForgeMenu> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("forbidden_arcanus", "textures/gui/container/hephaestus_forge.png");
    public static final List<EssenceBarDefinition> ESSENCE_BAR_DEFINITIONS = ImmutableList.of((Object)new EssenceBarDefinition(EssenceType.AUREAL, 0, 12, 177), (Object)new EssenceBarDefinition(EssenceType.SOULS, 1, 24, 183), (Object)new EssenceBarDefinition(EssenceType.BLOOD, 2, 148, 189), (Object)new EssenceBarDefinition(EssenceType.EXPERIENCE, 3, 160, 195));

    public HephaestusForgeScreen(HephaestusForgeMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97729_ -= 2;
        this.f_97731_ += 2;
    }

    protected void m_181908_() {
        super.m_181908_();
        for (int i = 0; i < ((HephaestusForgeMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((HephaestusForgeMenu)this.f_97732_).f_38839_.get(i);
            if (!(slot instanceof EnhancerSlot)) continue;
            EnhancerSlot enhancerSlot = (EnhancerSlot)slot;
            enhancerSlot.updateLocked(((HephaestusForgeMenu)this.f_97732_).getLevel());
        }
    }

    public void m_86412_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        for (int i = 0; i < ((HephaestusForgeMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((HephaestusForgeMenu)this.f_97732_).f_38839_.get(i);
            if (!(slot instanceof EnhancerSlot)) continue;
            int posX = mouseX - this.f_97735_;
            int posY = mouseY - this.f_97736_;
            if (posX < slot.f_40220_ - 1 || posX >= slot.f_40220_ + 16 + 1 || posY < slot.f_40221_ - 1 || posY >= slot.f_40221_ + 16 + 1) continue;
            this.f_97734_ = slot;
        }
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(@Nonnull PoseStack poseStack, float partialTicks, int x, int y) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        HephaestusForgeScreen.m_93228_((PoseStack)poseStack, (int)this.getGuiLeft(), (int)this.getGuiTop(), (int)0, (int)0, (int)this.getXSize(), (int)this.getYSize());
        HephaestusForgeScreen.m_93228_((PoseStack)poseStack, (int)(this.getGuiLeft() - 26), (int)(this.getGuiTop() + 16), (int)176, (int)61, (int)29, (int)51);
        HephaestusForgeScreen.m_93228_((PoseStack)poseStack, (int)(this.getGuiLeft() + 172), (int)(this.getGuiTop() + 16), (int)206, (int)61, (int)29, (int)51);
        for (Slot slotItemHandler : ((HephaestusForgeMenu)this.f_97732_).f_38839_) {
            if (!(slotItemHandler instanceof EnhancerSlot)) continue;
            EnhancerSlot enhancerSlot = (EnhancerSlot)slotItemHandler;
            this.renderEnhancerSlot(enhancerSlot, poseStack, this.getGuiLeft(), this.getGuiTop());
        }
        HephaestusForgeLevel level = ((HephaestusForgeMenu)this.f_97732_).getLevel();
        for (EssenceBarDefinition definition : ESSENCE_BAR_DEFINITIONS) {
            this.renderBar(poseStack, definition, definition.getMaxAmount(level));
        }
    }

    protected void m_7025_(@Nonnull PoseStack poseStack, int x, int y) {
        EnhancerSlot enhancerSlot;
        super.m_7025_(poseStack, x, y);
        int posX = x - this.getGuiLeft();
        int posY = y - this.getGuiTop();
        this.renderBarsTooltip(poseStack, posX, posY, x, y);
        Slot slot = this.getSlotUnderMouse();
        if (slot instanceof EnhancerSlot && ((HephaestusForgeMenu)this.f_97732_).isSlotLocked(enhancerSlot = (EnhancerSlot)slot)) {
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.forbidden_arcanus.hephaestus_forge.unlocked_at").m_130946_(": " + enhancerSlot.getAdditionalData()), x, y);
        }
    }

    private void renderBarsTooltip(PoseStack poseStack, int x, int y, int screenX, int screenY) {
        if (y < 19 || y > 68) {
            return;
        }
        ContainerData data = ((HephaestusForgeMenu)this.f_97732_).getHephaestusForgeData();
        HephaestusForgeLevel level = ((HephaestusForgeMenu)this.f_97732_).getLevel();
        for (EssenceBarDefinition definition : ESSENCE_BAR_DEFINITIONS) {
            if (x < definition.x() - 2 || x > definition.x() + 5) continue;
            this.m_96602_(poseStack, (Component)definition.buildComponent(data, level), screenX, screenY);
            break;
        }
    }

    private void renderBar(PoseStack matrixStack, EssenceBarDefinition definition, int max) {
        int ySize = Math.toIntExact(Math.round(32.0f * (float)((HephaestusForgeMenu)this.f_97732_).getHephaestusForgeData().m_6413_(definition.dataKey()) / (float)max));
        HephaestusForgeScreen.m_93228_((PoseStack)matrixStack, (int)(this.getGuiLeft() + definition.x()), (int)(this.getGuiTop() + 22 + 32 - ySize), (int)definition.textureX(), (int)(35 - ySize), (int)4, (int)ySize);
    }

    public void renderEnhancerSlot(EnhancerSlot slot, PoseStack poseStack, int guiLeft, int guiTop) {
        if (((HephaestusForgeMenu)this.f_97732_).isSlotLocked(slot)) {
            HephaestusForgeScreen.m_93228_((PoseStack)poseStack, (int)(guiLeft + slot.f_40220_ - 2), (int)(guiTop + slot.f_40221_ - 2), (int)176, (int)40, (int)20, (int)20);
        }
    }

    private record EssenceBarDefinition(EssenceType type, int dataKey, int x, int textureX) {
        public int getMaxAmount(HephaestusForgeLevel level) {
            return level.getMaxAmount(this.type);
        }

        public MutableComponent buildComponent(ContainerData data, HephaestusForgeLevel level) {
            return this.type.getComponent().m_6881_().m_130946_(": " + data.m_6413_(this.dataKey) + "/" + this.getMaxAmount(level));
        }
    }
}

