/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.forge.MagicCircle;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesDefinition;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualInput;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualRequirements;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.result.RitualResult;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.util.AdditionalCodecs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public record Ritual(List<RitualInput> inputs, Ingredient mainIngredient, RitualResult result, EssencesDefinition essences, @Nullable RitualRequirements requirements, MagicCircle.Config magicCircleConfig) implements MagicCircle.TextureProvider
{
    public static final Codec<Ritual> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RitualInput.CODEC.listOf().fieldOf("inputs").forGetter(ritual -> ritual.inputs), (App)AdditionalCodecs.INGREDIENT.fieldOf("main_ingredient").forGetter(ritual -> ritual.mainIngredient), (App)RitualResult.DIRECT_CODEC.fieldOf("result").forGetter(ritual -> ritual.result), (App)EssencesDefinition.CODEC.fieldOf("essences").forGetter(ritual -> ritual.essences), (App)RitualRequirements.CODEC.optionalFieldOf("additional_requirements").forGetter(ritual -> Optional.ofNullable(ritual.requirements)), (App)MagicCircle.Config.CODEC.optionalFieldOf("magic_circle").forGetter(ritual -> Optional.ofNullable(ritual.magicCircleConfig.equals(MagicCircle.Config.DEFAULT) ? null : ritual.magicCircleConfig))).apply((Applicative)instance, (inputs, mainIngredient, result, essences, requirements, magicCircleConfig) -> new Ritual((List<RitualInput>)inputs, (Ingredient)mainIngredient, (RitualResult)result, (EssencesDefinition)essences, requirements.orElse(null), magicCircleConfig.orElse(MagicCircle.Config.DEFAULT))));
    public static final Codec<Ritual> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RitualInput.CODEC.listOf().fieldOf("inputs").forGetter(ritual -> ritual.inputs), (App)AdditionalCodecs.INGREDIENT.fieldOf("main_ingredient").forGetter(ritual -> ritual.mainIngredient), (App)RitualResult.DIRECT_CODEC.fieldOf("result").forGetter(ritual -> ritual.result), (App)EssencesDefinition.CODEC.fieldOf("essences").forGetter(ritual -> ritual.essences), (App)RitualRequirements.CODEC.optionalFieldOf("additional_requirements").forGetter(ritual -> Optional.ofNullable(ritual.requirements))).apply((Applicative)instance, (inputs, mainIngredient, result, essences, requirements) -> new Ritual((List<RitualInput>)inputs, (Ingredient)mainIngredient, (RitualResult)result, (EssencesDefinition)essences, requirements.orElse(null), null)));

    public boolean canStart(RitualStartContext context) {
        if (this.requirements != null && !this.requirements.checkRequirements(context.forgeTier(), context.enhancers())) {
            return false;
        }
        ItemStack mainIngredient = context.mainIngredient();
        return this.checkIngredients(context.inputs(), mainIngredient) && this.result().checkConditions(mainIngredient, context.level(), context.pos());
    }

    public boolean checkIngredients(Collection<ItemStack> list, ItemStack mainIngredient) {
        if (!this.mainIngredient().test(mainIngredient)) {
            return false;
        }
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(list);
        block0: for (RitualInput input : this.inputs()) {
            int amount = 0;
            Iterator iterator = ingredients.iterator();
            while (iterator.hasNext()) {
                if (!input.ingredient().test((ItemStack)iterator.next())) continue;
                iterator.remove();
                if (++amount != input.amount()) continue;
                continue block0;
            }
            return false;
        }
        return ingredients.isEmpty();
    }

    @Override
    public ResourceLocation getInnerTexture() {
        return this.magicCircleConfig.innerTexture();
    }

    @Override
    public ResourceLocation getOuterTexture() {
        return this.magicCircleConfig.outerTexture();
    }

    protected record RitualStartContext(Level level, BlockPos pos, int forgeTier, Collection<ItemStack> inputs, ItemStack mainIngredient, List<EnhancerDefinition> enhancers) {
        public static RitualStartContext of(Level level, BlockPos pos, int forgeTier, Collection<ItemStack> inputs, ItemStack mainIngredient, List<EnhancerDefinition> enhancers) {
            return new RitualStartContext(level, pos, forgeTier, inputs, mainIngredient, enhancers);
        }
    }

    public static enum PedestalType {
        DARKSTONE_PEDESTAL(ModBlocks.DARKSTONE_PEDESTAL.get()),
        MAGNETIZED_DARKSTONE_PEDESTAL(ModBlocks.MAGNETIZED_DARKSTONE_PEDESTAL.get());

        private final Block block;

        private PedestalType(Block block) {
            this.block = block;
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

