/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.event;

import com.stal111.forbidden_arcanus.common.block.entity.clibano.ResiduesStorage;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerCache;
import com.stal111.forbidden_arcanus.common.item.modifier.ItemModifier;
import com.stal111.forbidden_arcanus.common.loader.HephaestusForgeInputLoader;
import com.stal111.forbidden_arcanus.common.network.NetworkHandler;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateForgeInputsPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateResidueTypesPacket;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DatapackEvents {
    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new HephaestusForgeInputLoader());
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            DatapackEvents.syncData(event.getPlayer());
        } else {
            event.getPlayerList().m_11314_().forEach(DatapackEvents::syncData);
        }
    }

    private static void syncData(ServerPlayer player) {
        NetworkHandler.sendTo((Player)player, new UpdateForgeInputsPacket(HephaestusForgeInputLoader.inputs));
        NetworkHandler.sendTo((Player)player, new UpdateResidueTypesPacket(ResiduesStorage.RESIDUE_TYPES));
    }

    @SubscribeEvent
    public static void onTagsUpdate(TagsUpdatedEvent event) {
        FARegistries.ITEM_MODIFIER_REGISTRY.get().getValues().forEach(ItemModifier::clearCachedValidItems);
        EnhancerCache.cacheEnhancers(event.getRegistryAccess());
    }
}

