/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.inventory;

import com.google.common.collect.ImmutableList;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeLevel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.inventory.EnhancerSlot;
import com.stal111.forbidden_arcanus.common.inventory.InputSlot;
import com.stal111.forbidden_arcanus.common.inventory.MainSlot;
import com.stal111.forbidden_arcanus.common.inventory.input.HephaestusForgeInputs;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerCache;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.other.ModContainers;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.valhelsia.valhelsia_core.common.block.entity.MenuCreationContext;
import org.apache.commons.lang3.BooleanUtils;

public class HephaestusForgeMenu
extends AbstractContainerMenu {
    public static final List<Integer> ENHANCERS_SLOTS = ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3);
    private final ContainerData hephaestusForgeData;
    private final ContainerLevelAccess levelAccess;
    private final DataSlot hephaestusForgeLevel = DataSlot.m_39401_();
    private final int[] lockedSlots = new int[4];

    public HephaestusForgeMenu(int id, Inventory inventory, FriendlyByteBuf buffer) {
        this(id, new ItemStackHandler(9), (ContainerData)new SimpleContainerData(4), (MenuCreationContext<HephaestusForgeBlockEntity>)MenuCreationContext.of((Inventory)inventory, (BlockPos)buffer.m_130135_()));
    }

    public HephaestusForgeMenu(int id, ItemStackHandler handler, ContainerData containerData, MenuCreationContext<HephaestusForgeBlockEntity> creationContext) {
        super((MenuType)ModContainers.HEPHAESTUS_FORGE.get(), id);
        this.levelAccess = creationContext.levelAccess();
        this.hephaestusForgeData = containerData;
        HephaestusForgeMenu.m_38886_((ContainerData)this.hephaestusForgeData, (int)4);
        this.m_38884_(this.hephaestusForgeData);
        this.m_38895_(this.hephaestusForgeLevel);
        this.m_38895_(DataSlot.m_39406_((int[])this.lockedSlots, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.lockedSlots, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.lockedSlots, (int)2));
        this.m_38895_(DataSlot.m_39406_((int[])this.lockedSlots, (int)3));
        HephaestusForgeLevel level = this.updateLevel();
        this.hephaestusForgeLevel.m_6422_(level.getAsInt());
        this.addEnhancerSlot(handler, 0, 36, 24, HephaestusForgeLevel.ONE, level);
        this.addEnhancerSlot(handler, 1, 36, 46, HephaestusForgeLevel.TWO, level);
        this.addEnhancerSlot(handler, 2, 124, 24, HephaestusForgeLevel.THREE, level);
        this.addEnhancerSlot(handler, 3, 124, 46, HephaestusForgeLevel.FOUR, level);
        this.m_38897_((Slot)new MainSlot((IItemHandler)handler, 4, 80, 24));
        this.m_38897_((Slot)new InputSlot((IItemHandler)handler, 5, -18, 25, EssenceType.AUREAL));
        this.m_38897_((Slot)new InputSlot((IItemHandler)handler, 6, -18, 43, EssenceType.SOULS));
        this.m_38897_((Slot)new InputSlot((IItemHandler)handler, 7, 178, 25, EssenceType.BLOOD));
        this.m_38897_((Slot)new InputSlot((IItemHandler)handler, 8, 178, 43, EssenceType.EXPERIENCE));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_((Slot)new SlotItemHandler(creationContext.playerInventory(), j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_((Slot)new SlotItemHandler(creationContext.playerInventory(), k, 8 + k * 18, 142));
        }
    }

    private void addEnhancerSlot(ItemStackHandler handler, int index, int x, int y, HephaestusForgeLevel requiredLevel, HephaestusForgeLevel currentLevel) {
        this.m_38897_((Slot)new EnhancerSlot((IItemHandler)handler, index, x, y, requiredLevel, locked -> {
            this.lockedSlots[index] = BooleanUtils.toInteger((boolean)locked);
        }).updateLocked(currentLevel));
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return result;
        }
        ItemStack stack = slot.m_7993_();
        result = stack.m_41777_();
        if (index <= 4) {
            if (!this.m_38903_(stack, 5, 41, true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stack, result);
        } else if (index <= 8 ? !this.m_38903_(stack, 9, 41, true) : (this.canInput(EssenceType.AUREAL, stack) ? !this.m_38903_(stack, 5, 6, false) : (this.canInput(EssenceType.SOULS, stack) ? !this.m_38903_(stack, 6, 7, false) : (this.canInput(EssenceType.BLOOD, stack) ? !this.m_38903_(stack, 7, 8, false) : (this.canInput(EssenceType.EXPERIENCE, stack) ? !this.m_38903_(stack, 8, 9, false) : (EnhancerCache.get(stack.m_41720_()).isPresent() ? !this.m_38903_(stack, 0, this.getHighestUnlockedEnhancerSlot() + 1, false) : (!this.m_38853_(4).m_6657_() ? !this.m_38903_(stack, 4, 5, false) : (index < 36 ? !this.m_38903_(stack, 36, 45, false) : index < 45 && !this.m_38903_(stack, 9, 36, false))))))))) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return result;
    }

    public boolean canInput(EssenceType type, ItemStack stack) {
        return !HephaestusForgeInputs.getInputs().stream().filter(hephaestusForgeInput -> hephaestusForgeInput.canInput(type, stack)).toList().isEmpty();
    }

    public boolean m_6875_(@Nonnull Player player) {
        return HephaestusForgeMenu.m_38889_((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)ModBlocks.HEPHAESTUS_FORGE.get());
    }

    public ContainerData getHephaestusForgeData() {
        return this.hephaestusForgeData;
    }

    private HephaestusForgeLevel updateLevel() {
        return (HephaestusForgeLevel)this.levelAccess.m_39299_((level, pos) -> HephaestusForgeLevel.getFromIndex((Integer)level.m_8055_(pos).m_61143_((Property)ModBlockStateProperties.TIER)), (Object)HephaestusForgeLevel.ONE);
    }

    public HephaestusForgeLevel getLevel() {
        return HephaestusForgeLevel.getFromIndex(this.hephaestusForgeLevel.m_6501_());
    }

    public boolean isSlotLocked(EnhancerSlot slot) {
        return this.lockedSlots[slot.getSlotIndex()] == 1;
    }

    private int getHighestUnlockedEnhancerSlot() {
        for (int i : ENHANCERS_SLOTS) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (this.lockedSlots[slot.getSlotIndex()] != 1) continue;
            return i;
        }
        return 3;
    }
}

