/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.network;

import com.stal111.forbidden_arcanus.common.aureal.AurealHelper;
import com.stal111.forbidden_arcanus.common.block.entity.PedestalBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.MagicCircle;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.network.clientbound.AddItemParticlePacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.AddThrownAurealBottleParticle;
import com.stal111.forbidden_arcanus.common.network.clientbound.CreateMagicCirclePacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.CreateValidRitualIndicatorPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.RemoveMagicCirclePacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.RemoveValidRitualIndicatorPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.TransformPedestalPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateAurealPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateForgeRitualPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateItemInSlotPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdatePedestalPacket;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import com.stal111.forbidden_arcanus.core.mixin.LevelRendererAccessor;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import com.stal111.forbidden_arcanus.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.valhelsia.valhelsia_core.common.block.entity.ValhelsiaContainerBlockEntity;

public class ClientPacketHandler {
    public static void handleUpdateAureal(UpdateAurealPacket packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            AurealHelper.load(packet.tag(), AurealHelper.getCapability((Player)player));
        }
    }

    public static void handleUpdatePedestal(UpdatePedestalPacket packet) {
        BlockEntity blockEntity;
        ClientLevel level = ClientPacketHandler.getLevel();
        if (level != null && (blockEntity = level.m_7702_(packet.pos())) instanceof PedestalBlockEntity) {
            PedestalBlockEntity blockEntity2 = (PedestalBlockEntity)blockEntity;
            blockEntity2.setStack(packet.stack());
            blockEntity2.setItemHeight(packet.itemHeight());
        }
    }

    public static void handleTransformPedestal(TransformPedestalPacket packet) {
        ParticleUtils.m_216313_((Level)ClientPacketHandler.getLevel(), (BlockPos)packet.pos(), (ParticleOptions)((ParticleOptions)ModParticles.MAGNETIC_GLOW.get()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
        ClientPacketHandler.getLevel().m_245747_(packet.pos(), (SoundEvent)ModSounds.FERROGNETIC_MIXTURE_APPLY.get(), SoundSource.PLAYERS, 0.75f, 0.9f + ClientPacketHandler.getLevel().f_46441_.m_188501_() * 0.1f, false);
    }

    public static void handleCreateMagicCircle(CreateMagicCirclePacket packet) {
        BlockEntity blockEntity;
        ClientLevel level = ClientPacketHandler.getLevel();
        if (level == null || !((blockEntity = level.m_7702_(packet.pos())) instanceof HephaestusForgeBlockEntity)) {
            return;
        }
        HephaestusForgeBlockEntity blockEntity2 = (HephaestusForgeBlockEntity)blockEntity;
        blockEntity2.setMagicCircle(new MagicCircle((Level)level, packet.pos(), packet.innerTexture(), packet.outerTexture()));
    }

    public static void handleRemoveMagicCircle(RemoveMagicCirclePacket packet) {
        BlockEntity blockEntity;
        ClientLevel level = ClientPacketHandler.getLevel();
        if (level == null || !((blockEntity = level.m_7702_(packet.pos())) instanceof HephaestusForgeBlockEntity)) {
            return;
        }
        HephaestusForgeBlockEntity blockEntity2 = (HephaestusForgeBlockEntity)blockEntity;
        blockEntity2.removeMagicCircle();
    }

    public static void handleCreateValidRitualIndicator(CreateValidRitualIndicatorPacket packet) {
        BlockEntity blockEntity;
        ClientLevel level = ClientPacketHandler.getLevel();
        if (level == null || !((blockEntity = level.m_7702_(packet.pos())) instanceof HephaestusForgeBlockEntity)) {
            return;
        }
        HephaestusForgeBlockEntity blockEntity2 = (HephaestusForgeBlockEntity)blockEntity;
        blockEntity2.createValidRitualIndicator(true);
    }

    public static void handleRemoveValidRitualIndicator(RemoveValidRitualIndicatorPacket packet) {
        BlockEntity blockEntity;
        ClientLevel level = ClientPacketHandler.getLevel();
        if (level == null || !((blockEntity = level.m_7702_(packet.pos())) instanceof HephaestusForgeBlockEntity)) {
            return;
        }
        HephaestusForgeBlockEntity blockEntity2 = (HephaestusForgeBlockEntity)blockEntity;
        blockEntity2.removeValidRitualIndicator();
    }

    public static void handleAddItemParticle(AddItemParticlePacket packet) {
        ClientLevel level = ClientPacketHandler.getLevel();
        if (level != null) {
            RenderUtils.addItemParticles((Level)level, packet.stack(), packet.pos(), 16);
        }
    }

    public static void handleUpdateRitual(UpdateForgeRitualPacket packet) {
        BlockEntity blockEntity;
        ClientLevel level = ClientPacketHandler.getLevel();
        if (level == null || !((blockEntity = level.m_7702_(packet.pos())) instanceof HephaestusForgeBlockEntity)) {
            return;
        }
        HephaestusForgeBlockEntity blockEntity2 = (HephaestusForgeBlockEntity)blockEntity;
        blockEntity2.getRitualManager().setActiveRitual((Ritual)level.m_9598_().m_175515_(FARegistries.RITUAL).m_7745_(packet.ritual()));
    }

    public static void handleUpdateItemInSlot(UpdateItemInSlotPacket packet) {
        BlockEntity blockEntity;
        ClientLevel level = ClientPacketHandler.getLevel();
        if (level != null && (blockEntity = level.m_7702_(packet.pos())) instanceof ValhelsiaContainerBlockEntity) {
            ValhelsiaContainerBlockEntity blockEntity2 = (ValhelsiaContainerBlockEntity)blockEntity;
            blockEntity2.setStack(packet.slot(), packet.stack());
        }
    }

    public static void handleAddThrownAurealBottleParticle(AddThrownAurealBottleParticle packet) {
        ClientLevel level = ClientPacketHandler.getLevel();
        RandomSource random = level.m_213780_();
        LevelRenderer levelRenderer = ClientPacketHandler.getLevelRenderer();
        double x = packet.x();
        double y = packet.y();
        double z = packet.z();
        for (int l = 0; l < 8; ++l) {
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42736_)), x, y, z, random.m_188583_() * 0.15, random.m_188500_() * 0.2, random.m_188583_() * 0.15);
        }
        ParticleOptions particleoptions = (ParticleOptions)ModParticles.AUREAL_MOTE.get();
        for (int j3 = 0; j3 < 100; ++j3) {
            double xPos = random.m_188500_() * 4.0;
            double zPos = random.m_188500_() * Math.PI * 2.0;
            double xSpeed = Math.cos(zPos) * xPos;
            double ySpeed = ((double)random.m_188501_() - 0.4) * 0.125;
            double zSpeed = Math.sin(zPos) * xPos;
            Particle particle = ((LevelRendererAccessor)levelRenderer).callAddParticleInternal(particleoptions, particleoptions.m_6012_().m_123742_(), x + xSpeed * 0.1, y + 0.3, z + zSpeed * 0.1, xSpeed, ySpeed, zSpeed);
            particle.m_107257_(25 + random.m_188503_(10));
        }
        level.m_7785_(x, y, z, SoundEvents.f_12436_, SoundSource.NEUTRAL, 1.0f, random.m_188501_() * 0.1f + 0.9f, false);
    }

    private static ClientLevel getLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    private static LevelRenderer getLevelRenderer() {
        return Minecraft.m_91087_().f_91060_;
    }
}

