/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.stal111.forbidden_arcanus.common.item.modifier.ItemModifier;
import com.stal111.forbidden_arcanus.common.item.modifier.ModifierHelper;
import com.stal111.forbidden_arcanus.core.init.ModRecipes;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.LegacyUpgradeRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ApplyModifierRecipe
extends LegacyUpgradeRecipe {
    private final ItemModifier modifier;
    private final Ingredient addition;

    public ApplyModifierRecipe(ResourceLocation id, Ingredient addition, ItemModifier modifier) {
        super(id, Ingredient.f_43901_, addition, ItemStack.f_41583_);
        this.addition = addition;
        this.modifier = modifier;
    }

    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        if (!this.modifier.canItemContainModifier(inv.m_8020_(0))) {
            return false;
        }
        return this.addition.test(inv.m_8020_(1));
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container inv, @NotNull RegistryAccess registryAccess) {
        ItemStack stack = inv.m_8020_(0).m_41777_();
        ModifierHelper.setModifier(stack, this.modifier);
        return stack;
    }

    @Nonnull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.APPLY_MODIFIER.get();
    }

    public ItemModifier getModifier() {
        return this.modifier;
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ApplyModifierRecipe> {
        @Nonnull
        public ApplyModifierRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"modifier"));
            if (!FARegistries.ITEM_MODIFIER_REGISTRY.get().containsKey(resourceLocation)) {
                throw new JsonSyntaxException("Unknown item modifier '" + resourceLocation + "'");
            }
            ItemModifier modifier = (ItemModifier)FARegistries.ITEM_MODIFIER_REGISTRY.get().getValue(resourceLocation);
            return new ApplyModifierRecipe(recipeId, addition, modifier);
        }

        public ApplyModifierRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemModifier modifier = (ItemModifier)FARegistries.ITEM_MODIFIER_REGISTRY.get().getValue(buffer.m_130281_());
            return new ApplyModifierRecipe(recipeId, addition, modifier);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, ApplyModifierRecipe recipe) {
            recipe.addition.m_43923_(buffer);
            buffer.m_130085_(Objects.requireNonNull(FARegistries.ITEM_MODIFIER_REGISTRY.get().getKey((Object)recipe.modifier)));
        }
    }
}

