/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ResidueType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ResiduesStorage;
import com.stal111.forbidden_arcanus.core.init.ModRecipes;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ClibanoRecipe
extends AbstractCookingRecipe {
    public static final int DEFAULT_COOKING_TIME = 100;
    private final Map<ClibanoFireType, Integer> cookingTimes = new EnumMap<ClibanoFireType, Integer>(ClibanoFireType.class);
    private final ResidueInfo residueInfo;
    private final ClibanoFireType requiredFireType;

    public ClibanoRecipe(ResourceLocation id, String group, CookingBookCategory category, Ingredient ingredient, ItemStack result, float experience, int cookingTime, ResidueInfo residueInfo, ClibanoFireType requiredFireType) {
        super((RecipeType)ModRecipes.CLIBANO_COMBUSTION.get(), id, group, category, ingredient, result, experience, cookingTime);
        this.residueInfo = residueInfo;
        this.requiredFireType = requiredFireType;
        for (ClibanoFireType fireType : ClibanoFireType.values()) {
            this.cookingTimes.put(fireType, (int)((double)cookingTime / fireType.getCookingSpeedMultiplier()));
        }
    }

    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        return this.f_43729_.test(inv.m_8020_(0));
    }

    public int getCookingTime(ClibanoFireType fireType) {
        return this.cookingTimes.get((Object)fireType);
    }

    public ResidueInfo getResidueInfo() {
        return this.residueInfo;
    }

    public ClibanoFireType getRequiredFireType() {
        return this.requiredFireType;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CLIBANO_SERIALIZER.get();
    }

    public record ResidueInfo(String name, double chance) {
        public static final ResidueInfo NONE = new ResidueInfo("none", 0.0);

        public static ResidueInfo fromNetwork(@Nonnull FriendlyByteBuf buffer) {
            return new ResidueInfo(buffer.m_130277_(), buffer.readDouble());
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer) {
            buffer.m_130070_(this.name);
            buffer.writeDouble(this.chance);
        }

        public ResidueType getType() {
            return ResiduesStorage.RESIDUE_TYPES.stream().filter(residueType -> residueType.name().equals(this.name)).findFirst().orElseThrow(() -> new IllegalStateException("No ResidueType found"));
        }

        public static ResidueInfo fromJson(@Nonnull JsonObject jsonObject) {
            if (jsonObject.has("residue")) {
                JsonObject residue = jsonObject.getAsJsonObject("residue");
                return new ResidueInfo(GsonHelper.m_13906_((JsonObject)residue, (String)"name"), GsonHelper.m_144784_((JsonObject)residue, (String)"chance"));
            }
            return NONE;
        }

        public void toJson(@Nonnull JsonObject jsonObject) {
            JsonObject residue = new JsonObject();
            if (this == NONE) {
                return;
            }
            residue.addProperty("name", this.name);
            residue.addProperty("chance", (Number)this.chance);
            jsonObject.add("residue", (JsonElement)residue);
        }
    }

    public static class Serializer
    implements RecipeSerializer<ClibanoRecipe> {
        @Nonnull
        public ClibanoRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject jsonObject) {
            ItemStack stack;
            String group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            JsonArray jsonElement = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonElement);
            CookingBookCategory category = (CookingBookCategory)CookingBookCategory.f_244271_.m_262792_(GsonHelper.m_13851_((JsonObject)jsonObject, (String)"category", null), (Enum)CookingBookCategory.MISC);
            if (!jsonObject.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (jsonObject.get("result").isJsonObject()) {
                stack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            } else {
                String result = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
                stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getDelegateOrThrow(new ResourceLocation(result)).get());
            }
            float experience = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"experience", (float)0.0f);
            int cookingTime = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"cooking_time", (int)100);
            ResidueInfo residueInfo = ResidueInfo.fromJson(jsonObject);
            ResidueType residueType = new ResidueType(residueInfo.name);
            if (!ResiduesStorage.RESIDUE_TYPES.contains(residueType) && residueInfo != ResidueInfo.NONE) {
                ResiduesStorage.RESIDUE_TYPES.add(residueType);
            }
            Optional<ClibanoFireType> fireType = ClibanoFireType.byName(GsonHelper.m_13851_((JsonObject)jsonObject, (String)"fire_type", (String)"fire"));
            return new ClibanoRecipe(recipeId, group, category, ingredient, stack, experience, cookingTime, residueInfo, fireType.orElse(ClibanoFireType.FIRE));
        }

        @Nullable
        public ClibanoRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            String s = buffer.m_130277_();
            CookingBookCategory category = (CookingBookCategory)buffer.m_130066_(CookingBookCategory.class);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemstack = buffer.m_130267_();
            float f = buffer.readFloat();
            int i = buffer.m_130242_();
            Optional<ClibanoFireType> fireType = ClibanoFireType.byName(buffer.m_130277_());
            return new ClibanoRecipe(recipeId, s, category, ingredient, itemstack, f, i, ResidueInfo.fromNetwork(buffer), fireType.orElse(ClibanoFireType.FIRE));
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull ClibanoRecipe recipe) {
            buffer.m_130070_(recipe.f_43728_);
            buffer.m_130068_((Enum)recipe.m_245534_());
            recipe.f_43729_.m_43923_(buffer);
            buffer.m_130055_(recipe.f_43730_);
            buffer.writeFloat(recipe.f_43731_);
            buffer.m_130130_(recipe.f_43732_);
            buffer.m_130070_(recipe.requiredFireType.m_7912_());
            recipe.residueInfo.toNetwork(buffer);
        }
    }
}

