/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.recipe;

import com.stal111.forbidden_arcanus.common.item.CapacityBucket;
import com.stal111.forbidden_arcanus.common.item.EdelwoodBucketItem;
import com.stal111.forbidden_arcanus.common.item.EdelwoodSoupBucketItem;
import com.stal111.forbidden_arcanus.core.init.ModRecipes;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class IncreaseEdelwoodBucketFullnessRecipe
extends CustomRecipe {
    private int bucketSlot = 0;
    private int increasement = 0;

    public IncreaseEdelwoodBucketFullnessRecipe(ResourceLocation resourceLocation, CraftingBookCategory category) {
        super(resourceLocation, category);
    }

    public boolean matches(@Nonnull CraftingContainer container, @Nonnull Level level) {
        CapacityBucket capacityBucket;
        Item item;
        ItemStack stack;
        int slot;
        ItemStack bucket = ItemStack.f_41583_;
        CapacityBucket bucketCapacity = null;
        int increasement = 0;
        this.bucketSlot = 0;
        this.increasement = 0;
        for (slot = 0; slot < container.m_6643_(); ++slot) {
            stack = container.m_8020_(slot);
            item = stack.m_41720_();
            if (!(item instanceof CapacityBucket)) continue;
            capacityBucket = (CapacityBucket)item;
            bucket = stack.m_41777_();
            bucketCapacity = capacityBucket;
            this.bucketSlot = slot;
            break;
        }
        if (bucket.m_41619_()) {
            return false;
        }
        for (slot = 0; slot < container.m_6643_(); ++slot) {
            stack = container.m_8020_(slot);
            if (slot == this.bucketSlot || !this.isValidIncreasementItem(bucket, stack)) continue;
            item = stack.m_41720_();
            if (item instanceof CapacityBucket) {
                capacityBucket = (CapacityBucket)item;
                if (stack.m_150930_(bucket.m_41720_())) {
                    for (int j = 0; j < capacityBucket.getFullness(stack); ++j) {
                        ++increasement;
                    }
                    continue;
                }
            }
            ++increasement;
        }
        if (((CapacityBucket)Objects.requireNonNull(bucketCapacity)).getFullness(bucket) + increasement > bucketCapacity.getCapacity()) {
            return false;
        }
        this.increasement = increasement;
        return increasement > 0;
    }

    private boolean isValidIncreasementItem(ItemStack bucket, ItemStack increasement) {
        Item item;
        Item item2 = bucket.m_41720_();
        if (item2 instanceof EdelwoodBucketItem) {
            EdelwoodBucketItem edelwoodBucketItem = (EdelwoodBucketItem)item2;
            item2 = increasement.m_41720_();
            if (item2 instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item2;
                return edelwoodBucketItem.getFluid() == bucketItem.getFluid();
            }
        }
        if ((item = bucket.m_41720_()) instanceof EdelwoodSoupBucketItem) {
            EdelwoodSoupBucketItem soupBucketItem = (EdelwoodSoupBucketItem)item;
            return increasement.m_150930_(soupBucketItem.getSoup()) || increasement.m_150930_((Item)soupBucketItem);
        }
        return !bucket.m_41619_() && bucket.m_150930_(increasement.m_41720_());
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack stack = container.m_8020_(this.bucketSlot).m_41777_();
        Item item = stack.m_41720_();
        if (item instanceof CapacityBucket) {
            CapacityBucket capacityBucket = (CapacityBucket)item;
            return capacityBucket.setFullness(stack, capacityBucket.getFullness(stack) + this.increasement);
        }
        return stack;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer container) {
        NonNullList list = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.hasCraftingRemainingItem()) {
                list.set(i, (Object)stack.getCraftingRemainingItem());
                continue;
            }
            if (!(stack.m_41720_() instanceof BowlFoodItem)) continue;
            list.set(i, (Object)new ItemStack((ItemLike)Items.f_42399_));
        }
        list.set(this.bucketSlot, (Object)ItemStack.f_41583_);
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.EDELWOOD_BUCKET_INCREASE_FULLNESS.get();
    }
}

