/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.world.feature.trunkplacers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.ThinLogBlock;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.world.ModTrunkPlacers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CherryTrunkPlacer
extends TrunkPlacer {
    public static final Codec<CherryTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> CherryTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CherryTrunkPlacer::new));

    public CherryTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @Nonnull
    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ModTrunkPlacers.CHERRY_TRUNK_PLACER.get();
    }

    @Nonnull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@Nonnull LevelSimulatedReader level, @Nonnull BiConsumer<BlockPos, BlockState> blockSetter, @Nonnull RandomSource random, int freeTreeHeight, @Nonnull BlockPos pos, @Nonnull TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> list = new ArrayList<FoliagePlacer.FoliageAttachment>();
        ArrayList<Direction> branchDirections = new ArrayList<Direction>();
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        int height = this.m_226153_(random);
        for (int i = 0; i < height; ++i) {
            if (i > 1 && random.m_188499_() || i + 1 == height && branchDirections.isEmpty()) {
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
                if (branchDirections.contains(direction)) {
                    direction = direction.m_122424_();
                }
                if (!branchDirections.contains(direction)) {
                    branchDirections.add(direction);
                    Direction finalDirection = direction;
                    this.placeThinLog(level, blockSetter, random, (BlockPos)mutable, config, state -> {
                        BooleanProperty property = ThinLogBlock.PROPERTY_BY_DIRECTION.get(finalDirection);
                        if (state.m_61138_((Property)property)) {
                            return (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(true));
                        }
                        return state;
                    });
                    list.add(this.placeBranch(level, blockSetter, random, freeTreeHeight, mutable.m_7949_(), direction, config));
                } else {
                    this.placeThinLog(level, blockSetter, random, (BlockPos)mutable, config);
                }
            } else if (i == 0 && height >= 6) {
                this.m_226187_(level, blockSetter, random, (BlockPos)mutable, config);
            } else {
                this.placeThinLog(level, blockSetter, random, (BlockPos)mutable, config);
            }
            mutable.m_122173_(Direction.UP);
        }
        list.add(new FoliagePlacer.FoliageAttachment((BlockPos)mutable, 0, false));
        return list;
    }

    private FoliagePlacer.FoliageAttachment placeBranch(@Nonnull LevelSimulatedReader level, @Nonnull BiConsumer<BlockPos, BlockState> blockSetter, @Nonnull RandomSource random, int freeTreeHeight, @Nonnull BlockPos pos, Direction direction, @Nonnull TreeConfiguration config) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        int length = 1 + random.m_188503_(2);
        int i = 0;
        while (i < length) {
            int finalI = i++;
            this.placeThinLog(level, blockSetter, random, (BlockPos)mutable.m_122173_(direction), config, state -> (BlockState)((BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_())).m_61124_((Property)ThinLogBlock.PROPERTY_BY_DIRECTION.get(ThinLogBlock.getRotatedDirection(Direction.UP, direction.m_122434_())), (Comparable)Boolean.valueOf(finalI + 1 == length)));
        }
        boolean flag = random.m_188499_();
        this.placeThinLog(level, blockSetter, random, (BlockPos)mutable.m_122173_(Direction.UP), config, state -> (BlockState)state.m_61124_((Property)ThinLogBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(flag)));
        if (flag) {
            this.placeThinLog(level, blockSetter, random, (BlockPos)mutable.m_122173_(direction), config, state -> (BlockState)((BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_())).m_61124_((Property)ThinLogBlock.PROPERTY_BY_DIRECTION.get(ThinLogBlock.getRotatedDirection(Direction.UP, direction.m_122434_())), (Comparable)Boolean.valueOf(true)));
            this.placeThinLog(level, blockSetter, random, (BlockPos)mutable.m_122173_(Direction.UP), config);
        }
        return new FoliagePlacer.FoliageAttachment((BlockPos)mutable.m_122173_(Direction.UP), 0, false);
    }

    protected boolean placeThinLog(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        return this.placeThinLog(level, blockSetter, random, pos, config, Function.identity());
    }

    protected boolean placeThinLog(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config, Function<BlockState, BlockState> propertySetter) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            blockSetter.accept(pos, propertySetter.apply(((ThinLogBlock)ModBlocks.THIN_CHERRY_LOG.get()).m_49966_()));
            return true;
        }
        return false;
    }
}

