/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.data.client.ModBlockStateProvider;
import com.stal111.forbidden_arcanus.data.client.ModItemModelProvider;
import com.stal111.forbidden_arcanus.data.client.ModSoundsProvider;
import com.stal111.forbidden_arcanus.data.particle.ParticleDataProvider;
import com.stal111.forbidden_arcanus.data.recipes.ApplyModifierRecipeProvider;
import com.stal111.forbidden_arcanus.data.recipes.ClibanoRecipeProvider;
import com.stal111.forbidden_arcanus.data.recipes.CraftingRecipeProvider;
import com.stal111.forbidden_arcanus.data.server.loot.ModBlockLootTables;
import com.stal111.forbidden_arcanus.data.server.loot.ModLootModifierProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModBiomeTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModBlockTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModDamageTypeTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModEnchantmentTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModEntityTypeTagsProvider;
import com.stal111.forbidden_arcanus.data.server.tags.ModItemTagsProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.core.data.DataProviderInfo;
import net.valhelsia.valhelsia_core.core.registry.RegistryManager;
import net.valhelsia.valhelsia_core.data.recipes.ValhelsiaRecipeProvider;

@Mod.EventBusSubscriber(modid="forbidden_arcanus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        DataProviderInfo info = DataProviderInfo.of((GatherDataEvent)event, (RegistryManager)ForbiddenArcanus.REGISTRY_MANAGER);
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(info));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(info));
        generator.addProvider(event.includeClient(), (DataProvider)new ModSoundsProvider(info));
        generator.addProvider(event.includeServer(), (DataProvider)new ParticleDataProvider(info));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, ForbiddenArcanus.REGISTRY_MANAGER.buildRegistrySet(info), Set.of("forbidden_arcanus")));
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(info);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(info, blockTagsProvider.m_274426_()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEnchantmentTagsProvider(info));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTagsProvider(info));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(info));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeTagsProvider(info));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTables::new, LootContextParamSets.f_81421_))));
        generator.addProvider(event.includeServer(), (DataProvider)new ValhelsiaRecipeProvider(info, new Function[]{CraftingRecipeProvider::new, ClibanoRecipeProvider::new, ApplyModifierRecipeProvider::new}));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootModifierProvider(output));
    }
}

