/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.CreativeTabOutput;
import dev.architectury.registry.forge.CreativeTabRegistryImpl;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;

public final class CreativeTabRegistry {
    private CreativeTabRegistry() {
    }

    public static TabSupplier create(ResourceLocation name, Supplier<ItemStack> icon) {
        return CreativeTabRegistry.create(name, (CreativeModeTab.Builder builder) -> builder.m_257737_(icon));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static TabSupplier create(ResourceLocation name, Consumer<CreativeModeTab.Builder> callback) {
        void var1_1;
        return CreativeTabRegistryImpl.create(name, (Consumer<CreativeModeTab.Builder>)var1_1);
    }

    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static TabSupplier of(CreativeModeTab tab) {
        return CreativeTabRegistryImpl.of(tab);
    }

    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static TabSupplier defer(ResourceLocation name) {
        return CreativeTabRegistryImpl.defer(name);
    }

    @ApiStatus.Experimental
    public static void modify(CreativeModeTab tab, ModifyTabCallback filler) {
        CreativeTabRegistry.modify(CreativeTabRegistry.of(tab), filler);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static void modify(TabSupplier tab, ModifyTabCallback filler) {
        void var1_1;
        CreativeTabRegistryImpl.modify(tab, (ModifyTabCallback)var1_1);
    }

    @ApiStatus.Experimental
    public static void append(CreativeModeTab tab, ItemLike ... items) {
        CreativeTabRegistry.append(CreativeTabRegistry.of(tab), items);
    }

    @ApiStatus.Experimental
    public static <I extends ItemLike, T extends Supplier<I>> void append(CreativeModeTab tab, T ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.of(tab), Stream.of(items).map(supplier -> () -> CreativeTabRegistry.lambda$append$1((Supplier)supplier)));
    }

    @ApiStatus.Experimental
    public static void appendStack(CreativeModeTab tab, ItemStack ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.of(tab), items);
    }

    @ApiStatus.Experimental
    public static void appendStack(CreativeModeTab tab, Supplier<ItemStack> ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.of(tab), items);
    }

    @ApiStatus.Experimental
    public static void append(TabSupplier tab, ItemLike ... items) {
        CreativeTabRegistry.appendStack(tab, Stream.of(items).map(item -> () -> new ItemStack(item)));
    }

    @ApiStatus.Experimental
    public static <I extends ItemLike, T extends Supplier<I>> void append(TabSupplier tab, T ... items) {
        CreativeTabRegistry.appendStack(tab, Stream.of(items).map(supplier -> () -> CreativeTabRegistry.lambda$append$5((Supplier)supplier)));
    }

    @ApiStatus.Experimental
    public static void appendStack(TabSupplier tab, ItemStack ... items) {
        CreativeTabRegistry.appendStack(tab, Stream.of(items).map(supplier -> () -> supplier));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static void appendStack(TabSupplier tab, Supplier<ItemStack> item) {
        void var1_1;
        CreativeTabRegistryImpl.appendStack(tab, (Supplier<ItemStack>)var1_1);
    }

    @ApiStatus.Experimental
    public static void appendStack(TabSupplier tab, Supplier<ItemStack> ... items) {
        for (Supplier<ItemStack> item : items) {
            CreativeTabRegistry.appendStack(tab, item);
        }
    }

    @ApiStatus.Experimental
    public static void appendStack(TabSupplier tab, Stream<Supplier<ItemStack>> items) {
        items.forEach(item -> CreativeTabRegistry.appendStack(tab, (Supplier<ItemStack>)item));
    }

    private static /* synthetic */ ItemStack lambda$append$5(Supplier supplier) {
        return new ItemStack((ItemLike)supplier.get());
    }

    private static /* synthetic */ ItemStack lambda$append$1(Supplier supplier) {
        return new ItemStack((ItemLike)supplier.get());
    }

    @ApiStatus.NonExtendable
    public static interface TabSupplier
    extends Supplier<CreativeModeTab> {
        public ResourceLocation getName();

        public boolean isPresent();
    }

    @FunctionalInterface
    public static interface ModifyTabCallback {
        public void accept(FeatureFlagSet var1, CreativeTabOutput var2, boolean var3);
    }
}

