/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.forge;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.architectury.registry.CreativeTabOutput;
import dev.architectury.registry.CreativeTabRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="architectury", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CreativeTabRegistryImpl {
    private static final Logger LOGGER = LogManager.getLogger(CreativeTabRegistryImpl.class);
    @Nullable
    private static List<Consumer<CreativeModeTabEvent.Register>> registerListeners = new ArrayList<Consumer<CreativeModeTabEvent.Register>>();
    private static final List<Consumer<CreativeModeTabEvent.BuildContents>> BUILD_CONTENTS_LISTENERS = new ArrayList<Consumer<CreativeModeTabEvent.BuildContents>>();
    private static final Multimap<TabKey, java.util.function.Supplier<ItemStack>> APPENDS = MultimapBuilder.hashKeys().arrayListValues().build();

    @SubscribeEvent
    public static void event(CreativeModeTabEvent.Register event) {
        if (registerListeners != null) {
            for (Consumer<CreativeModeTabEvent.Register> listener : registerListeners) {
                listener.accept(event);
            }
            registerListeners = null;
        } else {
            LOGGER.warn("Creative tab listeners were already registered!");
        }
    }

    @SubscribeEvent
    public static void event(CreativeModeTabEvent.BuildContents event) {
        for (Consumer<CreativeModeTabEvent.BuildContents> listener : BUILD_CONTENTS_LISTENERS) {
            listener.accept(event);
        }
    }

    public static CreativeTabRegistry.TabSupplier create(final ResourceLocation name, Consumer<CreativeModeTab.Builder> callback) {
        if (registerListeners == null) {
            throw new IllegalStateException("Creative tab listeners were already registered!");
        }
        final CreativeModeTab[] tab = new CreativeModeTab[1];
        registerListeners.add(register -> {
            tab[0] = register.registerCreativeModeTab(name, builder -> {
                builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.%s.%s".formatted(name.m_135827_(), name.m_135815_())));
                callback.accept((CreativeModeTab.Builder)builder);
            });
        });
        return new CreativeTabRegistry.TabSupplier(){

            @Override
            public ResourceLocation getName() {
                return name;
            }

            @Override
            public CreativeModeTab get() {
                if (tab[0] == null) {
                    throw new IllegalStateException("Creative tab %s was not registered yet!".formatted(name));
                }
                return tab[0];
            }

            @Override
            public boolean isPresent() {
                return tab[0] != null;
            }
        };
    }

    @ApiStatus.Experimental
    public static CreativeTabRegistry.TabSupplier of(final CreativeModeTab tab) {
        final ResourceLocation location = CreativeModeTabRegistry.getName((CreativeModeTab)tab);
        if (location == null) {
            throw new IllegalArgumentException("Tab %s is not registered!".formatted(tab));
        }
        return new CreativeTabRegistry.TabSupplier(){

            @Override
            public ResourceLocation getName() {
                return location;
            }

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public CreativeModeTab get() {
                return tab;
            }
        };
    }

    @ApiStatus.Experimental
    public static CreativeTabRegistry.TabSupplier defer(final ResourceLocation name) {
        return new CreativeTabRegistry.TabSupplier(){

            @Override
            public ResourceLocation getName() {
                return name;
            }

            @Override
            public boolean isPresent() {
                return CreativeModeTabRegistry.getTab((ResourceLocation)name) != null;
            }

            @Override
            public CreativeModeTab get() {
                CreativeModeTab tab = CreativeModeTabRegistry.getTab((ResourceLocation)name);
                if (tab == null) {
                    throw new IllegalStateException("Creative tab %s was not registered yet!".formatted(name));
                }
                return tab;
            }
        };
    }

    public static void modify(CreativeTabRegistry.TabSupplier tab, CreativeTabRegistry.ModifyTabCallback filler) {
        BUILD_CONTENTS_LISTENERS.add(event -> {
            if (tab.isPresent()) {
                if (event.getTab().equals(tab.get())) {
                    filler.accept(event.getFlags(), CreativeTabRegistryImpl.wrapTabOutput((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries()), event.hasPermissions());
                }
            } else if (Objects.equals(CreativeModeTabRegistry.getName((CreativeModeTab)event.getTab()), tab.getName())) {
                filler.accept(event.getFlags(), CreativeTabRegistryImpl.wrapTabOutput((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries()), event.hasPermissions());
            }
        });
    }

    private static CreativeTabOutput wrapTabOutput(final MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries) {
        return new CreativeTabOutput(){

            @Override
            public void acceptAfter(ItemStack after, ItemStack stack, CreativeModeTab.TabVisibility visibility) {
                if (after.m_41619_()) {
                    entries.put((Object)stack, (Object)visibility);
                } else {
                    entries.putAfter((Object)after, (Object)stack, (Object)visibility);
                }
            }

            @Override
            public void acceptBefore(ItemStack before, ItemStack stack, CreativeModeTab.TabVisibility visibility) {
                if (before.m_41619_()) {
                    entries.put((Object)stack, (Object)visibility);
                } else {
                    entries.putBefore((Object)before, (Object)stack, (Object)visibility);
                }
            }
        };
    }

    @ApiStatus.Experimental
    public static void appendStack(CreativeTabRegistry.TabSupplier tab, java.util.function.Supplier<ItemStack> item) {
        APPENDS.put((Object)new TabKey.SupplierTabKey(tab), item);
    }

    static {
        BUILD_CONTENTS_LISTENERS.add(event -> {
            for (Map.Entry keyEntry : APPENDS.asMap().entrySet()) {
                Supplier stacks = Suppliers.memoize(() -> ((Collection)keyEntry.getValue()).stream().map(java.util.function.Supplier::get).toList());
                Object patt3021$temp = keyEntry.getKey();
                if (patt3021$temp instanceof TabKey.SupplierTabKey) {
                    TabKey.SupplierTabKey supplierTabKey = (TabKey.SupplierTabKey)patt3021$temp;
                    if (!Objects.equals(CreativeModeTabRegistry.getName((CreativeModeTab)event.getTab()), supplierTabKey.supplier().getName())) continue;
                    for (ItemStack stack : (List)stacks.get()) {
                        event.getEntries().put((Object)stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    }
                    continue;
                }
                Object patt3469$temp = keyEntry.getKey();
                if (!(patt3469$temp instanceof TabKey.DirectTabKey)) continue;
                TabKey.DirectTabKey directTabKey = (TabKey.DirectTabKey)patt3469$temp;
                if (!event.getTab().equals(directTabKey.tab())) continue;
                for (ItemStack stack : (List)stacks.get()) {
                    event.getEntries().put((Object)stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
        });
    }

    private static interface TabKey {

        public record DirectTabKey(CreativeModeTab tab) implements TabKey
        {
            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DirectTabKey)) {
                    return false;
                }
                DirectTabKey that = (DirectTabKey)o;
                return this.tab == that.tab;
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this.tab);
            }
        }

        public record SupplierTabKey(CreativeTabRegistry.TabSupplier supplier) implements TabKey
        {
            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SupplierTabKey)) {
                    return false;
                }
                SupplierTabKey that = (SupplierTabKey)o;
                return Objects.equals(this.supplier.getName(), that.supplier.getName());
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.supplier.getName());
            }
        }
    }
}

